/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui;

import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.gui.Button;
import com.feed_the_beast.ftblib.lib.gui.GuiBase;
import com.feed_the_beast.ftblib.lib.gui.GuiContainerWrapper;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetLayout;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.ImageIcon;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.ContainerTask;
import com.feed_the_beast.ftbquests.gui.GuiQuest;
import com.feed_the_beast.ftbquests.gui.QuestsTheme;
import com.feed_the_beast.ftbquests.net.MessageClaimReward;
import com.feed_the_beast.ftbquests.net.MessageCompleteInstantly;
import com.feed_the_beast.ftbquests.net.MessageResetProgress;
import com.feed_the_beast.ftbquests.net.edit.MessageEditObject;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestReward;
import com.feed_the_beast.ftbquests.quest.tasks.QuestTask;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class GuiTask
extends GuiBase {
    private static final ImageIcon TEXTURE = new ImageIcon(new ResourceLocation("ftbquests", "textures/gui/task.png"));
    private static final ImageIcon BACKGROUND = TEXTURE.withUVfromCoords(0, 0, 176, 214, 256, 256);
    private static final ImageIcon TAB = TEXTURE.withUVfromCoords(177, 0, 21, 20, 256, 256);
    public final ContainerTask container;
    public final ClientQuestFile questFile;
    public final boolean hasTile;
    public final Panel tabs;
    public final String taskName;
    public final Icon taskIcon;

    public GuiTask(ContainerTask c) {
        this.setSize(176, 214);
        this.container = c;
        this.questFile = ClientQuestFile.INSTANCE;
        this.hasTile = this.container.screen != null && !this.container.screen.func_145837_r();
        this.tabs = new Panel((Panel)this){

            public void addWidgets() {
                this.add((Widget)new Tab(this, I18n.func_135052_a((String)"gui.back", (Object[])new Object[0]), "", GuiIcons.LEFT, button -> GuiTask.this.onBack()));
                if (!((QuestTask)GuiTask.this.container.data.task).quest.rewards.isEmpty()) {
                    this.add((Widget)new Tab(this, I18n.func_135052_a((String)"ftbquests.rewards", (Object[])new Object[0]) + ":", "", GuiIcons.MONEY_BAG, button -> {
                        if (((QuestTask)GuiTask.this.container.data.task).isComplete(GuiTask.this.container.data.teamData)) {
                            for (QuestReward reward : ((QuestTask)GuiTask.this.container.data.task).quest.rewards) {
                                new MessageClaimReward(reward.uid).sendToServer();
                            }
                        }
                    }){

                        public void addMouseOverText(List<String> list) {
                            super.addMouseOverText(list);
                            for (QuestReward reward : ((QuestTask)GuiTask.this.container.data.task).quest.rewards) {
                                list.add(TextFormatting.GRAY + (ClientQuestFile.INSTANCE.isRewardClaimed(reward) ? TextFormatting.STRIKETHROUGH.toString() : "") + "- " + reward.stack.func_190916_E() + "x " + TextFormatting.func_110646_a((String)reward.stack.func_82833_r()) + (reward.team ? TextFormatting.BLUE + " [" + I18n.func_135052_a((String)"ftbquests.reward.team_reward", (Object[])new Object[0]) + "]" : ""));
                            }
                        }
                    });
                }
                if (GuiTask.this.questFile.canEdit()) {
                    this.add((Widget)new Tab(this, I18n.func_135052_a((String)"selectServer.edit", (Object[])new Object[0]), "", GuiIcons.SETTINGS, button -> new MessageEditObject(((QuestTask)GuiTask.this.container.data.task).getID()).sendToServer()));
                    if (GuiTask.this.container.data.getProgress() > 0L) {
                        this.add((Widget)new Tab(this, I18n.func_135052_a((String)"ftbquests.gui.reset_progress", (Object[])new Object[0]), I18n.func_135052_a((String)"ftbquests.gui.reset_progress_q", (Object[])new Object[0]), GuiIcons.REFRESH, button -> {
                            new MessageResetProgress(((QuestTask)GuiTask.this.container.data.task).getID()).sendToServer();
                            GuiTask.this.container.data.resetProgress();
                            GuiTask.this.tabs.refreshWidgets();
                        }));
                    }
                    if (GuiTask.this.container.data.getProgress() < ((QuestTask)GuiTask.this.container.data.task).getMaxProgress()) {
                        this.add((Widget)new Tab(this, I18n.func_135052_a((String)"ftbquests.gui.complete_instantly", (Object[])new Object[0]), I18n.func_135052_a((String)"ftbquests.gui.complete_instantly_q", (Object[])new Object[0]), QuestsTheme.COMPLETED, button -> {
                            new MessageCompleteInstantly(((QuestTask)GuiTask.this.container.data.task).getID()).sendToServer();
                            GuiTask.this.container.data.completeInstantly();
                            GuiTask.this.tabs.refreshWidgets();
                        }));
                    }
                }
                ArrayList<Tab> extra = new ArrayList<Tab>();
                GuiTask.this.container.data.addTabs(extra);
                this.addAll(extra);
            }

            public void alignWidgets() {
                this.setHeight(this.align((WidgetLayout)new WidgetLayout.Vertical(0, 1, 0)));
            }
        };
        this.tabs.setPosAndSize(-17, 8, 20, 0);
        this.taskName = ((QuestObject)this.container.data.task).getDisplayName().func_150254_d();
        this.taskIcon = ((QuestObject)this.container.data.task).getIcon();
    }

    public void addWidgets() {
        this.add((Widget)this.tabs);
    }

    public GuiScreen getWrapper() {
        return new GuiContainerWrapper((GuiBase)this, (Container)this.container).disableSlotDrawing();
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BACKGROUND.draw(x, y, w, h);
        String top1 = ((QuestTask)this.container.data.task).quest.getDisplayName().func_150260_c();
        String top2 = ((QuestObject)this.container.data.task).getDisplayName().func_150260_c();
        if (top1.isEmpty() || top1.equals(top2)) {
            top1 = top2;
            top2 = "";
        }
        top1 = TextFormatting.BOLD + top1;
        theme.drawString(top1, x + (w - theme.getStringWidth(top1)) / 2, y + 14);
        if (!top2.isEmpty()) {
            top2 = TextFormatting.GRAY + top2;
            theme.drawString(top2, x + (w - theme.getStringWidth(top2)) / 2, y + 30);
        }
        ((QuestTask)this.container.data.task).drawGUI(this.container.data, x + (w - 64) / 2, y + 42, 64, 64);
        if (!((QuestTask)this.container.data.task).hideProgressNumbers()) {
            String bottomText = this.container.data.getProgressString() + " / " + ((QuestTask)this.container.data.task).getMaxProgressString();
            if (this.container.data.getProgress() >= ((QuestTask)this.container.data.task).getMaxProgress()) {
                theme.drawString(TextFormatting.GREEN + bottomText, x + (w - theme.getStringWidth(bottomText)) / 2, y + 112);
            } else {
                theme.drawString(bottomText, x + (w - theme.getStringWidth(bottomText)) / 2, y + 112);
            }
        }
    }

    public boolean mousePressed(MouseButton button) {
        if (super.mousePressed(button)) {
            return true;
        }
        if (this.container.func_75140_a((EntityPlayer)ClientUtils.MC.field_71439_g, button.isLeft() ? 0 : 1)) {
            ClientUtils.MC.field_71442_b.func_78756_a(this.container.field_75152_c, button.isLeft() ? 0 : 1);
            return true;
        }
        return false;
    }

    public Theme getTheme() {
        return QuestsTheme.INSTANCE;
    }

    public void onBack() {
        this.questFile.questGui = new GuiQuest(this.questFile.questTreeGui, ((QuestTask)this.container.data.task).quest);
        this.questFile.questGui.openGui();
    }

    public static class Tab
    extends Button {
        public String yesNoText;
        public final Consumer<MouseButton> callback;

        public Tab(Panel panel, String title, String yn, Icon icon, Consumer<MouseButton> c) {
            super(panel, title, icon);
            this.setSize(20, 20);
            this.yesNoText = yn;
            this.callback = c;
        }

        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            if (this.yesNoText.isEmpty()) {
                this.callback.accept(button);
            } else {
                this.getGui().openYesNo(this.yesNoText, "", () -> this.callback.accept(button));
            }
        }

        public void draw(Theme theme, int x, int y, int w, int h) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TAB.draw(x, y, w, h);
            this.drawIcon(theme, x + 3, y + 2, 16, 16);
        }
    }
}

