/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui;

import com.feed_the_beast.ftblib.FTBLibConfig;
import com.feed_the_beast.ftblib.lib.config.ConfigString;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.gui.Button;
import com.feed_the_beast.ftblib.lib.gui.ContextMenu;
import com.feed_the_beast.ftblib.lib.gui.ContextMenuItem;
import com.feed_the_beast.ftblib.lib.gui.GuiBase;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetLayout;
import com.feed_the_beast.ftblib.lib.gui.WidgetType;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiEditConfigValue;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.ItemIcon;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.client.ClientQuestProgress;
import com.feed_the_beast.ftbquests.gui.GuiEmergencyItems;
import com.feed_the_beast.ftbquests.gui.GuiQuest;
import com.feed_the_beast.ftbquests.gui.GuiVariables;
import com.feed_the_beast.ftbquests.gui.QuestsTheme;
import com.feed_the_beast.ftbquests.net.MessageCompleteInstantly;
import com.feed_the_beast.ftbquests.net.MessageResetProgress;
import com.feed_the_beast.ftbquests.net.edit.MessageChangeID;
import com.feed_the_beast.ftbquests.net.edit.MessageCreateObject;
import com.feed_the_beast.ftbquests.net.edit.MessageEditObject;
import com.feed_the_beast.ftbquests.net.edit.MessageMoveChapter;
import com.feed_the_beast.ftbquests.net.edit.MessageMoveQuest;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.QuestReward;
import com.feed_the_beast.ftbquests.quest.tasks.DependencyTask;
import com.feed_the_beast.ftbquests.quest.tasks.QuestTask;
import com.feed_the_beast.ftbquests.quest.tasks.QuestTaskType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;

public class GuiQuestTree
extends GuiBase {
    public static int zoom = 24;
    public final ClientQuestFile questFile;
    private int scrollWidth;
    private int scrollHeight;
    private int prevMouseX;
    private int prevMouseY;
    private int grabbed;
    public QuestChapter selectedChapter;
    private String selectedQuest = "";
    public final Panel chapterPanel;
    public final Panel quests;
    public Color4I borderColor;
    public Color4I backgroundColor;
    public final Panel otherButtons;
    public boolean movingQuest = false;

    public GuiQuestTree(ClientQuestFile q) {
        this.questFile = q;
        this.chapterPanel = new Panel((Panel)this){

            public void addWidgets() {
                for (int i = 0; i < GuiQuestTree.this.questFile.chapters.size(); ++i) {
                    this.add((Widget)new ButtonChapter((Panel)this, i, (QuestChapter)GuiQuestTree.this.questFile.chapters.get(i)));
                }
                if (GuiQuestTree.this.questFile.canEdit() && GuiQuestTree.this.questFile.chapters.size() < 14) {
                    this.add((Widget)new ButtonAddChapter(this));
                }
            }

            public void alignWidgets() {
                this.setX(1);
                this.setWidth(this.getGui().width - GuiQuestTree.this.otherButtons.width - 2);
                this.align((WidgetLayout)new WidgetLayout.Horizontal(0, 1, 0));
            }
        };
        this.chapterPanel.setHeight(20);
        this.selectedChapter = this.questFile.chapters.isEmpty() ? null : (QuestChapter)this.questFile.chapters.get(0);
        this.borderColor = Color4I.WHITE.withAlpha(88);
        this.backgroundColor = Color4I.WHITE.withAlpha(33);
        this.quests = new Panel((Panel)this){

            public void addWidgets() {
                if (GuiQuestTree.this.selectedChapter == null) {
                    return;
                }
                if (GuiQuestTree.this.questFile.canEdit()) {
                    for (int y = -25; y <= 25; ++y) {
                        for (int x = -25; x <= 25; ++x) {
                            this.add(new ButtonDummyQuest(this, (byte)x, (byte)y));
                        }
                    }
                    int s = 51;
                    for (Quest quest : GuiQuestTree.this.selectedChapter.quests) {
                        this.widgets.set(quest.x + 25 + (quest.y + 25) * s, new ButtonQuest(this, quest));
                    }
                } else {
                    for (Quest quest : GuiQuestTree.this.selectedChapter.quests) {
                        this.widgets.add(new ButtonQuest(this, quest));
                    }
                }
            }

            public void alignWidgets() {
                GuiQuestTree.this.scrollWidth = 0;
                GuiQuestTree.this.scrollHeight = 0;
                int minX = 26;
                int minY = 26;
                int maxX = -26;
                int maxY = -26;
                for (Widget widget : this.widgets) {
                    if (!(widget instanceof ButtonQuest)) continue;
                    Quest quest = ((ButtonQuest)widget).quest;
                    minX = Math.min(minX, quest.x);
                    minY = Math.min(minY, quest.y);
                    maxX = Math.max(maxX, quest.x);
                    maxY = Math.max(maxY, quest.y);
                }
                minX -= 6;
                minY -= 6;
                maxY += 6;
                int bsize = zoom * 5 / 4;
                int bspace = zoom * 3 / 2;
                int offset = bspace - bsize;
                GuiQuestTree.this.scrollWidth = offset + ((maxX += 6) - minX + 1) * bspace;
                GuiQuestTree.this.scrollHeight = offset + (maxY - minY + 1) * bspace;
                for (Widget widget : this.widgets) {
                    byte y;
                    byte x;
                    if (widget instanceof ButtonQuest) {
                        Quest quest = ((ButtonQuest)widget).quest;
                        x = quest.x;
                        y = quest.y;
                    } else {
                        ButtonDummyQuest button = (ButtonDummyQuest)widget;
                        x = button.x;
                        y = button.y;
                    }
                    widget.setPosAndSize(offset + (x - minX) * bspace, offset + (y - minY) * bspace, bsize, bsize);
                }
                this.setPosAndSize(0, GuiQuestTree.this.chapterPanel.height, this.getGui().width, this.getGui().height - GuiQuestTree.this.chapterPanel.height);
            }

            public void drawOffsetBackground(Theme theme, int x, int y, int w, int h) {
                GlStateManager.func_179090_x();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_187441_d((float)3.0f);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder buffer = tessellator.func_178180_c();
                buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
                GlStateManager.func_179103_j((int)7425);
                for (Widget widget : this.widgets) {
                    if (!(widget instanceof ButtonQuest)) continue;
                    for (ButtonQuest b : ((ButtonQuest)widget).getDependencies()) {
                        buffer.func_181662_b((double)widget.getX() + (double)widget.width / 2.0, (double)widget.getY() + (double)widget.height / 2.0, 0.0).func_181669_b(100, 200, 100, 255).func_181675_d();
                        buffer.func_181662_b((double)b.getX() + (double)b.width / 2.0, (double)b.getY() + (double)b.height / 2.0, 0.0).func_181669_b(50, 50, 50, 255).func_181675_d();
                    }
                }
                tessellator.func_78381_a();
                GlStateManager.func_187441_d((float)1.0f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179098_w();
                GlStateManager.func_179103_j((int)7424);
            }

            public boolean mousePressed(MouseButton button) {
                boolean b = super.mousePressed(button);
                if (!b && button.isLeft() && this.isMouseOver()) {
                    GuiQuestTree.this.prevMouseX = this.getMouseX();
                    GuiQuestTree.this.prevMouseY = this.getMouseY();
                    GuiQuestTree.this.grabbed = 1;
                    b = true;
                }
                return b;
            }

            public void mouseReleased(MouseButton button) {
                super.mouseReleased(button);
                GuiQuestTree.this.grabbed = 0;
            }
        };
        this.otherButtons = new Panel((Panel)this){

            public void addWidgets() {
                if (!GuiQuestTree.this.questFile.emergencyItems.isEmpty() && (GuiQuestTree.this.questFile.self != null || GuiQuestTree.this.questFile.canEdit())) {
                    this.add((Widget)new ButtonEmergencyItems(this));
                }
                this.add((Widget)new ButtonWiki(this));
                if (GuiQuestTree.this.questFile.canEdit()) {
                    this.add((Widget)new ButtonEditSettings(this));
                }
            }

            public void alignWidgets() {
                this.setSize(this.align((WidgetLayout)new WidgetLayout.Horizontal(1, 1, 0)), GuiQuestTree.this.chapterPanel.height);
            }
        };
    }

    public void addWidgets() {
        this.add((Widget)this.chapterPanel);
        this.add((Widget)this.quests);
        this.add((Widget)this.otherButtons);
    }

    public void alignWidgets() {
        this.otherButtons.setX(this.width - this.otherButtons.width - 1);
        this.chapterPanel.alignWidgets();
        this.resetScroll(true);
    }

    public boolean onInit() {
        return this.setFullscreen();
    }

    public void selectChapter(@Nullable QuestChapter chapter) {
        if (this.selectedChapter != chapter) {
            this.selectedChapter = chapter;
            this.quests.setScrollX(0);
            this.quests.setScrollY(0);
            this.selectedQuest = "";
            this.movingQuest = false;
            this.quests.refreshWidgets();
            this.resetScroll(true);
        }
    }

    public void resetScroll(boolean realign) {
        if (realign) {
            this.quests.alignWidgets();
        }
        this.quests.setScrollX((this.scrollWidth - this.quests.width) / 2);
        this.quests.setScrollY((this.scrollHeight - this.quests.height) / 2);
    }

    public void addObjectMenuItems(List<ContextMenuItem> contextMenu, GuiBase prevGui, QuestObject object) {
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"selectServer.edit", (Object[])new Object[0]), GuiIcons.SETTINGS, () -> new MessageEditObject(object.getID()).sendToServer()));
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"selectServer.delete", (Object[])new Object[0]), GuiIcons.REMOVE, () -> this.questFile.deleteObject(object.getID())).setYesNo(I18n.func_135052_a((String)"delete_item", (Object[])new Object[]{object.getDisplayName().func_150254_d()})));
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.reset_progress", (Object[])new Object[0]), GuiIcons.REFRESH, () -> new MessageResetProgress(object.getID()).sendToServer()).setYesNo(I18n.func_135052_a((String)"ftbquests.gui.reset_progress_q", (Object[])new Object[0])));
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.complete_instantly", (Object[])new Object[0]), QuestsTheme.COMPLETED, () -> new MessageCompleteInstantly(object.getID()).sendToServer()).setYesNo(I18n.func_135052_a((String)"ftbquests.gui.complete_instantly_q", (Object[])new Object[0])));
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.change_id", (Object[])new Object[0]), GuiIcons.NOTES, () -> new GuiEditConfigValue("id", (ConfigValue)new ConfigString(object.id, QuestObject.ID_PATTERN), (value, set) -> {
            prevGui.openGui();
            if (set) {
                new MessageChangeID(object.getID(), value.getString()).sendToServer();
            }
        }).openGui()));
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.copy_id", (Object[])new Object[0]), GuiIcons.INFO, () -> GuiQuestTree.setClipboardString((String)object.getID())));
    }

    public boolean keyPressed(int key, char keyChar) {
        if (super.keyPressed(key, keyChar)) {
            return true;
        }
        if (key == 15) {
            if (this.selectedChapter != null && !this.questFile.chapters.isEmpty()) {
                this.selectChapter((QuestChapter)this.questFile.chapters.get((this.selectedChapter.chapterIndex + 1) % this.questFile.chapters.size()));
            }
        } else if (keyChar >= '1' && keyChar <= '9') {
            int i = keyChar - 49;
            if (i < this.questFile.chapters.size()) {
                this.selectChapter((QuestChapter)this.questFile.chapters.get(i));
            }
        } else if (this.selectedChapter != null && this.questFile.canEdit() && GuiQuestTree.isCtrlKeyDown() && !GuiQuestTree.isShiftKeyDown() && !GuiQuestTree.isAltKeyDown()) {
            switch (key) {
                case 32: {
                    this.selectedQuest = "";
                    this.movingQuest = false;
                }
            }
        }
        return false;
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        if (this.selectedChapter != null && this.selectedChapter.invalid) {
            this.selectChapter(null);
        }
        if (this.selectedChapter == null && !this.questFile.chapters.isEmpty()) {
            this.selectChapter((QuestChapter)this.questFile.chapters.get(0));
        }
        super.drawBackground(theme, x, y, w, h);
        if (this.grabbed != 0) {
            int mx = this.getMouseX();
            int my = this.getMouseY();
            if (this.scrollWidth > this.quests.width) {
                this.quests.setScrollX(Math.max(Math.min(this.quests.getScrollX() + (this.prevMouseX - mx), this.scrollWidth - this.quests.width), 0));
            } else {
                this.quests.setScrollX((this.scrollWidth - this.quests.width) / 2);
            }
            if (this.scrollHeight > this.quests.height) {
                this.quests.setScrollY(Math.max(Math.min(this.quests.getScrollY() + (this.prevMouseY - my), this.scrollHeight - this.quests.height), 0));
            } else {
                this.quests.setScrollY((this.scrollHeight - this.quests.height) / 2);
            }
            this.prevMouseX = mx;
            this.prevMouseY = my;
        }
    }

    public boolean mouseScrolled(int scroll) {
        if (this.selectedChapter != null) {
            if (scroll > 0) {
                if (zoom < 24) {
                    zoom += 4;
                    this.grabbed = 0;
                    this.resetScroll(true);
                    return true;
                }
            } else if (scroll < 0 && zoom > 8) {
                zoom -= 4;
                this.grabbed = 0;
                this.resetScroll(true);
                return true;
            }
        }
        return super.mouseScrolled(scroll);
    }

    public void drawForeground(Theme theme, int x, int y, int w, int h) {
        GuiHelper.drawHollowRect((int)x, (int)y, (int)w, (int)h, (Color4I)this.borderColor, (boolean)false);
        int start = 1;
        if (!this.chapterPanel.widgets.isEmpty()) {
            Widget last = (Widget)this.chapterPanel.widgets.get(this.chapterPanel.widgets.size() - 1);
            start = last.getX() + last.width + 1;
        }
        this.backgroundColor.draw(start, y + 1, w - start - this.otherButtons.width - 1, this.chapterPanel.height - 2);
        this.borderColor.draw(start, y + this.chapterPanel.height - 1, w - start - 1, 1);
        super.drawForeground(theme, x, y, w, h);
    }

    public Theme getTheme() {
        return QuestsTheme.INSTANCE;
    }

    public boolean drawDefaultBackground() {
        return false;
    }

    public class ButtonDummyQuest
    extends Widget {
        public final byte x;
        public final byte y;

        public ButtonDummyQuest(Panel panel, byte _x, byte _y) {
            super(panel);
            this.setSize(20, 20);
            this.x = _x;
            this.y = _y;
        }

        public boolean mousePressed(MouseButton button) {
            if (this.isMouseOver() && GuiQuestTree.this.questFile.canEdit()) {
                if (button.isRight()) {
                    GuiHelper.playClickSound();
                    new GuiEditConfigValue("title", (ConfigValue)new ConfigString(""), (value, set) -> {
                        GuiQuestTree.this.openGui();
                        if (set) {
                            NBTTagCompound nbt = new NBTTagCompound();
                            nbt.func_74774_a("x", this.x);
                            nbt.func_74774_a("y", this.y);
                            nbt.func_74778_a("title", value.getString());
                            nbt.func_74778_a("id", QuestObject.customId(value.getString()));
                            new MessageCreateObject(QuestObjectType.QUEST, GuiQuestTree.this.selectedChapter.getID(), nbt).sendToServer();
                        }
                    }).openGui();
                    return true;
                }
                if (button.isLeft() && GuiQuestTree.this.movingQuest && !GuiQuestTree.this.selectedQuest.isEmpty()) {
                    GuiHelper.playClickSound();
                    GuiQuestTree.this.movingQuest = false;
                    new MessageMoveQuest(GuiQuestTree.this.selectedQuest, this.x, this.y).sendToServer();
                    GuiQuestTree.this.selectedQuest = "";
                    return true;
                }
            }
            return false;
        }

        public void addMouseOverText(List<String> list) {
            if (GuiQuestTree.this.movingQuest && !GuiQuestTree.this.selectedQuest.isEmpty()) {
                list.add(I18n.func_135052_a((String)"ftbquests.gui.move", (Object[])new Object[0]));
            }
        }

        public void draw(Theme theme, int x, int y, int w, int h) {
            if (GuiQuestTree.this.questFile.canEdit() && ButtonDummyQuest.isAltKeyDown()) {
                Color4I.WHITE.withAlpha(30).draw(x, y, w, h);
            }
            if (this.isMouseOver()) {
                Color4I.WHITE.withAlpha(30).draw(x, y, w, h);
            }
        }
    }

    public class ButtonQuest
    extends Button {
        public Quest quest;
        public String description;
        public List<ButtonQuest> dependencies;

        public ButtonQuest(Panel panel, Quest q) {
            super(panel, q.getDisplayName().func_150254_d(), q.getIcon());
            this.dependencies = null;
            this.setSize(20, 20);
            this.quest = q;
            this.description = TextFormatting.GRAY + this.quest.description;
            if (TextFormatting.func_110646_a((String)this.description).isEmpty()) {
                this.description = "";
            }
        }

        public List<ButtonQuest> getDependencies() {
            if (this.dependencies == null) {
                this.dependencies = new ArrayList<ButtonQuest>();
                for (QuestTask task : this.quest.tasks) {
                    QuestObject dep = task.getDependency();
                    if (!(dep instanceof Quest)) continue;
                    for (Widget widget : GuiQuestTree.this.quests.widgets) {
                        if (!(widget instanceof ButtonQuest) || dep != ((ButtonQuest)widget).quest) continue;
                        this.dependencies.add((ButtonQuest)widget);
                    }
                }
                this.dependencies = this.dependencies.isEmpty() ? Collections.emptyList() : this.dependencies;
            }
            return this.dependencies;
        }

        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            if (GuiQuestTree.this.questFile.canEdit() && button.isRight()) {
                int index;
                ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
                contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.move", (Object[])new Object[0]), GuiIcons.UP, () -> {
                    GuiQuestTree.this.selectedQuest = this.quest.getID();
                    GuiQuestTree.this.movingQuest = true;
                }));
                Quest object = GuiQuestTree.this.questFile.getQuest(GuiQuestTree.this.selectedQuest);
                int n = index = object == null || object == this.quest ? -1 : this.quest.hasDependency(object);
                if (index != -1) {
                    contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.rem_dep", (Object[])new Object[0]), GuiIcons.REMOVE, () -> GuiQuestTree.this.questFile.deleteObject(this.quest.tasks.get(index).getID())));
                } else {
                    contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.set_dep", (Object[])new Object[0]), QuestsTheme.ADD, () -> {
                        NBTTagCompound nbt = new NBTTagCompound();
                        nbt.func_74778_a("object", GuiQuestTree.this.selectedQuest);
                        nbt.func_74778_a("type", QuestTaskType.getTypeForNBT(DependencyTask.QuestDep.class));
                        nbt.func_74778_a("id", QuestObject.customId("dep_" + GuiQuestTree.this.selectedQuest));
                        new MessageCreateObject(QuestObjectType.TASK, this.quest.getID(), nbt).sendToServer();
                    }).setEnabled(object != null && object != this.quest));
                }
                contextMenu.add(ContextMenuItem.SEPARATOR);
                GuiQuestTree.this.addObjectMenuItems(contextMenu, this.getGui(), this.quest);
                this.getGui().openContextMenu(contextMenu);
            } else if (GuiQuestTree.this.questFile.canEdit() && button.isLeft() && ButtonQuest.isCtrlKeyDown()) {
                if (GuiQuestTree.this.selectedQuest.equals(this.quest.getID())) {
                    GuiQuestTree.this.selectedQuest = "";
                } else {
                    GuiQuestTree.this.selectedQuest = this.quest.getID();
                }
            } else if (button.isLeft()) {
                GuiQuestTree.this.questFile.questGui = new GuiQuest(GuiQuestTree.this, this.quest);
                GuiQuestTree.this.questFile.questGui.openGui();
            }
        }

        public void addMouseOverText(List<String> list) {
            list.add(this.getTitle() + ClientQuestProgress.getCompletionSuffix(GuiQuestTree.this.questFile.self, this.quest));
            if (!this.description.isEmpty()) {
                list.add(this.description);
            }
            boolean addedText = false;
            for (QuestTask task : this.quest.tasks) {
                QuestObject dep = task.getDependency();
                if (dep == null) continue;
                if (!addedText) {
                    list.add("");
                    list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"ftbquests.dependencies", (Object[])new Object[0]) + ":");
                    addedText = true;
                }
                list.add(TextFormatting.DARK_GRAY + "- " + dep.getObjectType().getColor() + dep.getDisplayName().func_150260_c());
            }
        }

        public WidgetType getWidgetType() {
            if (GuiQuestTree.this.selectedQuest.equals(this.quest.getID())) {
                return WidgetType.MOUSE_OVER;
            }
            return GuiQuestTree.this.questFile.editingMode || this.quest.getVisibility(GuiQuestTree.this.questFile.self).isVisible() ? super.getWidgetType() : WidgetType.DISABLED;
        }

        public void draw(Theme theme, int x, int y, int w, int h) {
            GlStateManager.func_179092_a((int)516, (float)0.0f);
            QuestsTheme.BUTTON.draw(x - zoom / 6, y - zoom / 6, w + zoom / 3, h + zoom / 3);
            if (this.isMouseOver()) {
                QuestsTheme.BUTTON.draw(x - zoom / 6, y - zoom / 6, w + zoom / 3, h + zoom / 3);
            }
            if (!GuiQuestTree.this.selectedQuest.isEmpty() && GuiQuestTree.this.selectedQuest.equals(this.quest.getID())) {
                QuestsTheme.BUTTON.draw(x - zoom / 6, y - zoom / 6, w + zoom / 3, h + zoom / 3, Color4I.WHITE.withAlpha((int)(Math.sin((double)System.currentTimeMillis() * 0.005) * 127.0 + 127.0)));
            }
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            if (!this.icon.isEmpty()) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)((float)x + (float)(this.width - zoom) / 2.0f), (float)((float)y + (float)(h - zoom) / 2.0f), (float)0.0f);
                this.icon.draw(0, 0, zoom, zoom);
                GlStateManager.func_179121_F();
            }
            if (GuiQuestTree.this.questFile.self != null && this.quest.isComplete(GuiQuestTree.this.questFile.self)) {
                int r = 0;
                for (QuestReward reward : this.quest.rewards) {
                    if (GuiQuestTree.this.questFile.isRewardClaimed(reward)) continue;
                    ++r;
                }
                if (r > 0) {
                    String s = Integer.toString(r);
                    int nw = theme.getStringWidth(s);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)((float)(x + this.width - nw) - (float)zoom / 8.0f), (float)((float)y + (float)zoom / 8.0f), (float)500.0f);
                    theme.drawString(s, -1, 0, Color4I.LIGHT_RED, 0);
                    theme.drawString(s, 1, 0, Color4I.LIGHT_RED, 0);
                    theme.drawString(s, 0, -1, Color4I.LIGHT_RED, 0);
                    theme.drawString(s, 0, 1, Color4I.LIGHT_RED, 0);
                    theme.drawString(s, 0, 0, Color4I.WHITE, 0);
                    GlStateManager.func_179121_F();
                } else {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
                    QuestsTheme.COMPLETED.draw(x + this.width - 1 - zoom / 2, y + 1, zoom / 2, zoom / 2);
                    GlStateManager.func_179121_F();
                }
            }
        }
    }

    public class ButtonWiki
    extends ButtonTab {
        public ButtonWiki(Panel panel) {
            super(panel, "Wiki", GuiIcons.INFO);
        }

        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            this.handleClick("https://minecraft.curseforge.com/projects/ftb-quests/pages");
        }
    }

    public class ButtonEditSettings
    extends ButtonTab {
        public ButtonEditSettings(Panel panel) {
            super(panel, "", GuiIcons.SETTINGS);
        }

        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            GuiBase gui = this.getGui();
            if (gui.contextMenu != null) {
                gui.openContextMenu((Panel)null);
                return;
            }
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.edit_file", (Object[])new Object[0]), GuiIcons.SETTINGS, () -> new MessageEditObject(GuiQuestTree.this.questFile.getID()).sendToServer()));
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.reset_progress", (Object[])new Object[0]), GuiIcons.REFRESH, () -> new MessageResetProgress(GuiQuestTree.this.questFile.getID()).sendToServer()).setYesNo(I18n.func_135052_a((String)"ftbquests.gui.reset_progress_q", (Object[])new Object[0])));
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.complete_instantly", (Object[])new Object[0]), QuestsTheme.COMPLETED, () -> new MessageCompleteInstantly(GuiQuestTree.this.questFile.getID()).sendToServer()).setYesNo(I18n.func_135052_a((String)"ftbquests.gui.complete_instantly_q", (Object[])new Object[0])));
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.variables", (Object[])new Object[0]), GuiIcons.CONTROLLER, () -> new GuiVariables().openGui()));
            if (FTBLibConfig.debugging.gui_widget_bounds) {
                contextMenu.add(new ContextMenuItem("Reload GUI", GuiIcons.REFRESH, () -> {
                    ClientQuestFile.INSTANCE.clearCachedData();
                    GuiQuestTree.this.questFile.refreshGui(GuiQuestTree.this.questFile);
                }));
            }
            ContextMenu panel = gui.openContextMenu(contextMenu);
            panel.setPos(gui.width - panel.width - 2, this.height + 1);
        }
    }

    public class ButtonEmergencyItems
    extends ButtonTab {
        public ButtonEmergencyItems(Panel panel) {
            super(panel, I18n.func_135052_a((String)"ftbquests.file.emergency_items", (Object[])new Object[0]), ItemIcon.getItemIcon((ItemStack)new ItemStack(Blocks.field_150477_bB)));
        }

        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            new GuiEmergencyItems().openGui();
        }
    }

    public class ButtonAddChapter
    extends ButtonTab {
        public ButtonAddChapter(Panel panel) {
            super(panel, I18n.func_135052_a((String)"gui.add", (Object[])new Object[0]), QuestsTheme.ADD);
        }

        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            new GuiEditConfigValue("title", (ConfigValue)new ConfigString("", Pattern.compile("^.+$")), (value, set) -> {
                GuiQuestTree.this.openGui();
                if (set) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    nbt.func_74778_a("title", value.getString());
                    nbt.func_74778_a("id", QuestObject.customId(value.getString()));
                    new MessageCreateObject(QuestObjectType.CHAPTER, "", nbt).sendToServer();
                }
            }).openGui();
        }

        @Override
        public void draw(Theme theme, int x, int y, int w, int h) {
            GuiQuestTree.this.borderColor.draw(x, y + h - 1, w + 1, 1);
            GuiQuestTree.this.backgroundColor.draw(x, y + 1, w, h - 2);
            GuiQuestTree.this.borderColor.draw(x + w, y + 1, 1, h - 2);
            this.icon.draw(x + (w - 16) / 2, y + (h - 16) / 2, 16, 16);
            if (this.isMouseOver()) {
                GuiQuestTree.this.backgroundColor.draw(x, y + 1, w, h - 2);
            }
        }
    }

    public class ButtonChapter
    extends ButtonTab {
        public int index;
        public QuestChapter chapter;
        public List<String> description;

        public ButtonChapter(Panel panel, int idx, QuestChapter c) {
            super(panel, c.getDisplayName().func_150254_d(), c.getIcon());
            this.index = idx;
            this.chapter = c;
            this.description = new ArrayList<String>();
            for (String v : this.chapter.description) {
                this.description.add(TextFormatting.GRAY + v);
            }
        }

        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            GuiQuestTree.this.selectChapter(this.chapter);
            if (GuiQuestTree.this.questFile.canEdit() && button.isRight()) {
                ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
                contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.move", (Object[])new Object[0]), GuiIcons.LEFT, () -> new MessageMoveChapter(this.chapter.getID(), true).sendToServer()).setEnabled(this.chapter.chapterIndex > 0));
                contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.move", (Object[])new Object[0]), GuiIcons.RIGHT, () -> new MessageMoveChapter(this.chapter.getID(), false).sendToServer()).setEnabled(this.chapter.chapterIndex < GuiQuestTree.this.questFile.chapters.size() - 1));
                contextMenu.add(ContextMenuItem.SEPARATOR);
                GuiQuestTree.this.addObjectMenuItems(contextMenu, this.getGui(), this.chapter);
                this.getGui().openContextMenu(contextMenu);
            }
        }

        public void addMouseOverText(List<String> list) {
            list.add(this.getTitle() + ClientQuestProgress.getCompletionSuffix(GuiQuestTree.this.questFile.self, this.chapter));
            list.addAll(this.description);
        }

        @Override
        public void draw(Theme theme, int x, int y, int w, int h) {
            if (GuiQuestTree.this.selectedChapter != this.chapter) {
                GuiQuestTree.this.borderColor.draw(x, y + h - 1, w + 1, 1);
                GuiQuestTree.this.backgroundColor.draw(x, y + 1, w, h - 2);
            } else {
                GuiQuestTree.this.borderColor.draw(x + w, y + h - 1, 1, 1);
            }
            GuiQuestTree.this.borderColor.draw(x + w, y + 1, 1, h - 2);
            this.icon.draw(x + (w - 16) / 2, y + (h - 16) / 2, 16, 16);
            if (this.isMouseOver()) {
                GuiQuestTree.this.backgroundColor.draw(x, y + 1, w, h - (GuiQuestTree.this.selectedChapter == this.chapter ? 1 : 2));
            }
            if (GuiQuestTree.this.questFile.self == null) {
                return;
            }
            int r = 0;
            for (Quest quest : this.chapter.quests) {
                if (!quest.isComplete(GuiQuestTree.this.questFile.self)) continue;
                for (QuestReward reward : quest.rewards) {
                    if (GuiQuestTree.this.questFile.isRewardClaimed(reward)) continue;
                    ++r;
                }
            }
            if (r > 0) {
                String s = Integer.toString(r);
                int nw = theme.getStringWidth(s);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(x + w - nw), (float)(y + 2), (float)500.0f);
                theme.drawString(s, -1, 0, Color4I.LIGHT_RED, 0);
                theme.drawString(s, 1, 0, Color4I.LIGHT_RED, 0);
                theme.drawString(s, 0, -1, Color4I.LIGHT_RED, 0);
                theme.drawString(s, 0, 1, Color4I.LIGHT_RED, 0);
                theme.drawString(s, 0, 0, Color4I.WHITE, 0);
                GlStateManager.func_179121_F();
            } else if (this.chapter.isComplete(GuiQuestTree.this.questFile.self)) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
                QuestsTheme.COMPLETED.draw(x + w - 10, y + 2, 8, 8);
                GlStateManager.func_179121_F();
            }
        }
    }

    public abstract class ButtonTab
    extends Button {
        public ButtonTab(Panel panel, String title, Icon icon) {
            super(panel, title, icon);
            this.setSize(20, GuiQuestTree.this.chapterPanel.height);
        }

        public void draw(Theme theme, int x, int y, int w, int h) {
            GuiQuestTree.this.borderColor.draw(x - 1, y + 1, 1, h - 2);
            GuiQuestTree.this.backgroundColor.draw(x, y + 1, w, h - 2);
            this.icon.draw(x + (w - 16) / 2, y + (h - 16) / 2, 16, 16);
            if (this.isMouseOver()) {
                GuiQuestTree.this.backgroundColor.draw(x, y + 1, w, h - 2);
            }
        }
    }
}

