/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui;

import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.gui.Button;
import com.feed_the_beast.ftblib.lib.gui.GuiBase;
import com.feed_the_beast.ftblib.lib.gui.GuiContainerWrapper;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.PanelScrollBar;
import com.feed_the_beast.ftblib.lib.gui.ScrollBar;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetLayout;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.ImageIcon;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.ContainerQuestChest;
import com.feed_the_beast.ftbquests.gui.QuestsTheme;
import com.feed_the_beast.ftbquests.net.MessageClaimReward;
import com.feed_the_beast.ftbquests.net.MessageOpenTask;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestReward;
import com.feed_the_beast.ftbquests.quest.tasks.QuestTask;
import com.feed_the_beast.ftbquests.quest.tasks.QuestTaskData;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.items.SlotItemHandler;

public class GuiQuestChest
extends GuiBase
implements IContainerListener {
    private static final ImageIcon TEXTURE = new ImageIcon(new ResourceLocation("ftbquests", "textures/gui/chest.png"));
    private static final ImageIcon BACKGROUND = TEXTURE.withUVfromCoords(0, 0, 176, 189, 256, 256);
    private static final ImageIcon SCROLL_BAR = TEXTURE.withUVfromCoords(177, 0, 8, 9, 256, 256);
    private final ContainerQuestChest container;
    private final Panel tasks;
    private final PanelScrollBar scrollBar;
    private final Button transferAll;
    private final Button claimAllRewards;
    private final Button inputSlot;
    private final ButtonReward[] outputSlots;

    public GuiQuestChest(ContainerQuestChest c) {
        this.setSize(176, 189);
        this.container = c;
        c.func_75132_a(this);
        this.tasks = new Panel((Panel)this){

            public void addWidgets() {
                if (ClientQuestFile.existsWithTeam()) {
                    QuestTaskData data;
                    for (QuestTask task : ClientQuestFile.INSTANCE.allTasks) {
                        if (!task.canInsertItem() || (long)(data = ClientQuestFile.INSTANCE.self.getQuestTaskData(task)).getRelativeProgress() != 0L || !((QuestTask)data.task).quest.canStartTasks(ClientQuestFile.INSTANCE.self)) continue;
                        this.add((Widget)new ButtonTask(this, data));
                    }
                    for (QuestTask task : ClientQuestFile.INSTANCE.allTasks) {
                        if (!task.canInsertItem() || (long)(data = ClientQuestFile.INSTANCE.self.getQuestTaskData(task)).getRelativeProgress() != 100L) continue;
                        this.add((Widget)new ButtonTask(this, data));
                    }
                }
            }

            public void alignWidgets() {
                GuiQuestChest.this.scrollBar.setMaxValue(this.align((WidgetLayout)new WidgetLayout.Vertical(0, 1, 1)));
            }
        };
        this.tasks.setPosAndSize(8, 9, 148, 68);
        this.scrollBar = new PanelScrollBar((Panel)this, ScrollBar.Plane.VERTICAL, this.tasks){

            public int getSliderSize() {
                return this.getMaxValue() <= 0 ? 0 : 9;
            }

            public void drawScrollBar(Theme theme, int x, int y, int w, int h) {
                SCROLL_BAR.draw(x, y, w, h);
            }

            public void drawBackground(Theme theme, int x, int y, int w, int h) {
            }
        };
        this.scrollBar.setCanAlwaysScroll(true);
        this.scrollBar.setCanAlwaysScrollPlane(true);
        this.scrollBar.setPosAndSize(160, 9, 8, 68);
        this.transferAll = new Button((Panel)this, I18n.func_135052_a((String)"tile.ftbquests.chest.transfer_all", (Object[])new Object[0]), (Icon)Icon.EMPTY){

            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                for (Slot slot : ((GuiQuestChest)GuiQuestChest.this).container.field_75151_b) {
                    if (!slot.func_75216_d() || slot instanceof SlotItemHandler) continue;
                    ClientUtils.MC.field_71442_b.func_187098_a(((GuiQuestChest)GuiQuestChest.this).container.field_75152_c, slot.field_75222_d, 0, ClickType.QUICK_MOVE, (EntityPlayer)ClientUtils.MC.field_71439_g);
                }
            }

            public void draw(Theme theme, int x, int y, int w, int h) {
                if (this.isMouseOver()) {
                    Color4I.WHITE.withAlpha(33).draw(x, y, w, h);
                }
            }
        };
        this.transferAll.setPosAndSize(28, 86, 12, 12);
        this.claimAllRewards = new Button((Panel)this, I18n.func_135052_a((String)"ftbquests.reward.claim_all", (Object[])new Object[0]), (Icon)Icon.EMPTY){

            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                if (ClientQuestFile.existsWithTeam()) {
                    for (QuestChapter chapter : ClientQuestFile.INSTANCE.chapters) {
                        for (Quest quest : chapter.quests) {
                            if (!quest.isComplete(ClientQuestFile.INSTANCE.self)) continue;
                            for (QuestReward reward : quest.rewards) {
                                if (ClientQuestFile.INSTANCE.isRewardClaimed(reward)) continue;
                                new MessageClaimReward(reward.uid).sendToServer();
                            }
                        }
                    }
                }
            }

            public void addMouseOverText(List<String> list) {
                list.add(this.getTitle());
                if (ClientQuestFile.existsWithTeam()) {
                    for (QuestChapter chapter : ClientQuestFile.INSTANCE.chapters) {
                        for (Quest quest : chapter.quests) {
                            if (!quest.isComplete(ClientQuestFile.INSTANCE.self)) continue;
                            for (QuestReward reward : quest.rewards) {
                                if (ClientQuestFile.INSTANCE.isRewardClaimed(reward)) continue;
                                list.add(TextFormatting.GRAY + "- " + reward.stack.func_190916_E() + "x " + TextFormatting.func_110646_a((String)reward.stack.func_82833_r()) + (reward.team ? TextFormatting.BLUE + " [" + I18n.func_135052_a((String)"ftbquests.reward.team_reward", (Object[])new Object[0]) + "]" : ""));
                            }
                        }
                    }
                }
            }

            public void draw(Theme theme, int x, int y, int w, int h) {
                if (this.isMouseOver()) {
                    Color4I.WHITE.withAlpha(33).draw(x, y, w, h);
                }
            }
        };
        this.claimAllRewards.setPosAndSize(154, 86, 12, 12);
        this.inputSlot = new Button((Panel)this){

            public void onClicked(MouseButton button) {
                if (GuiQuestChest.this.container.func_75140_a((EntityPlayer)ClientUtils.MC.field_71439_g, 0)) {
                    ClientUtils.MC.field_71442_b.func_78756_a(((GuiQuestChest)GuiQuestChest.this).container.field_75152_c, 0);
                }
            }

            public void addMouseOverText(List<String> list) {
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tile.ftbquests.chest.input", (Object[])new Object[0]));
                list.add(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"tile.ftbquests.chest.input_desc", (Object[])new Object[0]));
            }

            public void draw(Theme theme, int x, int y, int w, int h) {
                if (this.isMouseOver()) {
                    Color4I.WHITE.withAlpha(150).draw(x, y, w, h);
                }
            }
        };
        this.inputSlot.setPosAndSize(8, 84, 16, 16);
        this.outputSlots = new ButtonReward[6];
        for (int i = 0; i < this.outputSlots.length; ++i) {
            this.outputSlots[i] = new ButtonReward((Panel)this);
            this.outputSlots[i].setPosAndSize(44 + i * 18, 84, 16, 16);
        }
    }

    public void addWidgets() {
        this.add((Widget)this.tasks);
        this.add((Widget)this.scrollBar);
        this.add((Widget)this.transferAll);
        this.add((Widget)this.claimAllRewards);
        this.add((Widget)this.inputSlot);
        for (ButtonReward b : this.outputSlots) {
            this.add((Widget)b);
        }
        this.updateRewards();
    }

    public void updateRewards() {
        for (ButtonReward b : this.outputSlots) {
            b.reward = null;
        }
        if (ClientQuestFile.existsWithTeam()) {
            int index = 0;
            for (QuestChapter chapter : ClientQuestFile.INSTANCE.chapters) {
                for (Quest quest : chapter.quests) {
                    if (!quest.isComplete(ClientQuestFile.INSTANCE.self)) continue;
                    for (QuestReward reward : quest.rewards) {
                        if (ClientQuestFile.INSTANCE.isRewardClaimed(reward)) continue;
                        this.outputSlots[index].reward = reward;
                        if (++index != 6) continue;
                        return;
                    }
                }
            }
        }
    }

    public GuiScreen getWrapper() {
        return new GuiContainerWrapper((GuiBase)this, (Container)this.container).disableSlotDrawing();
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BACKGROUND.draw(x, y, w, h);
    }

    public Theme getTheme() {
        return QuestsTheme.INSTANCE;
    }

    public void func_71110_a(Container containerToSend, NonNullList<ItemStack> itemsList) {
        if (this.outputSlots != null) {
            this.updateRewards();
        }
    }

    public void func_71111_a(Container containerToSend, int slotInd, ItemStack stack) {
        if (this.outputSlots != null) {
            this.updateRewards();
        }
    }

    public void func_71112_a(Container containerIn, int varToUpdate, int newValue) {
    }

    public void func_175173_a(Container containerIn, IInventory inventory) {
    }

    private class ButtonReward
    extends Button {
        public QuestReward reward;

        public ButtonReward(Panel panel) {
            super(panel);
            this.reward = null;
        }

        public void onClicked(MouseButton button) {
            if (this.reward != null && this.reward.quest.isComplete(ClientQuestFile.INSTANCE.self) && !ClientQuestFile.INSTANCE.isRewardClaimed(this.reward)) {
                new MessageClaimReward(this.reward.uid).sendToServer();
            }
        }

        public void addMouseOverText(List<String> list) {
            if (this.reward == null) {
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tile.ftbquests.chest.output", (Object[])new Object[0]));
                list.add(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"tile.ftbquests.chest.output_desc", (Object[])new Object[0]));
            } else {
                List tooltip = this.reward.stack.func_82840_a((EntityPlayer)ClientUtils.MC.field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
                list.add(this.reward.stack.func_77953_t().field_77937_e + (String)tooltip.get(0));
                for (int i = 1; i < tooltip.size(); ++i) {
                    list.add(TextFormatting.GRAY + (String)tooltip.get(i));
                }
            }
        }

        public void draw(Theme theme, int x, int y, int w, int h) {
            if (this.reward != null) {
                GuiHelper.drawItem((ItemStack)this.reward.stack, (double)x, (double)y, (boolean)true, (Color4I)Icon.EMPTY);
            }
            if (this.isMouseOver()) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
                Color4I.WHITE.withAlpha(150).draw(x, y, w, h);
                GlStateManager.func_179121_F();
            }
        }
    }

    private class ButtonTask
    extends Button {
        private final QuestTaskData taskData;

        public ButtonTask(Panel panel, QuestTaskData d) {
            super(panel);
            this.taskData = d;
            this.setSize(panel.width, 8);
        }

        public void addMouseOverText(List<String> list) {
            if (((QuestTask)this.taskData.task).quest.chapter.file.chapters.size() > 1) {
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"ftbquests.chapter", (Object[])new Object[0]) + ": " + TextFormatting.YELLOW + ((QuestTask)this.taskData.task).quest.chapter.getDisplayName().func_150254_d());
            }
            list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"ftbquests.quest", (Object[])new Object[0]) + ": " + TextFormatting.YELLOW + ((QuestTask)this.taskData.task).quest.getDisplayName().func_150254_d());
            list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"ftbquests.progress", (Object[])new Object[0]) + ": " + TextFormatting.BLUE + this.taskData.getProgressString() + " / " + ((QuestTask)this.taskData.task).getMaxProgressString());
        }

        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            new MessageOpenTask(((QuestTask)this.taskData.task).getID()).sendToServer();
        }

        public void draw(Theme theme, int x, int y, int w, int h) {
            int r = (int)((long)(this.taskData.getRelativeProgress() * this.width) / 100L);
            if ((long)r > 0L) {
                TEXTURE.withUVfromCoords(0, r >= this.width ? 199 : 190, r, 8, 256, 256).draw(x, y, r, 8);
            }
            ((QuestObject)this.taskData.task).getIcon().draw(x + 1, y, 8, 8);
            theme.drawString(((QuestObject)this.taskData.task).getDisplayName().func_150254_d(), x + 11, y, theme.getContentColor(this.getWidgetType()), 2);
        }
    }
}

