/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigItemStack;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.ConfigValueInstance;
import com.feed_the_beast.ftblib.lib.gui.Button;
import com.feed_the_beast.ftblib.lib.gui.ContextMenuItem;
import com.feed_the_beast.ftblib.lib.gui.GuiBase;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.PanelScrollBar;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetLayout;
import com.feed_the_beast.ftblib.lib.gui.WidgetType;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiEditConfig;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiSelectItemStack;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.ItemIcon;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.client.ClientQuestProgress;
import com.feed_the_beast.ftbquests.gui.GuiQuestTree;
import com.feed_the_beast.ftbquests.gui.QuestsTheme;
import com.feed_the_beast.ftbquests.net.MessageClaimReward;
import com.feed_the_beast.ftbquests.net.edit.MessageAddReward;
import com.feed_the_beast.ftbquests.net.edit.MessageCreateObject;
import com.feed_the_beast.ftbquests.net.edit.MessageEditReward;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.QuestReward;
import com.feed_the_beast.ftbquests.quest.tasks.ItemTask;
import com.feed_the_beast.ftbquests.quest.tasks.QuestTask;
import com.feed_the_beast.ftbquests.quest.tasks.QuestTaskType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;

public class GuiQuest
extends GuiBase {
    public final GuiQuestTree questTreeGui;
    public final Quest quest;
    public final Panel mainPanel;
    public final Button back;
    public final PanelScrollBar scrollBar;
    public final QuestTitle title;
    public final QuestShortDescription shortDescription;
    public final QuestLongDescription longDescription;
    public final Panel tasks;
    public final Panel rewards;

    public GuiQuest(GuiQuestTree ql, Quest q) {
        this.questTreeGui = ql;
        this.quest = q;
        this.mainPanel = new Panel((Panel)this){

            public void addWidgets() {
                this.add(GuiQuest.this.title);
                this.add(GuiQuest.this.shortDescription);
                this.add(GuiQuest.this.longDescription);
                this.add((Widget)GuiQuest.this.tasks);
                this.add((Widget)GuiQuest.this.rewards);
            }

            public void alignWidgets() {
                Theme theme = GuiQuest.this.getTheme();
                this.setPosAndSize(0, 3, this.getGui().width, this.getGui().height - 6);
                GuiQuest.this.title.text = TextFormatting.BOLD + GuiQuest.this.quest.getDisplayName().func_150254_d();
                GuiQuest.this.title.setSize(this.width, 35);
                GuiQuest.this.shortDescription.text.clear();
                GuiQuest.this.shortDescription.text.addAll(theme.listFormattedStringToWidth(GuiQuest.this.quest.description, this.width - 60));
                GuiQuest.this.shortDescription.setSize(this.width, GuiQuest.this.shortDescription.text.size() * 12 + (GuiQuest.this.shortDescription.text.isEmpty() ? 0 : 15));
                GuiQuest.this.longDescription.text.clear();
                for (String s0 : GuiQuest.this.quest.text) {
                    GuiQuest.this.longDescription.text.addAll(theme.listFormattedStringToWidth(s0, this.width - 80));
                }
                GuiQuest.this.longDescription.setSize(this.width, GuiQuest.this.longDescription.text.size() * 12 + (GuiQuest.this.longDescription.text.isEmpty() ? 0 : 15));
                GuiQuest.this.tasks.alignWidgets();
                GuiQuest.this.rewards.alignWidgets();
                GuiQuest.this.scrollBar.setMaxValue(this.align(WidgetLayout.VERTICAL) + 10);
            }
        };
        this.back = new Button((Panel)this, I18n.func_135052_a((String)"gui.back", (Object[])new Object[0]), GuiIcons.LEFT){

            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                this.getGui().onBack();
            }

            public void drawBackground(Theme theme, int x, int y, int w, int h) {
            }
        };
        this.scrollBar = new PanelScrollBar((Panel)this, this.mainPanel);
        this.scrollBar.setScrollStep(12);
        this.title = new QuestTitle(this.mainPanel);
        this.shortDescription = new QuestShortDescription(this.mainPanel);
        this.longDescription = new QuestLongDescription(this.mainPanel);
        this.tasks = new Panel(this.mainPanel){

            public void addWidgets() {
                for (QuestTask task : GuiQuest.this.quest.tasks) {
                    if (!GuiQuest.this.questTreeGui.questFile.canEdit() && task.getDependency() != null || task.getDependency() instanceof Quest && ((Quest)task.getDependency()).chapter == GuiQuest.this.quest.chapter) continue;
                    this.add((Widget)new ButtonTask(this, task));
                }
                if (GuiQuest.this.questTreeGui.questFile.canEdit()) {
                    this.add((Widget)new ButtonAddTask(this));
                }
            }

            public void alignWidgets() {
                if (this.widgets.isEmpty()) {
                    this.setSize(this.width, 0);
                } else {
                    this.setSize(this.align((WidgetLayout)new WidgetLayout.Horizontal(3, 8, 3)), 50);
                    this.setX((this.getGui().width - this.width) / 2);
                }
            }

            public void drawBackground(Theme theme, int x, int y, int w, int h) {
                theme.drawString(TextFormatting.RED + I18n.func_135052_a((String)"ftbquests.tasks", (Object[])new Object[0]), x + w / 2, y + 5, 4);
            }
        };
        this.rewards = new Panel(this.mainPanel){

            public void addWidgets() {
                for (QuestReward reward : GuiQuest.this.quest.rewards) {
                    this.add((Widget)new ButtonReward(this, reward));
                }
                if (GuiQuest.this.questTreeGui.questFile.canEdit()) {
                    this.add((Widget)new ButtonAddReward(this));
                }
            }

            public void alignWidgets() {
                if (this.widgets.isEmpty()) {
                    this.setSize(this.width, 0);
                } else {
                    this.setSize(this.align((WidgetLayout)new WidgetLayout.Horizontal(3, 8, 3)), 50);
                    this.setX((this.getGui().width - this.width) / 2);
                }
            }

            public void drawBackground(Theme theme, int x, int y, int w, int h) {
                theme.drawString(TextFormatting.BLUE + I18n.func_135052_a((String)"ftbquests.rewards", (Object[])new Object[0]), x + w / 2, y + 5, 4);
            }
        };
    }

    public void addWidgets() {
        this.add((Widget)this.mainPanel);
        this.add((Widget)this.back);
        this.add((Widget)this.scrollBar);
    }

    public void alignWidgets() {
        this.scrollBar.setPosAndSize(this.width - 15, 5, 10, this.height - 10);
        this.back.setPosAndSize(4, 4, 16, 16);
        this.mainPanel.alignWidgets();
    }

    public boolean onInit() {
        return this.setFullscreen();
    }

    public Theme getTheme() {
        return QuestsTheme.INSTANCE;
    }

    public boolean drawDefaultBackground() {
        return false;
    }

    public void onBack() {
        this.questTreeGui.questFile.questGui = this.questTreeGui.questFile.questTreeGui;
        this.questTreeGui.questFile.questGui.openGui();
    }

    public class ButtonAddReward
    extends SmallButton {
        public ButtonAddReward(Panel panel) {
            super(panel, I18n.func_135052_a((String)"gui.add", (Object[])new Object[0]), QuestsTheme.ADD);
            this.setPosAndSize(0, 20, 20, 20);
        }

        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            ConfigValueInstance value = new ConfigValueInstance("item", ConfigGroup.DEFAULT, (ConfigValue)new ConfigItemStack(new ItemStack(Items.field_151034_e)){

                public void setStack(ItemStack stack) {
                    new MessageAddReward(GuiQuest.this.quest.getID(), false, stack).sendToServer();
                }
            });
            new GuiSelectItemStack(value, (IOpenableGui)this).openGui();
        }
    }

    public class ButtonReward
    extends SmallButton {
        public final QuestReward reward;

        public ButtonReward(Panel panel, QuestReward r) {
            super(panel, r.stack.func_82833_r() + (r.team ? TextFormatting.BLUE + " [" + I18n.func_135052_a((String)"ftbquests.reward.team_reward", (Object[])new Object[0]) + "]" : ""), ItemIcon.getItemIcon((ItemStack)r.stack));
            this.setPosAndSize(0, 20, 20, 20);
            this.reward = r;
        }

        public void addMouseOverText(List<String> list) {
            if (ButtonReward.isShiftKeyDown() && ButtonReward.isCtrlKeyDown()) {
                list.add(this.getTitle() + " " + TextFormatting.DARK_GRAY + this.reward);
            } else {
                list.add(this.getTitle());
            }
        }

        public void onClicked(MouseButton button) {
            if (button.isRight() && GuiQuest.this.questTreeGui.questFile.canEdit()) {
                GuiHelper.playClickSound();
                ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
                contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"selectServer.edit", (Object[])new Object[0]), GuiIcons.SETTINGS, () -> {
                    ConfigValueInstance value = new ConfigValueInstance("item", ConfigGroup.DEFAULT, (ConfigValue)new ConfigItemStack(ItemStack.field_190927_a){

                        public ItemStack getStack() {
                            return ButtonReward.this.reward.stack;
                        }

                        public void setStack(ItemStack stack) {
                            ButtonReward.this.reward.stack = stack;
                            new MessageEditReward(ButtonReward.this.reward.uid, ButtonReward.this.reward.team, stack).sendToServer();
                        }
                    });
                    new GuiSelectItemStack(value, (IOpenableGui)this).openGui();
                }));
                contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.reward.team_reward", (Object[])new Object[0]) + ": " + (this.reward.team ? TextFormatting.BLUE + "true" : "false"), this.reward.team ? GuiIcons.LOCK : GuiIcons.LOCK_OPEN, () -> new MessageEditReward(this.reward.uid, !this.reward.team, this.reward.stack).sendToServer()));
                contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"selectServer.delete", (Object[])new Object[0]), GuiIcons.REMOVE, () -> new MessageEditReward(this.reward.uid, this.reward.team, ItemStack.field_190927_a).sendToServer()).setYesNo(I18n.func_135052_a((String)"delete_item", (Object[])new Object[]{this.reward.stack.func_82833_r()})));
                this.getGui().openContextMenu(contextMenu);
            } else if (button.isLeft() && GuiQuest.this.questTreeGui.questFile.self != null) {
                GuiHelper.playClickSound();
                new MessageClaimReward(this.reward.uid).sendToServer();
            }
        }

        public void draw(Theme theme, int x, int y, int w, int h) {
            super.draw(theme, x, y, w, h);
            if (GuiQuest.this.questTreeGui.questFile.self == null) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
                GuiIcons.CLOSE.draw(x + w - 9, y + 1, 8, 8);
                GlStateManager.func_179121_F();
            } else if (GuiQuest.this.questTreeGui.questFile.isRewardClaimed(this.reward)) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
                QuestsTheme.COMPLETED.draw(x + w - 9, y + 1, 8, 8);
                GlStateManager.func_179121_F();
            }
        }
    }

    public class ButtonAddTask
    extends SmallButton {
        public ButtonAddTask(Panel panel) {
            super(panel, I18n.func_135052_a((String)"gui.add", (Object[])new Object[0]), QuestsTheme.ADD);
            this.setPosAndSize(0, 20, 20, 20);
        }

        public void addMouseOverText(List<String> list) {
            list.add(ButtonAddTask.isCtrlKeyDown() ? this.getTitle() + ": " + I18n.func_135052_a((String)"ftbquests.task.ftbquests.item", (Object[])new Object[0]) : this.getTitle());
        }

        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            if (GuiQuest.isCtrlKeyDown()) {
                new GuiSelectItemStack(new ConfigValueInstance("item", ConfigGroup.DEFAULT, (ConfigValue)new ConfigItemStack(ItemStack.field_190927_a){

                    public void setStack(ItemStack stack) {
                        NBTTagCompound nbt = new NBTTagCompound();
                        ItemTask itemTask = new ItemTask(GuiQuest.this.quest, nbt);
                        itemTask.items.add(stack);
                        itemTask.count = 1L;
                        itemTask.writeData(nbt);
                        nbt.func_74778_a("type", QuestTaskType.getTypeForNBT(ItemTask.class));
                        nbt.func_74778_a("id", QuestObject.customId(stack.func_82833_r()));
                        new MessageCreateObject(QuestObjectType.TASK, GuiQuest.this.quest.getID(), nbt).sendToServer();
                    }
                }), (IOpenableGui)this).openGui();
                return;
            }
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            for (QuestTaskType type : QuestTaskType.getRegistry()) {
                QuestTask task = type.provider.create(GuiQuest.this.quest, new NBTTagCompound());
                if (task == null) continue;
                contextMenu.add(new ContextMenuItem(type.getDisplayName().func_150254_d(), task.getIcon(), () -> {
                    GuiHelper.playClickSound();
                    ConfigGroup group = ConfigGroup.newGroup((String)"ftbquests");
                    ConfigGroup g = group.getGroup("task." + type.getRegistryName().func_110624_b() + '.' + type.getRegistryName().func_110623_a());
                    task.getConfig(g);
                    task.getExtraConfig(g);
                    new GuiEditConfig(group, (g1, sender) -> {
                        NBTTagCompound nbt = new NBTTagCompound();
                        task.writeData(nbt);
                        nbt.func_74778_a("type", type.getTypeForNBT());
                        new MessageCreateObject(QuestObjectType.TASK, GuiQuest.this.quest.getID(), nbt).sendToServer();
                        GuiQuest.this.openGui();
                        GuiQuest.this.questTreeGui.questFile.refreshGui(GuiQuest.this.questTreeGui.questFile);
                    }).openGui();
                }));
            }
            this.getGui().openContextMenu(contextMenu);
        }
    }

    public class ButtonTask
    extends SmallButton {
        public QuestTask task;

        public ButtonTask(Panel panel, QuestTask t) {
            super(panel, t.getDisplayName().func_150254_d(), t.getIcon());
            this.setPosAndSize(0, 20, 20, 20);
            this.task = t;
        }

        public boolean mousePressed(MouseButton button) {
            if (this.isMouseOver()) {
                if (button.isRight() || this.getWidgetType() != WidgetType.DISABLED) {
                    this.onClicked(button);
                }
                return true;
            }
            return false;
        }

        public void onClicked(MouseButton button) {
            if (button.isRight() && GuiQuest.this.questTreeGui.questFile.canEdit()) {
                GuiHelper.playClickSound();
                ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
                GuiQuest.this.questTreeGui.addObjectMenuItems(contextMenu, this.getGui(), this.task);
                this.getGui().openContextMenu(contextMenu);
            } else if (button.isLeft()) {
                GuiHelper.playClickSound();
                this.task.onButtonClicked();
            }
        }

        public void addMouseOverText(List<String> list) {
            list.add(this.getTitle() + ClientQuestProgress.getCompletionSuffix(GuiQuest.this.questTreeGui.questFile.self, this.task));
            this.task.addMouseOverText(list);
        }

        public WidgetType getWidgetType() {
            if (this.task.invalid || GuiQuest.this.questTreeGui.questFile.self == null || !GuiQuest.this.quest.canStartTasks(GuiQuest.this.questTreeGui.questFile.self)) {
                return WidgetType.DISABLED;
            }
            return super.getWidgetType();
        }

        public void draw(Theme theme, int x, int y, int w, int h) {
            super.draw(theme, x, y, w, h);
            if (this.task.invalid || GuiQuest.this.questTreeGui.questFile.self == null) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
                GuiIcons.CLOSE.draw(x + w - 9, y + 1, 8, 8);
                GlStateManager.func_179121_F();
            } else if (this.task.isComplete(GuiQuest.this.questTreeGui.questFile.self)) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
                QuestsTheme.COMPLETED.draw(x + w - 9, y + 1, 8, 8);
                GlStateManager.func_179121_F();
            }
        }
    }

    public abstract class SmallButton
    extends Button {
        public SmallButton(Panel panel, String title, Icon icon) {
            super(panel, title, icon);
        }

        public void drawBackground(Theme theme, int x, int y, int w, int h) {
            GlStateManager.func_179092_a((int)516, (float)0.0f);
            QuestsTheme.BUTTON.draw(x - 3, y - 3, w + 6, h + 6);
            if (this.isMouseOver()) {
                QuestsTheme.BUTTON.draw(x - 3, y - 3, w + 6, h + 6);
            }
            GlStateManager.func_179092_a((int)516, (float)0.1f);
        }
    }

    private class QuestLongDescription
    extends Widget {
        private final List<String> text;

        private QuestLongDescription(Panel panel) {
            super(panel);
            this.text = new ArrayList<String>();
        }

        public void draw(Theme theme, int x, int y, int w, int h) {
            Color4I col = GuiQuest.this.getTheme().getContentColor(WidgetType.NORMAL).withAlpha(200);
            int gw2 = this.getGui().width / 2;
            for (int i = 0; i < this.text.size(); ++i) {
                theme.drawString(this.text.get(i), gw2, 1 + y + i * 12, col, 4);
            }
        }
    }

    private class QuestShortDescription
    extends Widget {
        private final List<String> text;

        private QuestShortDescription(Panel panel) {
            super(panel);
            this.text = new ArrayList<String>();
        }

        public void draw(Theme theme, int x, int y, int w, int h) {
            int gw2 = this.getGui().width / 2;
            for (int i = 0; i < this.text.size(); ++i) {
                theme.drawString(this.text.get(i), gw2, 1 + y + i * 12, 4);
            }
        }
    }

    private class QuestTitle
    extends Widget {
        private String text;

        private QuestTitle(Panel panel) {
            super(panel);
            this.text = "";
        }

        public void draw(Theme theme, int x, int y, int w, int h) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((int)((float)x + (float)this.getGui().width / 2.0f)), (float)(y + 11), (float)0.0f);
            GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)1.0f);
            theme.drawString(this.text, 0, 0, 4);
            GlStateManager.func_179121_F();
        }
    }
}

