/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui;

import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.gui.GuiBase;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.SimpleTextButton;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetLayout;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.QuestsTheme;
import com.feed_the_beast.ftbquests.net.MessageGetEmergencyItems;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class GuiEmergencyItems
extends GuiBase {
    private long endTime;
    private boolean done;
    private final SimpleTextButton cancelButton;
    private final Panel itemPanel;

    public GuiEmergencyItems() {
        this.endTime = System.currentTimeMillis() + ClientQuestFile.INSTANCE.emergencyItemsCooldown.millis();
        this.done = false;
        this.cancelButton = new SimpleTextButton((Panel)this, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), (Icon)Icon.EMPTY){

            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                this.getGui().closeGui();
            }
        };
        this.itemPanel = new Panel((Panel)this){

            public void addWidgets() {
                for (ItemStack stack : ClientQuestFile.INSTANCE.emergencyItems) {
                    this.add(new EmergencyItem(this, stack));
                }
            }

            public void alignWidgets() {
                this.setWidth(this.align((WidgetLayout)new WidgetLayout.Horizontal(3, 7, 3)));
                this.setHeight(22);
                this.setPos((GuiEmergencyItems.this.width - ((GuiEmergencyItems)GuiEmergencyItems.this).itemPanel.width) / 2, GuiEmergencyItems.this.height * 2 / 3 - 10);
            }
        };
    }

    public void addWidgets() {
        this.add((Widget)this.itemPanel);
        this.add((Widget)this.cancelButton);
        this.cancelButton.setPos((this.width - this.cancelButton.width) / 2, this.height * 2 / 3 + 16);
    }

    public boolean onInit() {
        return this.setFullscreen();
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        long left = this.endTime - System.currentTimeMillis();
        if (left <= 0L) {
            if (!this.done) {
                this.done = true;
                this.cancelButton.setTitle(I18n.func_135052_a((String)"gui.close", (Object[])new Object[0]));
                new MessageGetEmergencyItems().sendToServer();
            }
            left = 0L;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((int)((float)w / 2.0f)), (float)((int)((float)h / 5.0f)), (float)0.0f);
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)1.0f);
        String s = I18n.func_135052_a((String)"ftbquests.file.emergency_items", (Object[])new Object[0]);
        theme.drawString(s, -theme.getStringWidth(s) / 2, 0, Color4I.WHITE, 0);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((int)((float)w / 2.0f)), (float)((int)((float)h / 2.5f)), (float)0.0f);
        GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)1.0f);
        s = left <= 0L ? "00:00" : StringUtils.getTimeString((long)(left / 1000L * 1000L + 1000L));
        int x1 = -theme.getStringWidth(s) / 2;
        theme.drawString(s, x1 - 1, 0, Color4I.BLACK, 0);
        theme.drawString(s, x1 + 1, 0, Color4I.BLACK, 0);
        theme.drawString(s, x1, 1, Color4I.BLACK, 0);
        theme.drawString(s, x1, -1, Color4I.BLACK, 0);
        theme.drawString(s, x1, 0, Color4I.WHITE, 0);
        GlStateManager.func_179121_F();
    }

    public Theme getTheme() {
        return QuestsTheme.INSTANCE;
    }

    private static class EmergencyItem
    extends Widget {
        private final ItemStack stack;

        public EmergencyItem(Panel p, ItemStack is) {
            super(p);
            this.setY(3);
            this.stack = is;
            this.setSize(16, 16);
        }

        public void addMouseOverText(List<String> list) {
            List l = this.stack.func_82840_a((EntityPlayer)ClientUtils.MC.field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
            list.add(this.stack.func_77953_t().field_77937_e + (String)l.get(0));
            for (int i = 1; i < l.size(); ++i) {
                list.add(TextFormatting.GRAY + (String)l.get(i));
            }
        }

        public void draw(Theme theme, int x, int y, int w, int h) {
            GlStateManager.func_179092_a((int)516, (float)0.0f);
            QuestsTheme.BUTTON.draw(x - 3, y - 3, w + 6, h + 6);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GuiHelper.drawItem((ItemStack)this.stack, (double)x, (double)y, (boolean)true, (Color4I)Icon.EMPTY);
        }
    }
}

