/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.client;

import com.feed_the_beast.ftblib.events.CustomSidebarButtonTextEvent;
import com.feed_the_beast.ftblib.events.client.CustomClickEvent;
import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.client.FTBQuestsClient;
import com.feed_the_beast.ftbquests.client.RenderProgressScreen;
import com.feed_the_beast.ftbquests.client.RenderScreen;
import com.feed_the_beast.ftbquests.item.FTBQuestsItems;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import com.feed_the_beast.ftbquests.quest.QuestReward;
import com.feed_the_beast.ftbquests.tile.TileProgressScreenCore;
import com.feed_the_beast.ftbquests.tile.TileScreenCore;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="ftbquests", value={Side.CLIENT})
public class FTBQuestsClientEventHandler {
    private static final ResourceLocation QUESTS_BUTTON = new ResourceLocation("ftbquests", "quests");
    public static TextureAtlasSprite inputBlockSprite;

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)FTBQuestsItems.SCREEN, (int)0, (ModelResourceLocation)new ModelResourceLocation(FTBQuestsItems.SCREEN.getRegistryName(), "facing=north"));
        ModelLoader.setCustomModelResourceLocation((Item)FTBQuestsItems.PROGRESS_DETECTOR, (int)0, (ModelResourceLocation)new ModelResourceLocation(FTBQuestsItems.PROGRESS_DETECTOR.getRegistryName(), "normal"));
        ModelLoader.setCustomModelResourceLocation((Item)FTBQuestsItems.PROGRESS_SCREEN, (int)0, (ModelResourceLocation)new ModelResourceLocation(FTBQuestsItems.PROGRESS_SCREEN.getRegistryName(), "facing=north"));
        ModelLoader.setCustomModelResourceLocation((Item)FTBQuestsItems.CHEST, (int)0, (ModelResourceLocation)new ModelResourceLocation(FTBQuestsItems.CHEST.getRegistryName(), "facing=north"));
        ModelLoader.setCustomModelResourceLocation((Item)FTBQuestsItems.BOOK, (int)0, (ModelResourceLocation)new ModelResourceLocation(FTBQuestsItems.BOOK.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)FTBQuestsItems.XP_VIAL, (int)0, (ModelResourceLocation)new ModelResourceLocation(FTBQuestsItems.XP_VIAL.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)FTBQuestsItems.SCRIPT, (int)0, (ModelResourceLocation)new ModelResourceLocation(FTBQuestsItems.SCRIPT.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)FTBQuestsItems.COMMON_LOOTCRATE, (int)0, (ModelResourceLocation)new ModelResourceLocation(FTBQuestsItems.COMMON_LOOTCRATE.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)FTBQuestsItems.UNCOMMON_LOOTCRATE, (int)0, (ModelResourceLocation)new ModelResourceLocation(FTBQuestsItems.UNCOMMON_LOOTCRATE.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)FTBQuestsItems.RARE_LOOTCRATE, (int)0, (ModelResourceLocation)new ModelResourceLocation(FTBQuestsItems.RARE_LOOTCRATE.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)FTBQuestsItems.EPIC_LOOTCRATE, (int)0, (ModelResourceLocation)new ModelResourceLocation(FTBQuestsItems.EPIC_LOOTCRATE.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)FTBQuestsItems.LEGENDARY_LOOTCRATE, (int)0, (ModelResourceLocation)new ModelResourceLocation(FTBQuestsItems.LEGENDARY_LOOTCRATE.getRegistryName(), "inventory"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileScreenCore.class, (TileEntitySpecialRenderer)new RenderScreen());
        ClientRegistry.bindTileEntitySpecialRenderer(TileProgressScreenCore.class, (TileEntitySpecialRenderer)new RenderProgressScreen());
    }

    @SubscribeEvent
    public static void onCustomSidebarButtonText(CustomSidebarButtonTextEvent event) {
        if (ClientQuestFile.existsWithTeam() && event.getButton().id.equals((Object)QUESTS_BUTTON)) {
            int r = 0;
            for (QuestChapter chapter : ClientQuestFile.INSTANCE.chapters) {
                for (Quest quest : chapter.quests) {
                    if (!quest.isComplete(ClientQuestFile.INSTANCE.self)) continue;
                    for (QuestReward reward : quest.rewards) {
                        if (ClientQuestFile.INSTANCE.isRewardClaimed(reward)) continue;
                        ++r;
                    }
                }
            }
            if (r > 0) {
                event.setText(Integer.toString(r));
            }
        }
    }

    @SubscribeEvent
    public static void onKeyEvent(InputEvent.KeyInputEvent event) {
        if (FTBQuestsClient.KEY_QUESTS.func_151468_f()) {
            if (ClientQuestFile.exists()) {
                ClientQuestFile.INSTANCE.openQuestGui();
            } else {
                ClientUtils.MC.field_71439_g.func_146105_b((ITextComponent)new TextComponentTranslation("ftblib.lang.team.error.no_team", new Object[0]), true);
            }
        }
    }

    @SubscribeEvent
    public static void onCustomClick(CustomClickEvent event) {
        if (event.getID().func_110624_b().equals("ftbquests")) {
            switch (event.getID().func_110623_a()) {
                case "open_gui": {
                    if (ClientQuestFile.exists()) {
                        ClientQuestFile.INSTANCE.openQuestGui();
                        break;
                    }
                    ClientUtils.MC.field_71439_g.func_146105_b((ITextComponent)new TextComponentTranslation("ftblib.lang.team.error.no_team", new Object[0]), true);
                }
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onTextureStitchPre(TextureStitchEvent.Pre event) {
        inputBlockSprite = event.getMap().func_174942_a(new ResourceLocation("ftbquests", "blocks/screen_front_input"));
    }
}

