/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.block;

import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import com.feed_the_beast.ftblib.lib.util.BlockUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbquests.block.BlockScreen;
import com.feed_the_beast.ftbquests.block.BlockWithHorizontalFacing;
import com.feed_the_beast.ftbquests.block.FTBQuestsBlocks;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.item.FTBQuestsItems;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.tile.TileProgressScreenBase;
import com.feed_the_beast.ftbquests.tile.TileProgressScreenCore;
import com.feed_the_beast.ftbquests.tile.TileProgressScreenPart;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockProgressScreen
extends BlockWithHorizontalFacing {
    public BlockProgressScreen() {
        super(Material.field_151573_f, MapColor.field_151646_E);
        this.func_149711_c(0.3f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.NORTH));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileProgressScreenCore();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this));
        for (int i = 1; i <= 4; ++i) {
            ItemStack stack = new ItemStack((Block)this);
            stack.func_77983_a("Width", (NBTBase)new NBTTagByte((byte)i));
            stack.func_77983_a("Height", (NBTBase)new NBTTagByte((byte)(i * 2)));
            items.add((Object)stack);
        }
        ItemStack stack = new ItemStack((Block)this);
        stack.func_77983_a("Width", (NBTBase)new NBTTagByte(2));
        stack.func_77983_a("Height", (NBTBase)new NBTTagByte(3));
        items.add((Object)stack);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return FTBQuestsItems.SCREEN;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileProgressScreenCore screen;
        ItemStack stack = new ItemStack(FTBQuestsItems.PROGRESS_SCREEN);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileProgressScreenBase && (screen = ((TileProgressScreenBase)tileEntity).getScreen()) != null) {
            screen.writeToPickBlock(stack);
        }
        return stack;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileProgressScreenBase base;
        TileProgressScreenCore screen;
        if (facing != state.func_177229_b((IProperty)field_185512_D)) {
            return false;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileProgressScreenBase && (screen = (base = (TileProgressScreenBase)tileEntity).getScreen()) != null) {
            if (player.func_70093_af()) {
                if (player instanceof EntityPlayerMP) {
                    screen.onClicked((EntityPlayerMP)player, 0.0, 0.0);
                }
                return true;
            }
            if (facing == state.func_177229_b((IProperty)field_185512_D)) {
                if (player instanceof EntityPlayerMP) {
                    screen.onClicked((EntityPlayerMP)player, BlockScreen.getClickX(facing, base.getOffsetX(), base.getOffsetZ(), hitX, hitZ, screen.width), BlockScreen.getClickY(base.getOffsetY(), hitY, screen.height));
                }
                return true;
            }
        }
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileProgressScreenCore) {
            TileProgressScreenCore screen = (TileProgressScreenCore)tileEntity;
            screen.readFromItem(stack);
            if (screen.team.isEmpty() && placer instanceof EntityPlayerMP) {
                screen.team = FTBLibAPI.getTeam((UUID)placer.func_110124_au());
            }
            screen.facing = (EnumFacing)state.func_177229_b((IProperty)field_185512_D);
            if (screen.width > 0 || screen.height > 0) {
                int offZ;
                int offX;
                int x;
                int y;
                IBlockState state1 = FTBQuestsBlocks.PROGRESS_SCREEN_PART.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)screen.getFacing());
                boolean xaxis = screen.facing.func_176740_k() == EnumFacing.Axis.X;
                for (y = 0; y < screen.height + 1; ++y) {
                    for (x = -screen.width; x <= screen.width; ++x) {
                        if (x == 0 && y == 0) continue;
                        offX = xaxis ? 0 : x;
                        offZ = xaxis ? x : 0;
                        world.func_175698_g(new BlockPos(pos.func_177958_n() + offX, pos.func_177956_o() + y, pos.func_177952_p() + offZ));
                    }
                }
                for (y = 0; y < screen.height + 1; ++y) {
                    for (x = -screen.width; x <= screen.width; ++x) {
                        if (x == 0 && y == 0) continue;
                        offX = xaxis ? 0 : x;
                        offZ = xaxis ? x : 0;
                        BlockPos pos1 = new BlockPos(pos.func_177958_n() + offX, pos.func_177956_o() + y, pos.func_177952_p() + offZ);
                        world.func_175656_a(pos1, state1);
                        TileEntity tileEntity1 = world.func_175625_s(pos1);
                        if (!(tileEntity1 instanceof TileProgressScreenPart)) continue;
                        ((TileProgressScreenPart)tileEntity1).setOffset(offX, y, offZ);
                    }
                }
            }
        }
    }

    @Nullable
    public String getHarvestTool(IBlockState state) {
        return null;
    }

    public int getHarvestLevel(IBlockState state) {
        return -1;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileProgressScreenCore) {
            TileProgressScreenCore screen = (TileProgressScreenCore)tileEntity;
            if (screen.width > 0 || screen.height > 0) {
                BlockScreen.BREAKING_SCREEN = true;
                boolean xaxis = ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176740_k() == EnumFacing.Axis.X;
                for (int y = 0; y < screen.height + 1; ++y) {
                    for (int x = -screen.width; x <= screen.width; ++x) {
                        if (x == 0 && y == 0) continue;
                        int offX = xaxis ? 0 : x;
                        int offZ = xaxis ? x : 0;
                        BlockPos pos1 = new BlockPos(pos.func_177958_n() + offX, pos.func_177956_o() + y, pos.func_177952_p() + offZ);
                        IBlockState state1 = world.func_180495_p(pos1);
                        if (state1.func_177230_c() != FTBQuestsBlocks.PROGRESS_SCREEN_PART) continue;
                        world.func_175698_g(pos1);
                    }
                }
                BlockScreen.BREAKING_SCREEN = false;
            }
        }
        super.func_180663_b(world, pos, state);
    }

    @Deprecated
    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        TileProgressScreenCore screen;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileProgressScreenBase && (screen = ((TileProgressScreenBase)tileEntity).getScreen()) != null) {
            return BlockProgressScreen.getScreenAABB(screen.func_174877_v(), screen.getFacing(), screen.width, screen.height);
        }
        return new AxisAlignedBB(0.0, -1.0, 0.0, 0.0, -1.0, 0.0);
    }

    public static AxisAlignedBB getScreenAABB(BlockPos pos, EnumFacing facing, int w, int h) {
        boolean xaxis;
        if (w == 0 && h == 0) {
            return field_185505_j.func_186670_a(pos);
        }
        boolean bl = xaxis = facing.func_176740_k() == EnumFacing.Axis.X;
        if (xaxis) {
            return new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)(pos.func_177952_p() - w), (double)pos.func_177958_n() + 1.0, (double)(pos.func_177956_o() + h) + 1.0, (double)(pos.func_177952_p() + w) + 1.0);
        }
        return new AxisAlignedBB((double)(pos.func_177958_n() - w), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + w) + 1.0, (double)(pos.func_177956_o() + h) + 1.0, (double)pos.func_177952_p() + 1.0);
    }

    @Deprecated
    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        TileProgressScreenCore core;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileProgressScreenBase && (core = ((TileProgressScreenBase)tileEntity).getScreen()) != null && core.indestructible) {
            return -1.0f;
        }
        return super.func_176195_g(state, world, pos);
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        TileProgressScreenCore core;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileProgressScreenBase && (core = ((TileProgressScreenBase)tileEntity).getScreen()) != null && core.indestructible) {
            return Float.MAX_VALUE;
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    @Deprecated
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileProgressScreenCore core;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileProgressScreenBase && (core = ((TileProgressScreenBase)tileEntity).getScreen()) != null && core.skin != BlockUtils.AIR_STATE) {
            return core.skin;
        }
        return state;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        String team;
        if (world == null || !ClientQuestFile.exists()) {
            return;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        byte width = nbt == null ? (byte)0 : nbt.func_74771_c("Width");
        byte height = nbt == null ? (byte)0 : nbt.func_74771_c("Height");
        String string = team = nbt == null ? "" : nbt.func_74779_i("Team");
        if (team.isEmpty()) {
            team = ClientQuestFile.existsWithTeam() ? ClientQuestFile.INSTANCE.self.getTeamID() : "";
        }
        tooltip.add(I18n.func_135052_a((String)"tile.ftbquests.screen.size", (Object[])new Object[0]) + ": " + TextFormatting.GOLD + (1 + width * 2) + " x " + (1 + height));
        tooltip.add(I18n.func_135052_a((String)"ftbquests.team", (Object[])new Object[0]) + ": " + TextFormatting.DARK_GREEN + team);
        QuestObject object = ClientQuestFile.INSTANCE.get(nbt == null ? "" : nbt.func_74779_i("Object"));
        if (object != null) {
            tooltip.add(StringUtils.color((ITextComponent)object.getDisplayName(), (TextFormatting)TextFormatting.YELLOW).func_150254_d());
        }
    }
}

