/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.network;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.flux.FluxNetworks;

public class PacketColourCache
implements IMessage {
    public Map<Integer, Tuple<Integer, String>> cache;

    public PacketColourCache() {
    }

    public PacketColourCache(Map<Integer, Tuple<Integer, String>> cache) {
        this.cache = cache;
    }

    public void fromBytes(ByteBuf buf) {
        this.cache = new HashMap<Integer, Tuple<Integer, String>>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            int id = buf.readInt();
            int colour = buf.readInt();
            String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.cache.put(id, (Tuple<Integer, String>)new Tuple((Object)colour, (Object)name));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.cache.size());
        this.cache.forEach((ID, DETAILS) -> {
            buf.writeInt(ID.intValue());
            buf.writeInt(((Integer)DETAILS.func_76341_a()).intValue());
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((String)DETAILS.func_76340_b()));
        });
    }

    public static class Handler
    implements IMessageHandler<PacketColourCache, IMessage> {
        public IMessage onMessage(PacketColourCache message, MessageContext ctx) {
            FluxNetworks.proxy.receiveColourCache(message.cache);
            return null;
        }
    }
}

