/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.network;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.helpers.NBTHelper;
import sonar.flux.FluxNetworks;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.client.gui.GuiTab;
import sonar.flux.common.events.FluxListenerEvent;
import sonar.flux.common.tileentity.TileFlux;
import sonar.flux.connection.FluxListener;
import sonar.flux.network.PacketFluxNetworkUpdate;

public class ListenerHelper {
    public static void onPlayerOpenTileGui(TileFlux flux, EntityPlayer player) {
        Preconditions.checkState((!flux.func_145831_w().field_72995_K ? 1 : 0) != 0);
        MinecraftForge.EVENT_BUS.post((Event)new FluxListenerEvent.AddConnectionListener(flux, flux.getNetwork()));
        if (!flux.getNetwork().isFakeNetwork()) {
            FluxNetworks.network.sendTo((IMessage)new PacketFluxNetworkUpdate(Lists.newArrayList((Object[])new IFluxNetwork[]{flux.getNetwork()}), NBTHelper.SyncType.SAVE, true), (EntityPlayerMP)player);
        }
    }

    public static void onPlayerCloseTileGui(TileFlux flux, EntityPlayer player) {
        Preconditions.checkState((!flux.func_145831_w().field_72995_K ? 1 : 0) != 0);
        MinecraftForge.EVENT_BUS.post((Event)new FluxListenerEvent.RemoveConnectionListener(flux, flux.getNetwork()));
    }

    public static void onNetworkChanged(TileFlux flux, IFluxNetwork old, IFluxNetwork network) {
        Preconditions.checkState((!flux.func_145831_w().field_72995_K ? 1 : 0) != 0);
        if (flux.getListenerList().hasListeners()) {
            MinecraftForge.EVENT_BUS.post((Event)new FluxListenerEvent.RemoveConnectionListener(flux, old));
            MinecraftForge.EVENT_BUS.post((Event)new FluxListenerEvent.AddConnectionListener(flux, network));
            for (FluxListener l : FluxListener.values()) {
                flux.listeners.getListeners(new Enum[]{l}).forEach(p -> l.doClosePacket(network, flux, p.player));
                flux.listeners.getListeners(new Enum[]{l}).forEach(p -> l.doOpenPacket(network, flux, p.player));
            }
        }
    }

    public static void onPlayerOpenTab(TileFlux flux, EntityPlayer player, GuiTab tab) {
        Preconditions.checkState((!flux.func_145831_w().field_72995_K ? 1 : 0) != 0);
        tab.getMonitoringTypes().forEach(m -> {
            flux.listeners.addListener(player, new Enum[]{m});
            m.doOpenPacket(flux.getNetwork(), flux, (EntityPlayerMP)player);
        });
    }

    public static void onPlayerCloseTab(TileFlux flux, EntityPlayer player, GuiTab tab) {
        Preconditions.checkState((!flux.func_145831_w().field_72995_K ? 1 : 0) != 0);
        tab.getMonitoringTypes().forEach(m -> {
            flux.listeners.removeListener(player, true, new Enum[]{m});
            m.doClosePacket(flux.getNetwork(), flux, (EntityPlayerMP)player);
        });
    }
}

