/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.network;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.api.energy.EnergyType;
import sonar.core.helpers.NBTHelper;
import sonar.core.listener.ISonarListenable;
import sonar.core.listener.ListenableList;
import sonar.core.listener.PlayerListener;
import sonar.core.utils.CustomColour;
import sonar.core.utils.SimpleObservableList;
import sonar.flux.FluxConfig;
import sonar.flux.FluxEvents;
import sonar.flux.FluxNetworks;
import sonar.flux.api.AccessType;
import sonar.flux.api.network.FluxPlayer;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.api.network.IFluxNetworkCache;
import sonar.flux.api.network.PlayerAccess;
import sonar.flux.connection.FluxHelper;
import sonar.flux.connection.FluxListener;
import sonar.flux.connection.FluxNetworkInvalid;
import sonar.flux.connection.FluxNetworkServer;
import sonar.flux.connection.NetworkSettings;
import sonar.flux.network.NetworkData;
import sonar.flux.network.PacketFluxNetworkUpdate;
import sonar.flux.network.PacketNetworkDeleted;

public class FluxNetworkCache
implements IFluxNetworkCache,
ISonarListenable<PlayerListener>,
SimpleObservableList.IListWatcher<IFluxNetwork> {
    public int uniqueID = 1;
    private Map<UUID, List<IFluxNetwork>> networks = new HashMap<UUID, List<IFluxNetwork>>();
    private static boolean INIT = false;
    private ListenableList<PlayerListener> listeners = new ListenableList((ISonarListenable)this, FluxListener.values().length);

    public static FluxNetworkCache instance() {
        if (!INIT) {
            MapStorage storage = DimensionManager.getWorld((int)0).func_175693_T();
            if (storage.func_75742_a(NetworkData.class, "sonar.flux.networks.configurations") == null) {
                storage.func_75745_a("sonar.flux.networks.configurations", (WorldSavedData)new NetworkData());
            }
            INIT = true;
        }
        return FluxNetworks.getServerCache();
    }

    public void clearNetworks() {
        this.networks.clear();
        this.uniqueID = 1;
        INIT = false;
    }

    private int createNewUniqueID() {
        return this.uniqueID++;
    }

    public IFluxNetwork getNetwork(Predicate<IFluxNetwork> found) {
        for (Map.Entry<UUID, List<IFluxNetwork>> entry : this.networks.entrySet()) {
            Optional<IFluxNetwork> network = entry.getValue().stream().filter(found).findFirst();
            if (!network.isPresent()) continue;
            return network.get();
        }
        return FluxNetworkInvalid.INVALID;
    }

    public List<IFluxNetwork> getNetworks(Predicate<IFluxNetwork> found) {
        ArrayList<IFluxNetwork> list = new ArrayList<IFluxNetwork>();
        this.networks.values().forEach(NETWORKS -> NETWORKS.stream().filter(found).forEach(list::add));
        return list;
    }

    public void forEachNetwork(Consumer<IFluxNetwork> action) {
        this.networks.values().forEach(l -> l.forEach(action));
    }

    @Override
    public List<IFluxNetwork> getAllowedNetworks(EntityPlayer player, boolean admin) {
        return this.getNetworks(network -> admin || network.getPlayerAccess(player).canConnect());
    }

    @Override
    public IFluxNetwork getNetwork(int iD) {
        return this.getNetwork(n -> !n.isFakeNetwork() && iD == n.getSetting(NetworkSettings.NETWORK_ID));
    }

    @Override
    public List<IFluxNetwork> getAllNetworks() {
        ArrayList<IFluxNetwork> available = new ArrayList<IFluxNetwork>();
        this.networks.values().forEach(available::addAll);
        return available;
    }

    public List<IFluxNetwork> instanceNetworkList() {
        SimpleObservableList list = new SimpleObservableList();
        list.addWatcher((SimpleObservableList.IListWatcher)this);
        return list;
    }

    protected void addNetwork(IFluxNetwork network) {
        UUID owner = network.getSetting(NetworkSettings.NETWORK_OWNER);
        if (owner != null) {
            this.networks.computeIfAbsent(owner, UUID2 -> this.instanceNetworkList()).add(network);
        }
    }

    protected void removeNetwork(IFluxNetwork common) {
        UUID owner = common.getSetting(NetworkSettings.NETWORK_OWNER);
        common.onRemoved();
        if (owner != null && this.networks.get(owner) != null) {
            this.networks.get(owner).remove(common);
        }
    }

    public boolean hasSpaceForNetwork(EntityPlayer player) {
        if (FluxConfig.maximum_per_player == -1) {
            return true;
        }
        UUID ownerUUID = FluxPlayer.getOnlineUUID(player);
        List created = this.networks.getOrDefault(ownerUUID, new ArrayList());
        return created.size() < FluxConfig.maximum_per_player;
    }

    public IFluxNetwork createNetwork(EntityPlayer player, String name, CustomColour colour, AccessType access, boolean disableConvert, EnergyType defaultEnergy) {
        UUID playerUUID = EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH());
        this.networks.computeIfAbsent(playerUUID, UUID2 -> this.instanceNetworkList());
        int iD = this.createNewUniqueID();
        FluxPlayer owner = FluxPlayer.createFluxPlayer(player, PlayerAccess.OWNER);
        FluxNetworkServer network = new FluxNetworkServer(iD, owner.getOnlineUUID(), owner.getCachedName(), name, colour, access, disableConvert, defaultEnergy);
        network.getSetting(NetworkSettings.NETWORK_PLAYERS).add(owner);
        this.addNetwork(network);
        FluxEvents.logNewNetwork(network);
        return network;
    }

    public void onPlayerRemoveNetwork(IFluxNetwork remove) {
        this.removeNetwork(remove);
        FluxEvents.logRemoveNetwork(remove);
    }

    public void onSettingsChanged(IFluxNetwork network) {
        List players = this.listeners.getListeners(new Enum[]{FluxListener.SYNC_NETWORK_LIST});
        PacketFluxNetworkUpdate packet = new PacketFluxNetworkUpdate(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTHelper.SyncType.SAVE, false);
        players.forEach(listener -> {
            if (network.getPlayerAccess((EntityPlayer)listener.player).canConnect()) {
                FluxNetworks.network.sendTo((IMessage)packet, listener.player);
            }
        });
    }

    public void onElementAdded(@Nullable IFluxNetwork added) {
        List players = this.listeners.getListeners(new Enum[]{FluxListener.SYNC_NETWORK_LIST});
        PacketFluxNetworkUpdate packet = new PacketFluxNetworkUpdate(Lists.newArrayList((Object[])new IFluxNetwork[]{added}), NBTHelper.SyncType.SAVE, false);
        players.forEach(listener -> {
            if (added.getPlayerAccess((EntityPlayer)listener.player).canConnect()) {
                FluxNetworks.network.sendTo((IMessage)packet, listener.player);
            }
        });
    }

    public void onElementRemoved(@Nullable IFluxNetwork remove) {
        List players = this.listeners.getListeners(new Enum[]{FluxListener.SYNC_NETWORK_LIST});
        PacketNetworkDeleted packet = new PacketNetworkDeleted(remove);
        players.forEach(listener -> FluxNetworks.network.sendTo((IMessage)packet, listener.player));
        this.updateNetworkListeners();
    }

    public void onListChanged() {
        this.updateNetworkListeners();
    }

    public ListenableList<PlayerListener> getListenerList() {
        return this.listeners;
    }

    public void updateNetworkListeners() {
        List players = this.listeners.getListeners(new Enum[]{FluxListener.SYNC_NETWORK_LIST});
        players.forEach(listener -> {
            List<IFluxNetwork> toSend = FluxNetworkCache.instance().getAllowedNetworks((EntityPlayer)listener.player, FluxHelper.isPlayerAdmin((EntityPlayer)listener.player));
            FluxNetworks.network.sendTo((IMessage)new PacketFluxNetworkUpdate(toSend, NBTHelper.SyncType.SAVE, true), listener.player);
        });
    }

    public void updateAdminListeners() {
        List players = this.listeners.getListeners(new Enum[]{FluxListener.ADMIN});
        players.forEach(listener -> {
            List<IFluxNetwork> toSend = FluxNetworkCache.instance().getAllowedNetworks((EntityPlayer)listener.player, true);
            FluxNetworks.network.sendTo((IMessage)new PacketFluxNetworkUpdate(toSend, NBTHelper.SyncType.SAVE, true), listener.player);
        });
    }

    public boolean isValid() {
        return true;
    }
}

