/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.connection.transfer.handlers;

import sonar.core.api.energy.EnergyType;
import sonar.core.api.utils.ActionType;
import sonar.flux.FluxNetworks;
import sonar.flux.api.energy.internal.IEnergyTransfer;
import sonar.flux.api.energy.internal.IFluxTransfer;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.api.tiles.IFlux;
import sonar.flux.connection.FluxNetworkServer;
import sonar.flux.connection.NetworkSettings;
import sonar.flux.connection.transfer.handlers.BaseTransferHandler;

public abstract class FluxTransferHandler<T extends IFlux>
extends BaseTransferHandler {
    public final T flux;

    public FluxTransferHandler(T flux) {
        this.flux = flux;
    }

    public IFluxNetwork getNetwork() {
        return this.flux.getNetwork();
    }

    @Override
    public long addToNetwork(long maxTransferRF, EnergyType energyType, ActionType actionType) {
        if (!this.flux.isActive()) {
            return 0L;
        }
        long added = Math.min(this.getAddRate() - this.buffer_transfer, Math.min(this.toFE(maxTransferRF, energyType), this.buffer));
        if (!actionType.shouldSimulate() && added > 0L) {
            this.buffer -= added;
            this.buffer_transfer += added;
        }
        return this.convert(added, EnergyType.FE, energyType);
    }

    @Override
    public long removeFromNetwork(long maxTransferRF, EnergyType energyType, ActionType actionType) {
        if (!this.flux.isActive()) {
            return 0L;
        }
        long actualMax = Math.min(maxTransferRF, this.getValidRemoval(maxTransferRF, energyType));
        long removed = 0L;
        for (IFluxTransfer transfer : this.getTransfers()) {
            if (transfer == null || !this.getNetwork().canConvert(energyType, transfer.getEnergyType()) || !(transfer instanceof IEnergyTransfer)) continue;
            long toTransfer = actualMax - removed;
            long remove = ((IEnergyTransfer)transfer).removeFromNetworkWithConvert(toTransfer, energyType, actionType);
            removed += remove;
            if (actionType.shouldSimulate()) continue;
            this.removed += FluxNetworks.TRANSFER_HANDLER.convert(remove, energyType, this.getNetwork().getSetting(NetworkSettings.NETWORK_ENERGY_TYPE));
        }
        return removed;
    }

    @Override
    public long getAddRate() {
        return this.flux.getNetwork().isFakeNetwork() ? 0L : this.flux.getTransferLimit();
    }

    @Override
    public long getRemoveRate() {
        return this.flux.getTransferLimit();
    }

    @Override
    public long getBufferLimiter() {
        return this.flux.getNetwork().isFakeNetwork() ? 0L : ((FluxNetworkServer)this.getNetwork()).buffer_limiter;
    }
}

