/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.common.tileentity.energy;

import javax.annotation.Nullable;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;
import sonar.core.api.energy.EnergyType;
import sonar.core.api.utils.ActionType;
import sonar.flux.api.tiles.IFluxConnection;
import sonar.flux.api.tiles.IFluxPoint;

@Optional.InterfaceList(value={@Optional.Interface(iface="net.darkhax.tesla.api.ITeslaConsumer", modid="tesla"), @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaProducer", modid="tesla")})
public class FluxConnectionWrapper
implements IEnergyStorage,
ITeslaConsumer,
ITeslaProducer {
    @Nullable
    public final EnumFacing side;
    public final IFluxConnection flux;

    public FluxConnectionWrapper(@Nullable EnumFacing side, IFluxConnection flux) {
        this.side = side;
        this.flux = flux;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return (int)this.flux.addPhantomEnergyToNetwork(this.side, Math.min(maxReceive, Integer.MAX_VALUE), EnergyType.FE, ActionType.getTypeForAction((boolean)simulate));
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return (int)this.flux.removePhantomEnergyFromNetwork(this.side, Math.min(maxExtract, Integer.MAX_VALUE), EnergyType.FE, ActionType.getTypeForAction((boolean)simulate));
    }

    public int getEnergyStored() {
        return this.flux instanceof IFluxPoint ? Integer.MAX_VALUE : 0;
    }

    public int getMaxEnergyStored() {
        return Integer.MAX_VALUE;
    }

    public boolean canExtract() {
        return this.flux.getConnectionType().canRemovePhantomPower();
    }

    public boolean canReceive() {
        return this.flux.getConnectionType().canAddPhantomPower();
    }

    @Optional.Method(modid="tesla")
    public long givePower(long power, boolean simulated) {
        return this.flux.addPhantomEnergyToNetwork(this.side, Math.min(power, Long.MAX_VALUE), EnergyType.TESLA, ActionType.getTypeForAction((boolean)simulated));
    }

    @Optional.Method(modid="tesla")
    public long takePower(long power, boolean simulated) {
        return this.flux.removePhantomEnergyFromNetwork(this.side, Math.min(power, Long.MAX_VALUE), EnergyType.TESLA, ActionType.getTypeForAction((boolean)simulated));
    }
}

