/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.core.common.block.SonarBlockTip;
import sonar.core.registries.SonarRegistryBlock;
import sonar.flux.FluxTranslate;
import sonar.flux.client.FluxColourHandler;
import sonar.flux.common.block.FluxStorage;

public class ItemNetworkConnector
extends SonarBlockTip {
    public static final String CUSTOM_NAME_TAG = "cust_name";
    public static final String PRIORITY_TAG = "priority";
    public static final String TRANSFER_LIMIT_TAG = "limit";
    public static final String DISABLE_LIMIT_TAG = "e_limit";
    public static final String NETWORK_ID_TAG = "network_id";

    public ItemNetworkConnector(Block block) {
        super(block);
    }

    public String func_77653_i(ItemStack stack) {
        NBTTagCompound tag = stack.func_179543_a("sonar_drop");
        if (tag != null && tag.func_74764_b(CUSTOM_NAME_TAG)) {
            return tag.func_74779_i(CUSTOM_NAME_TAG);
        }
        return super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, World world, @Nonnull List<String> list, @Nonnull ITooltipFlag flag) {
        NBTTagCompound tag = stack.func_179543_a("sonar_drop");
        if (tag != null) {
            list.add(FluxTranslate.NETWORK_NAME.t() + ": " + FluxColourHandler.getOrRequestNetworkName(tag.func_74762_e(NETWORK_ID_TAG)));
            list.add(FluxTranslate.TRANSFER_LIMIT.t() + ": " + (tag.func_74767_n(DISABLE_LIMIT_TAG) ? FluxTranslate.NO_LIMIT.t() : Long.valueOf(tag.func_74763_f(TRANSFER_LIMIT_TAG))));
            list.add(FluxTranslate.PRIORITY.t() + ": " + tag.func_74763_f(PRIORITY_TAG));
        } else {
            super.func_77624_a(stack, world, list, flag);
        }
    }

    public static class FluxConnectorRegistry<T extends Block>
    extends SonarRegistryBlock<T> {
        public FluxConnectorRegistry(T block, String name, Class tile) {
            super(block, name, tile);
        }

        public FluxConnectorRegistry(T block, String name) {
            super(block, name);
        }

        public ModelResourceLocation getItemBlockRendererLocation(String modid, Item item) {
            if (this.getValue() instanceof FluxStorage) {
                return new ModelResourceLocation(modid + ':' + "fluxstoragebuiltin", "inventory");
            }
            return super.getItemBlockRendererLocation(modid, item);
        }

        public Item getItemBlock() {
            return new ItemNetworkConnector((Block)this.value);
        }
    }
}

