/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.client.gui.tabs;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.core.SonarCore;
import sonar.core.client.gui.SonarButtons;
import sonar.core.sync.ISonarValue;
import sonar.core.sync.SyncValueHandler;
import sonar.flux.FluxTranslate;
import sonar.flux.client.gui.GuiAbstractTab;
import sonar.flux.client.gui.GuiTab;
import sonar.flux.common.tileentity.TileController;

public class GuiTabWirelessCharging
extends GuiAbstractTab<TileController> {
    public static final ResourceLocation inventory_configuration = new ResourceLocation("fluxnetworks:textures/gui/inventory_configuration.png");

    public GuiTabWirelessCharging(TileController tile, List<GuiTab> tabs) {
        super(tile, tabs);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new InventoryConfigButton(this, flux -> flux.main_inventory, FluxTranslate.WIRELESS_CHARGE_INVENTORY.t(), 0, this.getGuiLeft() + 32, this.getGuiTop() + 48, 0, 0, 112, 40));
        this.field_146292_n.add(new InventoryConfigButton(this, flux -> flux.hot_bar, FluxTranslate.WIRELESS_CHARGE_HOTBAR.t(), 1, this.getGuiLeft() + 32, this.getGuiTop() + 98, 112, 0, 112, 16));
        this.field_146292_n.add(new InventoryConfigButton(this, flux -> flux.armour_slot, FluxTranslate.WIRELESS_CHARGE_ARMOUR.t(), 2, this.getGuiLeft() + 24, this.getGuiTop() + 24, 224, 0, 52, 16));
        this.field_146292_n.add(new InventoryConfigButton(this, flux -> flux.baubles_slot, FluxTranslate.WIRELESS_CHARGE_BAUBLES.t(), 3, this.getGuiLeft() + 100, this.getGuiTop() + 24, 224, 0, 52, 16));
        this.field_146292_n.add(new InventoryConfigButton(this, flux -> flux.left_hand, FluxTranslate.WIRELESS_CHARGE_LEFT_HAND.t(), 4, this.getGuiLeft() + 24, this.getGuiTop() + 128, 276, 0, 16, 16));
        this.field_146292_n.add(new InventoryConfigButton(this, flux -> flux.right_hand, FluxTranslate.WIRELESS_CHARGE_RIGHT_HAND.t(), 5, this.getGuiLeft() + 136, this.getGuiTop() + 128, 276, 0, 16, 16));
    }

    @Override
    public void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button instanceof InventoryConfigButton) {
            SyncValueHandler.invertBoolean(((InventoryConfigButton)button).value.apply((TileController)this.flux));
            SonarCore.sendPacketToServer((TileEntity)this.flux, (int)15);
        }
    }

    @Override
    public GuiTab getCurrentTab() {
        return GuiTab.WIRELESS_CHARGING;
    }

    public ResourceLocation getBackground() {
        return blank_flux_gui;
    }

    @SideOnly(value=Side.CLIENT)
    private class InventoryConfigButton
    extends SonarButtons.ImageButton {
        public int field_146127_k;
        public GuiTabWirelessCharging gui;
        public Function<TileController, ISonarValue<Boolean>> value;
        public String hover;

        public InventoryConfigButton(GuiTabWirelessCharging gui, Function<TileController, ISonarValue<Boolean>> isActive, String hover, int id, int x, int y, int texX, int texY, int sizeX, int sizeY) {
            super(id, x, y, inventory_configuration, texX / 2, texY / 2, sizeX, sizeY);
            this.field_146127_k = id;
            this.value = isActive;
            this.hover = hover;
            this.gui = gui;
        }

        public void func_146111_b(int x, int y) {
            if (!this.hover.isEmpty()) {
                this.gui.drawSonarCreativeTabHoveringText(this.hover + ": " + FluxTranslate.translateBoolean((Boolean)this.value.apply((TileController)this.gui.flux).getValue()), x, y);
            }
        }

        public void func_191745_a(Minecraft mc, int x, int y, float partialTicks) {
            if (this.field_146125_m) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146123_n = x >= this.field_146128_h && y >= this.field_146129_i && x < this.field_146128_h + this.field_146120_f + 1 && y < this.field_146129_i + this.field_146121_g + 1;
                mc.func_110434_K().func_110577_a(this.texture);
                GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
                this.func_73729_b(this.field_146128_h / 2, this.field_146129_i / 2, this.textureX, (Boolean)this.value.apply((TileController)this.gui.flux).getValue() != false ? this.textureY + this.sizeY / 2 : this.textureY, this.sizeX / 2, this.sizeY / 2);
                GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
            }
        }
    }
}

