/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.client.gui.tabs;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.ResourceLocation;
import sonar.core.client.gui.GuiGridElement;
import sonar.core.client.gui.GuiSonar;
import sonar.core.client.gui.IGridGui;
import sonar.core.client.gui.SelectionGrid;
import sonar.core.client.gui.widgets.SonarScroller;
import sonar.flux.client.gui.GuiAbstractTab;
import sonar.flux.common.tileentity.TileFlux;

public abstract class GuiTabSelectionGrid<T extends TileFlux, G>
extends GuiAbstractTab<T>
implements IGridGui<G> {
    public Map<SelectionGrid, SonarScroller> grids = new HashMap<SelectionGrid, SonarScroller>();

    public GuiTabSelectionGrid(T tile, List tabs) {
        super(tile, tabs);
    }

    public abstract List getGridList(int var1);

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        HashMap<SelectionGrid, SonarScroller> newgrids = new HashMap<SelectionGrid, SonarScroller>();
        this.addGrids(newgrids);
        this.grids = newgrids;
    }

    public abstract void addGrids(Map<SelectionGrid, SonarScroller> var1);

    public void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        if (button == 0 || button == 1) {
            this.grids.forEach((grid, scroll) -> grid.mouseClicked((GuiSonar)this, x, y, button));
        }
    }

    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        for (Map.Entry<SelectionGrid, SonarScroller> entry : this.grids.entrySet()) {
            if (entry.getKey().isScrollable()) {
                this.renderScroller(entry.getValue());
            }
            entry.getKey().renderGrid((GuiSonar)this, x, y);
        }
    }

    public void renderScroller(SonarScroller scroller) {
        GuiTabSelectionGrid.func_73734_a((int)scroller.left, (int)scroller.top, (int)(scroller.left + scroller.width), (int)(scroller.top + scroller.length), (int)grey);
        GuiTabSelectionGrid.func_73734_a((int)(scroller.left + 1), (int)(scroller.top + 1), (int)(scroller.left + scroller.width - 1), (int)(scroller.top + scroller.length - 1), (int)black);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture(this.getBackground());
        this.func_73729_b(scroller.left, scroller.top + (int)((float)(scroller.length - 17) * scroller.getCurrentScroll()), 176, 0, 10, 15);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void startToolTipRender(int gridID, G selection, int x, int y) {
        GlStateManager.func_179097_i();
        GlStateManager.func_179140_f();
        this.renderElementToolTip(gridID, selection, x, y);
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74518_a();
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.grids.forEach((grid, scroll) -> scroll.handleMouse((GuiGridElement)grid));
    }

    public void func_73863_a(int x, int y, float var) {
        super.func_73863_a(x, y, var);
        for (Map.Entry<SelectionGrid, SonarScroller> entry : this.grids.entrySet()) {
            entry.getKey().setList((List)Lists.newArrayList((Iterable)this.getGridList(entry.getKey().gridID)));
            entry.getValue().drawScreen(x - this.field_147003_i, y - this.field_147009_r, entry.getKey().isScrollable());
        }
    }

    public float getCurrentScroll(SelectionGrid gridID) {
        return this.grids.get(gridID).getCurrentScroll();
    }

    public ResourceLocation getBackground() {
        return scroller_flux_gui;
    }
}

