/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.client.gui.tabs;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import sonar.core.client.gui.IGridGui;
import sonar.core.client.gui.SelectionGrid;
import sonar.core.client.gui.widgets.SonarScroller;
import sonar.flux.FluxNetworks;
import sonar.flux.FluxTranslate;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.client.gui.GuiTab;
import sonar.flux.client.gui.tabs.GuiTabConfirmNetworkDeletion;
import sonar.flux.client.gui.tabs.GuiTabSelectionGrid;
import sonar.flux.common.tileentity.TileFlux;
import sonar.flux.connection.NetworkSettings;
import sonar.flux.network.PacketHelper;
import sonar.flux.network.PacketType;

public class GuiTabNetworkSelection
extends GuiTabSelectionGrid<TileFlux, IFluxNetwork> {
    public GuiTabNetworkSelection(TileFlux tile, List tabs) {
        super(tile, tabs);
    }

    @Override
    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        if (this.getGridList(0).isEmpty()) {
            this.renderNavigationPrompt(FluxTranslate.ERROR_NO_NETWORKS.t(), FluxTranslate.GUI_TAB_NETWORK_CREATE.t());
        }
    }

    @Override
    public void addGrids(Map<SelectionGrid, SonarScroller> grids) {
        SelectionGrid grid = new SelectionGrid((IGridGui)this, 0, 11, 8, 154, 11, 1, 13);
        SonarScroller scroller = new SonarScroller(grid.xPos + grid.gWidth * grid.eWidth, grid.yPos, grid.gHeight * grid.eHeight, 7);
        grids.put(grid, scroller);
    }

    public void onGridClicked(int gridID, IFluxNetwork element, int x, int y, int pos, int button, boolean empty) {
        if (element != null) {
            if (x - this.getGuiLeft() > 153) {
                FMLCommonHandler.instance().showGuiScreen((Object)new GuiTabConfirmNetworkDeletion(this.flux, element, this, this.tabs));
                return;
            }
            if (!this.isSelectedNetwork(element)) {
                PacketHelper.sendPacketToServer(PacketType.SET_NETWORK, this.flux, PacketHelper.createNetworkSetPacket(element.getNetworkID()));
            }
        }
    }

    public void renderGridElement(int gridID, IFluxNetwork element, int x, int y, int slot) {
        this.renderNetwork(NetworkSettings.NETWORK_NAME.getValue(element), NetworkSettings.NETWORK_ACCESS.getValue(element), NetworkSettings.NETWORK_COLOUR.getValue(element).getRGB(), this.isSelectedNetwork(element), 0, 0);
        this.bindTexture(small_buttons);
        this.func_73729_b(142, 0, 48, 12, 11, 11);
    }

    public void renderElementToolTip(int gridID, IFluxNetwork element, int x, int y) {
        ArrayList<String> strings = new ArrayList<String>();
        if (x > 153) {
            strings.add(TextFormatting.RED + FluxTranslate.DELETE.t() + ": " + NetworkSettings.NETWORK_NAME.getValue(element));
        } else {
            strings.add(FluxTranslate.NETWORK_OWNER.t() + ": " + TextFormatting.AQUA + NetworkSettings.NETWORK_CACHED_NAME.getValue(element));
            strings.add(FluxTranslate.ACCESS_SETTING.t() + ": " + TextFormatting.AQUA + NetworkSettings.NETWORK_ACCESS.getValue(element).getDisplayName());
        }
        this.func_146283_a(strings, x, y);
    }

    @Override
    public List getGridList(int gridID) {
        return FluxNetworks.getClientCache().getAllNetworks();
    }

    public boolean isSelectedNetwork(IFluxNetwork network) {
        return network.getNetworkID() == this.getNetworkID();
    }

    @Override
    public GuiTab getCurrentTab() {
        return GuiTab.NETWORK_SELECTION;
    }
}

