/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.client.gui.tabs;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.text.TextFormatting;
import sonar.core.client.gui.IGridGui;
import sonar.core.client.gui.SelectionGrid;
import sonar.core.client.gui.SonarTextField;
import sonar.core.client.gui.widgets.SonarScroller;
import sonar.core.helpers.FontHelper;
import sonar.flux.FluxNetworks;
import sonar.flux.FluxTranslate;
import sonar.flux.api.network.FluxPlayer;
import sonar.flux.api.network.PlayerAccess;
import sonar.flux.client.gui.GuiTab;
import sonar.flux.client.gui.buttons.SmallButton;
import sonar.flux.client.gui.tabs.GuiTabSelectionGrid;
import sonar.flux.common.tileentity.TileFlux;
import sonar.flux.connection.NetworkSettings;
import sonar.flux.network.PacketHelper;
import sonar.flux.network.PacketType;

public class GuiTabNetworkPlayers
extends GuiTabSelectionGrid<TileFlux, FluxPlayer> {
    public SonarTextField playerName;

    public GuiTabNetworkPlayers(TileFlux tile, List tabs) {
        super(tile, tabs);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int networkColour = this.getNetworkColour();
        this.field_146292_n.add(new SmallButton(this, 1, this.getGuiLeft() + 150, this.getGuiTop() + 138, 72, 24, FluxTranslate.ADD.t()));
        this.playerName = new SonarTextField(1, this.getFontRenderer(), 14, 138, 130, 12).setBoxOutlineColour(networkColour);
        this.playerName.func_146203_f(24);
        this.playerName.func_146180_a("");
        this.fieldList.add(this.playerName);
    }

    @Override
    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        if (this.getGridList(0).isEmpty()) {
            if (this.common.isFakeNetwork()) {
                this.renderNavigationPrompt(FluxTranslate.ERROR_NO_PLAYERS_CAN_BE_ADDED.t(), FluxTranslate.GUI_TAB_NETWORK_SELECTION.t());
            } else if (this.disabled) {
                this.renderNavigationPrompt(FluxTranslate.ERROR_UNAVAILABLE_IN_PRIVATE.t(), FluxTranslate.GUI_TAB_NETWORK_EDIT.t());
            }
        }
    }

    @Override
    public void addGrids(Map<SelectionGrid, SonarScroller> grids) {
        SelectionGrid grid = new SelectionGrid((IGridGui)this, 0, 11, 8, 154, 11, 1, 11);
        SonarScroller scroller = new SonarScroller(grid.xPos + grid.gWidth * grid.eWidth, grid.yPos, grid.gHeight * grid.eHeight, 7);
        grids.put(grid, scroller);
    }

    @Override
    public void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        switch (button.field_146127_k) {
            case 1: {
                if (this.playerName.func_146179_b().isEmpty()) break;
                PacketHelper.sendPacketToServer(PacketType.ADD_PLAYER, this.flux, PacketHelper.createAddPlayerPacket(this.flux.getNetworkID(), this.playerName.func_146179_b(), PlayerAccess.USER));
                return;
            }
        }
    }

    public void onGridClicked(int gridID, FluxPlayer element, int x, int y, int pos, int button, boolean empty) {
        if (element != null) {
            if (x - this.getGuiLeft() > 153) {
                if (element.getAccess() != PlayerAccess.OWNER) {
                    PacketHelper.sendPacketToServer(PacketType.REMOVE_PLAYER, this.flux, PacketHelper.createRemovePlayerPacket(this.flux.getNetworkID(), element.getOnlineUUID(), PlayerAccess.USER));
                }
            } else if (button == 1) {
                PacketHelper.sendPacketToServer(PacketType.CHANGE_PLAYER, this.flux, PacketHelper.createChangePlayerPacket(this.flux.getNetworkID(), element.getOnlineUUID(), element.getAccess()));
            }
        }
    }

    public void renderGridElement(int gridID, FluxPlayer element, int x, int y, int slot) {
        PlayerAccess access = element.getAccess();
        boolean isOwner = NetworkSettings.NETWORK_CACHED_NAME.getValue(this.common).equals(element.getCachedName());
        Gui.func_73734_a((int)0, (int)0, (int)154, (int)12, (int)(access.canDelete() || isOwner ? Color.lightGray.getRGB() : (access.canEdit() ? colours[7].getRGB() : (!access.canConnect() ? colours[4].getRGB() : lightBlue))));
        this.bindTexture(this.getBackground());
        this.func_73729_b(0, 0, 0, 166, 154, 12);
        FontHelper.text((String)element.getCachedName(), (int)3, (int)2, (int)Color.white.getRGB());
        this.bindTexture(small_buttons);
        this.func_73729_b(142, 0, 48, 12, 11, 11);
    }

    public void renderElementToolTip(int gridID, FluxPlayer element, int x, int y) {
        ArrayList<String> strings = new ArrayList<String>();
        boolean isOwner = NetworkSettings.NETWORK_CACHED_NAME.getValue(this.common).equals(element.getCachedName());
        if (x > 153) {
            strings.add(TextFormatting.RED + FluxTranslate.DELETE.t() + ": " + element.getCachedName());
        } else {
            strings.add(TextFormatting.AQUA + FluxTranslate.CONFIG.t() + ": " + FontHelper.translate((String)(isOwner ? PlayerAccess.OWNER.getName() : element.getAccess().getName())));
            strings.add(FluxTranslate.RIGHT_CLICK_TO_CHANGE.t());
        }
        this.func_146283_a(strings, x, y);
    }

    @Override
    public void startToolTipRender(int gridID, FluxPlayer selection, int x, int y) {
        GlStateManager.func_179097_i();
        GlStateManager.func_179140_f();
        this.renderElementToolTip(gridID, selection, x, y);
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74520_c();
    }

    @Override
    public List getGridList(int gridID) {
        this.common = FluxNetworks.getClientCache().getNetwork(this.getNetworkID());
        return NetworkSettings.NETWORK_PLAYERS.getValue(this.common);
    }

    @Override
    public GuiTab getCurrentTab() {
        return GuiTab.PLAYERS;
    }
}

