/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.client.gui;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import sonar.core.api.energy.EnergyType;
import sonar.core.client.gui.GuiSonar;
import sonar.core.helpers.FontHelper;
import sonar.core.utils.CustomColour;
import sonar.flux.FluxNetworks;
import sonar.flux.FluxTranslate;
import sonar.flux.api.AccessType;
import sonar.flux.api.ClientTransfer;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.api.tiles.IFlux;
import sonar.flux.client.gui.GuiTab;
import sonar.flux.client.gui.buttons.NavigationButtons;
import sonar.flux.common.containers.ContainerFlux;
import sonar.flux.common.tileentity.TileFlux;
import sonar.flux.connection.NetworkSettings;
import sonar.flux.network.PacketHelper;
import sonar.flux.network.PacketType;

public abstract class GuiAbstractTab<T extends TileFlux>
extends GuiSonar {
    public List<GuiTab> tabs;
    public static final ResourceLocation small_buttons = new ResourceLocation("fluxnetworks:textures/gui/buttons/small_buttons.png");
    public static final ResourceLocation large_buttons = new ResourceLocation("fluxnetworks:textures/gui/buttons/large_buttons.png");
    public static final ResourceLocation navigation = new ResourceLocation("fluxnetworks:textures/gui/navigation.png");
    public static final ResourceLocation scroller_flux_gui = new ResourceLocation("fluxnetworks:textures/gui/scroller_flux_gui.png");
    public static final ResourceLocation blank_flux_gui = new ResourceLocation("fluxnetworks:textures/gui/blank_flux_gui.png");
    public static final CustomColour[] colours = new CustomColour[]{new CustomColour(41, 94, 138), new CustomColour(52, 52, 119), new CustomColour(88, 42, 114), new CustomColour(136, 45, 96), new CustomColour(170, 57, 57), new CustomColour(170, 111, 57), new CustomColour(198, 185, 0), new CustomColour(96, 151, 50)};
    public static final int midBlue = FontHelper.getIntFromColor((int)41, (int)94, (int)138);
    public static final int lightBlue = FontHelper.getIntFromColor((int)90, (int)180, (int)255);
    public static final int darkBlue = FontHelper.getIntFromColor((int)37, (int)61, (int)81);
    public static final int grey = FontHelper.getIntFromColor((int)85, (int)85, (int)85);
    public static final int black = FontHelper.getIntFromColor((int)0, (int)0, (int)0);
    public int errorDisplayTicks;
    public long errorDisplayTime = 0L;
    public int errorDisplayTime_MS = 3000;
    public boolean disabled = false;
    public final T flux;
    public IFluxNetwork common;

    public GuiAbstractTab(T tile, List<GuiTab> tabs) {
        super((Container)new ContainerFlux((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (TileFlux)tile));
        this.flux = tile;
        this.tabs = tabs;
        this.common = FluxNetworks.getClientCache().getNetwork(this.getNetworkID());
    }

    public abstract GuiTab getCurrentTab();

    public void func_73866_w_() {
        super.func_73866_w_();
        int i = 0;
        for (GuiTab state : this.tabs) {
            this.field_146292_n.add(new NavigationButtons(this, state, -i, this.field_147003_i + 2 + 18 * i, this.field_147009_r - 15));
            ++i;
        }
    }

    public void func_191948_b(int x, int y) {
        super.func_191948_b(x, y);
        if (((TileFlux)this.flux).error != null) {
            this.func_146279_a(TextFormatting.RED + ((TileFlux)this.flux).error.getErrorMessage(), x, y);
            if (this.errorDisplayTicks == 0) {
                this.errorDisplayTime = System.currentTimeMillis();
            }
            ++this.errorDisplayTicks;
            if (System.currentTimeMillis() >= this.errorDisplayTime + (long)this.errorDisplayTime_MS) {
                ((TileFlux)this.flux).error = null;
                this.errorDisplayTicks = 0;
            }
        }
    }

    public int getNetworkID() {
        return ((TileFlux)this.flux).getNetworkID();
    }

    public void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button instanceof NavigationButtons) {
            this.switchTab(((NavigationButtons)button).tab);
        }
    }

    public void switchTab(GuiTab tab) {
        if (tab != this.getCurrentTab()) {
            Object screen = tab.getGuiScreen((TileFlux)this.flux, this.tabs);
            FMLCommonHandler.instance().showGuiScreen(screen);
            PacketHelper.sendPacketToServer(PacketType.GUI_STATE_CHANGE, this.flux, PacketHelper.createStateChangePacket(this.getCurrentTab(), tab));
            ((TileFlux)this.flux).error = null;
        }
    }

    public void func_73869_a(char c, int i) throws IOException {
        boolean isTyping;
        if (this.isCloseKey(i) && !(isTyping = this.fieldList.stream().anyMatch(GuiTextField::func_146206_l))) {
            if (this.getCurrentTab() != GuiTab.INDEX) {
                this.switchTab(GuiTab.INDEX);
                return;
            }
            PacketHelper.sendPacketToServer(PacketType.GUI_STATE_CHANGE, this.flux, PacketHelper.createStateChangePacket(this.getCurrentTab(), null));
        }
        super.func_73869_a(c, i);
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public int getNetworkColour() {
        return NetworkSettings.NETWORK_COLOUR.getValue(this.common).getRGB();
    }

    public void renderNetwork(String networkName, AccessType access, int rgb, boolean isSelected, int x, int y) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiAbstractTab.func_73734_a((int)x, (int)y, (int)(x + 154), (int)(y + 12), (int)rgb);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(scroller_flux_gui);
        this.func_73729_b(x, y, 0, 166, 154, 12);
        FontHelper.text((String)networkName, (int)(x + 3), (int)(y + 2), (int)(isSelected ? Color.WHITE.getRGB() : Color.DARK_GRAY.getRGB()));
    }

    public void renderNetworkInFull(String networkName, AccessType access, int rgb, boolean isSelected, int x, int y) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiAbstractTab.func_73734_a((int)x, (int)y, (int)(x + 154), (int)(y + 24), (int)rgb);
        GuiAbstractTab.func_73734_a((int)(x + 1), (int)(y + 1), (int)(x + 154 - 1), (int)(y + 24 - 1), (int)Color.BLACK.getRGB());
        FontHelper.text((String)(TextFormatting.BOLD + networkName), (int)(x + 3), (int)(y + 2), (int)(isSelected ? Color.WHITE.getRGB() : Color.DARK_GRAY.getRGB()));
        FontHelper.text((String)(FluxTranslate.ACCESS_SETTING.t() + ": " + TextFormatting.AQUA + access.getDisplayName()), (int)(x + 3), (int)(y + 13), (int)0);
    }

    public void renderEnergyBar(int x, int y, long stored, long max, int startCol, int endCol) {
        GuiAbstractTab.func_73734_a((int)x, (int)y, (int)(this.field_146999_f - x), (int)(y + 16), (int)Color.DARK_GRAY.getRGB());
        GuiAbstractTab.func_73734_a((int)(x + 1), (int)(y + 1), (int)(this.field_146999_f - x - 1), (int)(y + 15), (int)Color.BLACK.getRGB());
        if (max != 0L && stored != 0L) {
            long k = stored * (long)(this.field_146999_f - x * 2) / max;
            this.func_73733_a(x + 1, y + 1, (int)((long)(x - 1) + k), y + 15, startCol, endCol);
        }
        FontHelper.textCentre((String)(FontHelper.formatStorage((long)stored) + '/' + FontHelper.formatStorage((long)max)), (int)this.field_146999_f, (int)(y + 4), (int)-1);
    }

    public void renderNavigationPrompt(String error, String prompt) {
        FontHelper.textCentre((String)error, (int)this.field_146999_f, (int)10, (int)Color.GRAY.getRGB());
        GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
        FontHelper.textCentre((String)(FluxTranslate.CLICK.t() + TextFormatting.AQUA + ' ' + prompt + ' ' + TextFormatting.RESET + FluxTranslate.ABOVE.t()), (int)((int)((double)this.field_146999_f * 1.0 / 0.75)), (int)26, (int)Color.GRAY.getRGB());
        GlStateManager.func_179139_a((double)1.3333333333333333, (double)1.3333333333333333, (double)1.3333333333333333);
    }

    public void renderFlux(IFlux flux, boolean isSelected, int x, int y) {
        int rgb = this.getCurrentTab() == GuiTab.INDEX ? NetworkSettings.NETWORK_COLOUR.getValue(this.common).getRGB() : flux.getConnectionType().gui_colour;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiAbstractTab.func_73734_a((int)x, (int)y, (int)(x + 154), (int)(y + 18), (int)rgb);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(scroller_flux_gui);
        if (flux.isChunkLoaded()) {
            this.func_73729_b(x, y, 0, 166, 154, 10);
            this.func_73729_b(x, y + 10, 0, 170, 154, 8);
        } else {
            this.func_73729_b(x, y, 0, 226, 154, 18);
        }
        ItemStack displayStack = flux.getDisplayStack();
        NBTTagCompound colourTag = displayStack.func_77942_o() ? displayStack.func_77978_p() : new NBTTagCompound();
        colourTag.func_74757_a("gui_colour", true);
        displayStack.func_77982_d(colourTag);
        this.drawNormalItemStack(displayStack, x + 2, y + 1);
        if (this.getCurrentTab() == GuiTab.INDEX) {
            ArrayList<String> textLines = new ArrayList<String>();
            this.addTransferStrings(textLines, flux.getConnectionType(), NetworkSettings.NETWORK_ENERGY_TYPE.getValue(this.common), flux.getTransferHandler().getAdded(), flux.getTransferHandler().getRemoved());
            FontHelper.text((String)((String)textLines.get(0)), (int)24, (int)5, (int)(!flux.isChunkLoaded() ? FontHelper.getIntFromColor((int)180, (int)40, (int)40) : Color.WHITE.getRGB()));
        } else {
            FontHelper.text((String)flux.getCustomName(), (int)24, (int)5, (int)(!flux.isChunkLoaded() ? FontHelper.getIntFromColor((int)180, (int)40, (int)40) : (isSelected ? flux.getConnectionType().gui_colour : Color.WHITE.getRGB())));
        }
    }

    public List<String> getTextLines(IFlux flux) {
        ArrayList<String> textLines = new ArrayList<String>();
        textLines.add(TextFormatting.BOLD + flux.getCustomName());
        if (flux.isChunkLoaded()) {
            this.addTransferStrings(textLines, flux.getConnectionType(), NetworkSettings.NETWORK_ENERGY_TYPE.getValue(this.common), flux.getTransferHandler().getAdded(), flux.getTransferHandler().getRemoved());
            if (flux.getTransferHandler().getBuffer() != 0L) {
                textLines.add("Internal Buffer: " + FontHelper.formatStorage((EnergyType)NetworkSettings.NETWORK_ENERGY_TYPE.getValue(this.common), (long)flux.getTransferHandler().getBuffer()));
            }
            textLines.add(FluxTranslate.TRANSFER_LIMIT.t() + ": " + TextFormatting.GREEN + (flux.getTransferLimit() == Long.MAX_VALUE ? FluxTranslate.NO_LIMIT.t() : Long.valueOf(flux.getTransferLimit())));
            textLines.add(FluxTranslate.PRIORITY.t() + ": " + TextFormatting.GREEN + (flux.getCurrentPriority() == Integer.MAX_VALUE ? FluxTranslate.PRIORITY_SURGE : Integer.valueOf(flux.getCurrentPriority())));
        } else {
            textLines.add(TextFormatting.DARK_RED + FluxTranslate.ERROR_CHUNK_UNLOADED.t());
        }
        textLines.add(TextFormatting.ITALIC + flux.getCoords().toString());
        return textLines;
    }

    public void renderFluxTransfer(ClientTransfer transfer, int x, int y, int rgb) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiAbstractTab.func_73734_a((int)x, (int)y, (int)(x + 154), (int)(y + 18), (int)rgb);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(scroller_flux_gui);
        this.func_73729_b(x, y, 0, 166, 154, 10);
        this.func_73729_b(x, y + 10, 0, 170, 154, 8);
        String direction = transfer.direction == null ? FluxTranslate.PHANTOM.t() : transfer.direction.toString().toUpperCase();
        String transferS = FontHelper.formatOutput((EnergyType)transfer.energyType, (long)transfer.added);
        this.drawNormalItemStack(transfer.stack, x + 2, y + 1);
        ArrayList<String> textLines = new ArrayList<String>();
        this.addTransferStrings(textLines, transfer.handler.flux.getConnectionType(), transfer.getEnergyType(), transfer.added, transfer.removed);
        GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
        FontHelper.text((String)transfer.stack.func_82833_r(), (int)34, (int)3, (int)rgb);
        FontHelper.text((String)((String)textLines.get(0)), (int)34, (int)14, (int)rgb);
    }

    public List<String> getTextLines(ClientTransfer transfer) {
        ArrayList<String> textLines = new ArrayList<String>();
        textLines.add(TextFormatting.BOLD + transfer.stack.func_82833_r());
        IFlux.ConnectionType type = transfer.handler.flux.getConnectionType();
        this.addTransferStrings(textLines, type, transfer.getEnergyType(), transfer.added, transfer.removed);
        textLines.add(FluxTranslate.TYPE.t() + ": " + transfer.energyType.getName());
        return textLines;
    }

    public void addTransferStrings(List<String> string, IFlux.ConnectionType type, EnergyType energyType, long added, long removed) {
        if (type == IFlux.ConnectionType.STORAGE) {
            long change = Math.abs(removed) - added;
            if (change == 0L) {
                string.add(FluxTranslate.CHANGE.t() + ":" + TextFormatting.GOLD + " " + FontHelper.formatOutput((EnergyType)energyType, (long)change));
            } else if (change < 0L) {
                string.add(FluxTranslate.CHANGE.t() + ":" + TextFormatting.RED + " - " + FontHelper.formatOutput((EnergyType)energyType, (long)Math.abs(change)));
            } else {
                string.add(FluxTranslate.CHANGE.t() + ":" + TextFormatting.GREEN + " + " + FontHelper.formatOutput((EnergyType)energyType, (long)change));
            }
            return;
        }
        if (type.canAdd()) {
            String addedString = FontHelper.formatOutput((EnergyType)energyType, (long)added);
            if (added == 0L) {
                string.add(FluxTranslate.TOTAL_INPUT.t() + ":" + TextFormatting.GOLD + " " + addedString);
            } else {
                string.add(FluxTranslate.TOTAL_INPUT.t() + ":" + TextFormatting.GREEN + " + " + addedString);
            }
        }
        if (type.canRemove()) {
            String removedString = FontHelper.formatOutput((EnergyType)energyType, (long)removed);
            if (removed == 0L) {
                string.add(FluxTranslate.TOTAL_OUTPUT.t() + ":" + TextFormatting.GOLD + " " + removedString);
            } else {
                string.add(FluxTranslate.TOTAL_OUTPUT.t() + ":" + TextFormatting.RED + " - " + removedString);
            }
        }
    }
}

