/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.client;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.helpers.FontHelper;
import sonar.flux.FluxNetworks;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.client.gui.GuiAbstractTab;
import sonar.flux.common.block.FluxConnection;
import sonar.flux.common.tileentity.TileFlux;
import sonar.flux.connection.NetworkSettings;
import sonar.flux.network.PacketColourRequest;

public class FluxColourHandler
implements IBlockColor,
IItemColor {
    public static final FluxColourHandler INSTANCE = new FluxColourHandler();
    public static final int DEFAULT_COLOUR = FontHelper.getIntFromColor((int)41, (int)94, (int)138);
    public static final int NO_NETWORK_COLOUR = FontHelper.getIntFromColor((int)178, (int)178, (int)178);
    public static final Map<Integer, Integer> colourCache = new HashMap<Integer, Integer>();
    public static final Map<Integer, String> nameCache = new HashMap<Integer, String>();
    private static List<Integer> requests = new ArrayList<Integer>();
    private static List<Integer> sent_requests = new ArrayList<Integer>();
    public static int tickCount;

    public static void reset() {
        colourCache.clear();
        nameCache.clear();
        requests.clear();
    }

    public static void loadColourCache(int id, int colour) {
        if (id != -1) {
            colourCache.put(id, colour);
        }
    }

    public static void loadNameCache(int id, String name) {
        if (id != -1) {
            nameCache.put(id, name);
        }
    }

    public static void placeRequest(int id) {
        if (id != -1 && !requests.contains(id) && !sent_requests.contains(id)) {
            requests.add(id);
        }
    }

    public static int getOrRequestNetworkColour(int id) {
        if (id == -1) {
            return NO_NETWORK_COLOUR;
        }
        Integer cached = colourCache.get(id);
        if (cached != null) {
            return cached;
        }
        FluxColourHandler.placeRequest(id);
        return NO_NETWORK_COLOUR;
    }

    public static String getOrRequestNetworkName(int id) {
        if (id == -1) {
            return "NONE";
        }
        String cached = nameCache.get(id);
        if (cached != null) {
            return cached;
        }
        FluxColourHandler.placeRequest(id);
        return "WAITING FOR SERVER";
    }

    public static void sendRequests() {
        if (!requests.isEmpty() && ++tickCount > 40) {
            tickCount = 0;
            FluxNetworks.network.sendToServer((IMessage)new PacketColourRequest(Lists.newArrayList(requests)));
            sent_requests.addAll(requests);
            requests = new ArrayList<Integer>();
        }
    }

    public static void receiveCache(Map<Integer, Tuple<Integer, String>> cache) {
        cache.forEach((ID, DETAILS) -> {
            FluxColourHandler.loadColourCache(ID, (Integer)DETAILS.func_76341_a());
            FluxColourHandler.loadNameCache(ID, (String)DETAILS.func_76340_b());
            sent_requests.remove(ID);
            requests.remove(ID);
        });
    }

    public int func_186720_a(IBlockState state, @Nullable IBlockAccess world, @Nullable BlockPos pos, int tintIndex) {
        if (tintIndex == 1 && pos != null) {
            TileEntity tile = world.func_175625_s(pos);
            if (!((Boolean)state.func_177229_b((IProperty)FluxConnection.CONNECTED)).booleanValue()) {
                return NO_NETWORK_COLOUR;
            }
            if (tile instanceof TileFlux) {
                TileFlux plug = (TileFlux)tile;
                int colour = FluxColourHandler.getOrRequestNetworkColour(plug.getNetworkID());
                int red = colour >> 16 & 0xFF;
                int green = colour >> 8 & 0xFF;
                int blue = colour & 0xFF;
                return FontHelper.getIntFromColor((int)((int)Math.min((double)red * 1.5, 255.0)), (int)((int)Math.min((double)green * 1.5, 255.0)), (int)((int)Math.min((double)blue * 1.5, 255.0)));
            }
            return DEFAULT_COLOUR;
        }
        return -1;
    }

    public int func_186726_a(ItemStack stack, int tintIndex) {
        if (tintIndex == 1) {
            GuiScreen screen;
            if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("gui_colour") && (screen = Minecraft.func_71410_x().field_71462_r) instanceof GuiAbstractTab) {
                IFluxNetwork common = ((GuiAbstractTab)screen).common;
                return common.isFakeNetwork() ? NO_NETWORK_COLOUR : common.getSetting(NetworkSettings.NETWORK_COLOUR).getRGB();
            }
            NBTTagCompound tag = stack.func_179543_a("sonar_drop");
            if (tag != null) {
                return FluxColourHandler.getOrRequestNetworkColour(tag.func_74762_e("network_id"));
            }
            return NO_NETWORK_COLOUR;
        }
        return -1;
    }
}

