/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import sonar.core.SonarCore;
import sonar.flux.FluxConfig;
import sonar.flux.FluxNetworks;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.common.entity.EntityFireItem;
import sonar.flux.connection.NetworkSettings;
import sonar.flux.network.FluxNetworkCache;

public class FluxEvents {
    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.side == Side.CLIENT) {
            return;
        }
        FluxNetworkCache cache = FluxNetworks.getServerCache();
        List<IFluxNetwork> networks = cache.getAllNetworks();
        if (event.phase == TickEvent.Phase.START) {
            FluxNetworks.proxy.runnables.forEach(Runnable::run);
            FluxNetworks.proxy.runnables.clear();
            for (IFluxNetwork network : networks) {
                network.onStartServerTick();
            }
        }
        if (event.phase == TickEvent.Phase.END) {
            for (IFluxNetwork network : networks) {
                network.onEndServerTick();
            }
        }
    }

    @SubscribeEvent
    public void dropFluxEvent(BlockEvent.HarvestDropsEvent drops) {
        if (!FluxConfig.enableFluxRedstoneDrop || drops.getState().func_177230_c() != Blocks.field_150450_ax && drops.getState().func_177230_c() != Blocks.field_150439_ay || drops.getHarvester() instanceof FakePlayer || drops.isSilkTouching()) {
            return;
        }
        if (SonarCore.randInt((int)0, (int)FluxConfig.redstone_ore_chance) == 1) {
            drops.getDrops().add(new ItemStack(FluxNetworks.flux, Math.max(1, SonarCore.randInt((int)FluxConfig.redstone_ore_min_drop, (int)FluxConfig.redstone_ore_max_drop))));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityAdded(EntityJoinWorldEvent event) {
        EntityItem entityItem;
        ItemStack stack;
        if (!FluxConfig.enableFluxRecipe || event.getWorld().field_72995_K) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof EntityItem && !(entity instanceof EntityFireItem) && !(stack = (entityItem = (EntityItem)entity).func_92059_d()).func_190926_b() && stack.func_77973_b() == Items.field_151137_ax) {
            EntityFireItem newEntity = new EntityFireItem(entityItem);
            entityItem.func_70106_y();
            int i = MathHelper.func_76128_c((double)(newEntity.field_70165_t / 16.0));
            int j = MathHelper.func_76128_c((double)(newEntity.field_70161_v / 16.0));
            event.getWorld().func_72964_e(i, j).func_76612_a((Entity)newEntity);
            event.getWorld().field_72996_f.add(newEntity);
            event.getWorld().func_72923_a((Entity)newEntity);
            event.setCanceled(true);
        }
    }

    public static void logNewNetwork(IFluxNetwork network) {
        FluxNetworks.logger.info("[NEW NETWORK] '" + network.getSetting(NetworkSettings.NETWORK_NAME) + "' with ID '" + network.getNetworkID() + "' was created by " + network.getSetting(NetworkSettings.NETWORK_CACHED_NAME) + "( " + network.getSetting(NetworkSettings.NETWORK_OWNER) + " )");
    }

    public static void logRemoveNetwork(IFluxNetwork network) {
        FluxNetworks.logger.info("[DELETE NETWORK] '" + network.getSetting(NetworkSettings.NETWORK_NAME) + "' with ID '" + network.getNetworkID() + "' was removed by " + network.getSetting(NetworkSettings.NETWORK_CACHED_NAME));
    }

    public static void logLoadedNetwork(IFluxNetwork network) {
        FluxNetworks.logger.info("[LOADED NETWORK] '" + network.getSetting(NetworkSettings.NETWORK_NAME) + "' with ID '" + network.getNetworkID() + "' with owner " + network.getSetting(NetworkSettings.NETWORK_CACHED_NAME));
    }
}

