/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.gui;

import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.io.Bits;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import java.util.List;

public class TextField
extends Widget {
    public String[] text = StringUtils.EMPTY_ARRAY;
    public int textFlags = 0;
    public boolean autoSizeWidth = true;
    public boolean autoSizeHeight = true;

    public TextField(Panel panel, String txt, int flags) {
        super(panel);
        this.textFlags = flags;
        this.setText(txt);
    }

    public TextField(Panel panel, String txt) {
        this(panel, txt, 0);
    }

    public TextField setText(String txt) {
        Theme theme = this.getGui().getTheme();
        this.text = null;
        if (!txt.isEmpty()) {
            String[] stringArray = this.text = this.autoSizeWidth ? txt.split("\n") : theme.listFormattedStringToWidth(txt, this.width).toArray(StringUtils.EMPTY_ARRAY);
        }
        if (this.text == null || this.text.length == 0) {
            this.text = StringUtils.EMPTY_ARRAY;
        }
        if (this.autoSizeWidth) {
            this.setWidth(0);
            for (String s : this.text) {
                this.setWidth(Math.max(this.width, theme.getStringWidth(s)));
            }
        }
        if (this.autoSizeHeight) {
            this.setHeight(Math.max(this.text.length, 1) * (theme.getFontHeight() + 1));
        }
        return this;
    }

    @Override
    public void addMouseOverText(List<String> list) {
    }

    public void drawTextField(Theme theme, int x, int y, int w, int h) {
    }

    @Override
    public void draw(Theme theme, int x, int y, int w, int h) {
        this.drawTextField(theme, x, y, w, h);
        if (this.text.length == 0) {
            return;
        }
        boolean centered = Bits.getFlag(this.textFlags, 4);
        for (int i = 0; i < this.text.length; ++i) {
            if (centered) {
                theme.drawString(this.text[i], x + w / 2, y + i * 10 + 1, this.textFlags);
                continue;
            }
            theme.drawString(this.text[i], x, y + i * 10 + 1, this.textFlags);
        }
    }
}

