/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.config;

import com.feed_the_beast.ftblib.lib.config.ConfigInt;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.ConfigValueInstance;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.google.gson.JsonElement;
import java.util.List;
import java.util.function.LongSupplier;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class ConfigLong
extends ConfigValue
implements LongSupplier {
    public static final String ID = "long";
    private long value;
    private long min = Long.MIN_VALUE;
    private long max = Long.MAX_VALUE;

    public ConfigLong(long v) {
        this.value = v;
    }

    public ConfigLong(long v, long mn, long mx) {
        this(Math.min(Math.max(v, mn), mx));
        this.min = mn;
        this.max = mx;
    }

    public String func_176610_l() {
        return ID;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    public void setLong(long v) {
        this.value = v;
    }

    public ConfigLong setMin(long v) {
        this.min = v;
        return this;
    }

    public ConfigLong setMax(long v) {
        this.max = v;
        return this;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    @Override
    public ITextComponent getStringForGUI() {
        return new TextComponentString(StringUtils.formatDouble(this.getLong(), true));
    }

    @Override
    public String getString() {
        return Long.toString(this.getLong());
    }

    @Override
    public boolean getBoolean() {
        return (double)this.getLong() != 0.0;
    }

    @Override
    public int getInt() {
        return (int)this.getLong();
    }

    @Override
    public ConfigLong copy() {
        return new ConfigLong(this.getLong());
    }

    @Override
    public boolean equalsValue(ConfigValue value) {
        return this.getLong() == value.getLong();
    }

    @Override
    public Color4I getColor() {
        return ConfigInt.COLOR;
    }

    @Override
    public void addInfo(ConfigValueInstance inst, List<String> list) {
        super.addInfo(inst, list);
        long m = this.getMin();
        if (m != Long.MIN_VALUE) {
            list.add(TextFormatting.AQUA + "Min: " + TextFormatting.RESET + StringUtils.formatDouble(m));
        }
        if ((m = this.getMax()) != Long.MAX_VALUE) {
            list.add(TextFormatting.AQUA + "Max: " + TextFormatting.RESET + StringUtils.formatDouble(m));
        }
    }

    @Override
    public boolean setValueFromString(@Nullable ICommandSender sender, String string, boolean simulate) {
        if (string.isEmpty()) {
            return false;
        }
        try {
            long l = Long.parseLong(string);
            if (!simulate) {
                this.setLong(l);
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String key) {
        this.value = this.getLong();
        if (this.value != 0L) {
            nbt.func_74772_a(key, this.value);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String key) {
        this.setLong(nbt.func_74763_f(key));
    }

    @Override
    public void writeData(DataOut data) {
        data.writeLong(this.getLong());
        data.writeLong(this.getMin());
        data.writeLong(this.getMax());
    }

    @Override
    public void readData(DataIn data) {
        this.setLong(data.readLong());
        this.setMin(data.readLong());
        this.setMax(data.readLong());
    }

    @Override
    public long getAsLong() {
        return this.getLong();
    }

    @Override
    public void setValueFromOtherValue(ConfigValue value) {
        this.setLong(value.getLong());
    }

    @Override
    public void setValueFromJson(JsonElement json) {
        if (json.isJsonPrimitive()) {
            this.setLong(json.getAsLong());
        }
    }
}

