/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.command;

import com.feed_the_beast.ftblib.FTBLib;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.ForgeTeam;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.math.MathUtils;
import com.feed_the_beast.ftblib.lib.util.ServerUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.server.permission.PermissionAPI;

public class CommandUtils {
    public static CommandException error(ITextComponent component) {
        return new CommandException("disconnect.genericReason", new Object[]{component});
    }

    public static ForgePlayer getForgePlayer(ICommandSender sender) throws CommandException {
        ForgePlayer p = Universe.get().getPlayer(sender);
        if (p.isFake()) {
            throw new CommandException("commands.generic.player.notFound", new Object[]{sender.func_70005_c_()});
        }
        return p;
    }

    public static ForgePlayer getForgePlayer(ICommandSender sender, String name) throws CommandException {
        ForgePlayer p;
        switch (name) {
            case "@r": {
                ForgePlayer[] players = Universe.get().getOnlinePlayers().toArray(new ForgePlayer[0]);
                p = players.length == 0 ? null : players[MathUtils.RAND.nextInt(players.length)];
                break;
            }
            case "@ra": {
                ForgePlayer[] players = Universe.get().getPlayers().toArray(new ForgePlayer[0]);
                p = players.length == 0 ? null : players[MathUtils.RAND.nextInt(players.length)];
                break;
            }
            case "@p": {
                if (sender instanceof EntityPlayerMP && !ServerUtils.isFake((EntityPlayerMP)sender)) {
                    return Universe.get().getPlayer(sender);
                }
                p = null;
                double dist = Double.POSITIVE_INFINITY;
                for (ForgePlayer p1 : Universe.get().getOnlinePlayers()) {
                    if (p == null) {
                        p = p1;
                        continue;
                    }
                    Vec3d pos = sender.func_174791_d();
                    double d = p1.getPlayer().func_70092_e(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
                    if (!(d < dist)) continue;
                    dist = d;
                    p = p1;
                }
                break;
            }
            default: {
                p = Universe.get().getPlayer(name);
            }
        }
        if (p == null || p.isFake()) {
            throw new CommandException("commands.generic.player.notFound", new Object[]{name});
        }
        return p;
    }

    public static ForgeTeam getTeam(ICommandSender sender, String id) throws CommandException {
        ForgeTeam team = Universe.get().getTeam(id);
        if (team.isValid()) {
            return team;
        }
        throw FTBLib.error(sender, "ftblib.lang.team.error.not_found", id);
    }

    public static ForgePlayer getSelfOrOther(ICommandSender sender, String[] args, int index) throws CommandException {
        return CommandUtils.getSelfOrOther(sender, args, index, "");
    }

    public static ForgePlayer getSelfOrOther(ICommandSender sender, String[] args, int index, String specialPermForOther) throws CommandException {
        if (args.length <= index) {
            return CommandUtils.getForgePlayer(sender);
        }
        ForgePlayer p = CommandUtils.getForgePlayer(sender, args[index]);
        if (!specialPermForOther.isEmpty() && sender instanceof EntityPlayerMP && !p.getId().equals(((EntityPlayerMP)sender).func_110124_au()) && !PermissionAPI.hasPermission((EntityPlayer)((EntityPlayerMP)sender), (String)specialPermForOther)) {
            throw new CommandException("commands.generic.permission", new Object[0]);
        }
        return p;
    }

    public static List<String> getDimensionNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("all");
        list.add("overworld");
        list.add("nether");
        list.add("end");
        for (Integer dim : DimensionManager.getStaticDimensionIDs()) {
            if (dim == null || dim >= -1 && dim <= 1) continue;
            list.add(dim.toString());
        }
        return list;
    }

    public static OptionalInt parseDimension(ICommandSender sender, String[] args, int index) throws CommandException {
        if (args.length <= index) {
            return OptionalInt.empty();
        }
        switch (args[index].toLowerCase()) {
            case "overworld": 
            case "0": {
                return OptionalInt.of(0);
            }
            case "nether": 
            case "-1": {
                return OptionalInt.of(-1);
            }
            case "end": 
            case "1": {
                return OptionalInt.of(1);
            }
            case "this": 
            case "~": {
                return OptionalInt.of(sender.func_130014_f_().field_73011_w.getDimension());
            }
            case "all": 
            case "*": {
                return OptionalInt.empty();
            }
        }
        return OptionalInt.of(CommandBase.func_175755_a((String)args[index]));
    }
}

