/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.solarflux.block;

import com.zeitheron.solarflux.SolarFlux;
import com.zeitheron.solarflux.api.SolarFluxAPI;
import com.zeitheron.solarflux.api.SolarInfo;
import com.zeitheron.solarflux.api.SolarInstance;
import com.zeitheron.solarflux.block.tile.TileBaseSolar;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBaseSolar
extends Block
implements ITileEntityProvider {
    public final SolarInfo solarInfo;
    protected AxisAlignedBB aabb = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0);

    public BlockBaseSolar(SolarInfo solarInfo) {
        super(Material.field_151573_f);
        this.func_149672_a(SoundType.field_185852_e);
        this.solarInfo = solarInfo;
        ResourceLocation r = solarInfo.getRegistryName();
        this.setRegistryName(r.func_110624_b(), "solar_panel_" + r.func_110623_a());
        this.func_149663_c(this.getRegistryName().toString());
        this.func_149711_c(4.0f);
        this.setHarvestLevel("pickaxe", 2);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.aabb;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (this.isSideSolid(state, worldIn, pos, face)) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.solarInfo.maxGeneration <= 0 || this.solarInfo.maxCapacity <= 0 || this.solarInfo.maxTransfer <= 0) {
            return;
        }
        if (tab == SolarFluxAPI.tab) {
            items.add((Object)new ItemStack((Block)this));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"info.solarflux.energy.generation", (Object[])new Object[]{this.solarInfo.maxGeneration}));
        tooltip.add(I18n.func_135052_a((String)"info.solarflux.energy.transfer", (Object[])new Object[]{this.solarInfo.maxTransfer}));
        tooltip.add(I18n.func_135052_a((String)"info.solarflux.energy.capacity", (Object[])new Object[]{this.solarInfo.maxCapacity}));
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        SolarInstance i = new SolarInstance();
        i.delegate = this.solarInfo.getRegistryName();
        i.reset();
        return new TileBaseSolar(i);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K && worldIn.func_175625_s(pos) instanceof TileBaseSolar) {
            playerIn.openGui((Object)SolarFlux.instance, 0, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }
}

