/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.world.generator;

import cofh.cofhworld.util.WeightedRandomBlock;
import cofh.cofhworld.util.numbers.ConstantProvider;
import cofh.cofhworld.util.numbers.INumberProvider;
import cofh.cofhworld.util.numbers.UniformRandomProvider;
import cofh.cofhworld.world.generator.WorldGenMinableCluster;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenMinablePlate
extends WorldGenerator {
    private final List<WeightedRandomBlock> cluster;
    private final WeightedRandomBlock[] genBlock;
    private final INumberProvider radius;
    private INumberProvider height;
    private boolean slim;

    public WorldGenMinablePlate(List<WeightedRandomBlock> resource, int clusterSize, List<WeightedRandomBlock> block) {
        this(resource, new UniformRandomProvider(clusterSize, clusterSize + 2), block);
    }

    public WorldGenMinablePlate(List<WeightedRandomBlock> resource, INumberProvider clusterSize, List<WeightedRandomBlock> block) {
        this.cluster = resource;
        this.radius = clusterSize;
        this.genBlock = block.toArray(new WeightedRandomBlock[block.size()]);
        this.setHeight(1).setSlim(false);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        ++y;
        int size = this.radius.intValue(world, rand, pos);
        int dist = size * size;
        int height = this.height.intValue(world, rand, pos);
        boolean r = false;
        for (int posX = x - size; posX <= x + size; ++posX) {
            int xDist = posX - x;
            xDist *= xDist;
            for (int posZ = z - size; posZ <= z + size; ++posZ) {
                int zSize = posZ - z;
                if (zSize * zSize + xDist > dist) continue;
                int posY = y - height;
                while (this.slim ? posY < y + height : posY <= y + height) {
                    r |= WorldGenMinableCluster.generateBlock(world, rand, posX, posY, posZ, this.genBlock, this.cluster);
                    ++posY;
                }
            }
        }
        return r;
    }

    public WorldGenMinablePlate setSlim(boolean slim) {
        this.slim = slim;
        return this;
    }

    public WorldGenMinablePlate setHeight(int height) {
        this.height = new ConstantProvider(height);
        return this;
    }

    public WorldGenMinablePlate setHeight(INumberProvider height) {
        this.height = height;
        return this;
    }
}

