/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.feature.generator;

import cofh.cofhworld.biome.BiomeInfo;
import cofh.cofhworld.biome.BiomeInfoSet;
import cofh.cofhworld.feature.IConfigurableFeatureGenerator;
import cofh.cofhworld.feature.IFeatureGenerator;
import gnu.trove.set.hash.THashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public abstract class FeatureBase
implements IFeatureGenerator,
IConfigurableFeatureGenerator {
    public final String name;
    public final IConfigurableFeatureGenerator.GenRestriction biomeRestriction;
    public final IConfigurableFeatureGenerator.GenRestriction dimensionRestriction;
    public final boolean regen;
    protected boolean withVillage = true;
    protected int rarity;
    protected final BiomeInfoSet biomes = new BiomeInfoSet(1);
    protected final Set<Integer> dimensions = new THashSet();

    public FeatureBase(String name, boolean regen) {
        this(name, IConfigurableFeatureGenerator.GenRestriction.NONE, regen, IConfigurableFeatureGenerator.GenRestriction.NONE);
    }

    public FeatureBase(String name, boolean regen, IConfigurableFeatureGenerator.GenRestriction dimRes) {
        this(name, IConfigurableFeatureGenerator.GenRestriction.NONE, regen, dimRes);
    }

    public FeatureBase(String name, IConfigurableFeatureGenerator.GenRestriction biomeRes, boolean regen) {
        this(name, biomeRes, regen, IConfigurableFeatureGenerator.GenRestriction.NONE);
    }

    public FeatureBase(String name, IConfigurableFeatureGenerator.GenRestriction biomeRes, boolean regen, IConfigurableFeatureGenerator.GenRestriction dimRes) {
        this.name = name;
        this.biomeRestriction = biomeRes;
        this.dimensionRestriction = dimRes;
        this.regen = regen;
    }

    @Override
    public FeatureBase setWithVillage(boolean inVillage) {
        this.withVillage = inVillage;
        return this;
    }

    @Override
    public FeatureBase setRarity(int rarity) {
        this.rarity = rarity;
        return this;
    }

    @Override
    public FeatureBase addBiome(BiomeInfo biome) {
        this.biomes.add(biome);
        return this;
    }

    @Override
    public FeatureBase addBiomes(BiomeInfoSet biomes) {
        this.biomes.addAll(biomes);
        return this;
    }

    @Override
    public FeatureBase addDimension(int dimID) {
        this.dimensions.add(dimID);
        return this;
    }

    @Override
    public IConfigurableFeatureGenerator.GenRestriction getBiomeRestriction() {
        return this.biomeRestriction;
    }

    @Override
    public IConfigurableFeatureGenerator.GenRestriction getDimensionRestriction() {
        return this.dimensionRestriction;
    }

    @Override
    public final String getFeatureName() {
        return this.name;
    }

    @Override
    public boolean generateFeature(Random random, int chunkX, int chunkZ, World world, boolean hasVillage, boolean newGen) {
        if (!newGen && !this.regen) {
            return false;
        }
        if (hasVillage && !this.withVillage) {
            return false;
        }
        if (this.dimensionRestriction != IConfigurableFeatureGenerator.GenRestriction.NONE && this.dimensionRestriction == IConfigurableFeatureGenerator.GenRestriction.BLACKLIST == this.dimensions.contains(world.field_73011_w.getDimension())) {
            return false;
        }
        if (this.rarity > 1 && random.nextInt(this.rarity) != 0) {
            return false;
        }
        return this.generateFeature(random, chunkX * 16 + 8, chunkZ * 16 + 8, world);
    }

    @Override
    public abstract boolean generateFeature(Random var1, int var2, int var3, World var4);

    protected boolean canGenerateInBiome(World world, int x, int z, Random rand) {
        if (this.biomeRestriction != IConfigurableFeatureGenerator.GenRestriction.NONE) {
            Biome biome = world.func_180494_b(new BlockPos(x, 0, z));
            return this.biomeRestriction == IConfigurableFeatureGenerator.GenRestriction.BLACKLIST != this.biomes.contains(biome, rand);
        }
        return true;
    }
}

