/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import com.brandon3055.brandonscore.blocks.TileBCBase;
import com.brandon3055.brandonscore.lib.IActivatableTile;
import com.brandon3055.brandonscore.lib.IChangeListener;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedEnum;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.brandonscore.lib.datamanager.ManagedShort;
import com.brandon3055.brandonscore.lib.datamanager.ManagedStack;
import com.brandon3055.brandonscore.utils.InventoryUtils;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.handlers.DEEventHandler;
import com.brandon3055.draconicevolution.items.ItemCore;
import com.brandon3055.draconicevolution.items.MobSoul;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileStabilizedSpawner
extends TileBCBase
implements ITickable,
IActivatableTile,
IChangeListener {
    public ManagedEnum<SpawnerTier> spawnerTier = (ManagedEnum)this.register("spawnerTier", (IManagedData)new ManagedEnum((Enum)SpawnerTier.BASIC)).saveToTile().saveToItem().syncViaTile().finish();
    public ManagedStack mobSoul = (ManagedStack)this.register("mobSoul", (IManagedData)new ManagedStack(ItemStack.field_190927_a)).saveToTile().saveToItem().syncViaTile().finish();
    public ManagedBool isPowered = (ManagedBool)this.register("isPowered", (IManagedData)new ManagedBool(false)).saveToTile().syncViaTile().finish();
    public ManagedShort spawnDelay = (ManagedShort)this.register("spawnDelay", (IManagedData)new ManagedShort(100)).saveToTile().syncViaTile().finish();
    public ManagedInt startSpawnDelay = (ManagedInt)this.register("startSpawnDelay", (IManagedData)new ManagedInt(100)).saveToTile().syncViaTile().finish();
    private int activatingRangeFromPlayer = 24;
    private int spawnRange = 4;
    public double mobRotation;

    public void func_73660_a() {
        super.update();
        if (!this.isActive()) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            this.mobRotation += this.getRotationSpeed();
            double d3 = (float)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat();
            double d4 = (float)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextFloat();
            double d5 = (float)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat();
            this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d3, d4, d5, 0.0, 0.0, 0.0, new int[0]);
            this.field_145850_b.func_175688_a(EnumParticleTypes.FLAME, d3, d4, d5, 0.0, 0.0, 0.0, new int[0]);
        } else {
            if (this.spawnDelay.value == -1) {
                this.resetTimer();
            }
            if (this.spawnDelay.value > 0) {
                this.spawnDelay.value = (short)(this.spawnDelay.value - 1);
                return;
            }
            boolean spawnedMob = false;
            for (int i = 0; i < ((SpawnerTier)this.spawnerTier.value).getSpawnCount(); ++i) {
                boolean canSpawn;
                double spawnX = (double)this.field_174879_c.func_177958_n() + (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) * (double)this.spawnRange + 0.5;
                double spawnY = this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextInt(3) - 1;
                double spawnZ = (double)this.field_174879_c.func_177952_p() + (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) * (double)this.spawnRange + 0.5;
                Entity entity = DEFeatures.mobSoul.createEntity(this.field_145850_b, this.mobSoul.value);
                entity.func_70080_a(spawnX, spawnY, spawnZ, 0.0f, 0.0f);
                int nearby = this.field_145850_b.func_72872_a(entity.getClass(), new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1)).func_186662_g((double)this.spawnRange)).size();
                if (nearby >= ((SpawnerTier)this.spawnerTier.value).getMaxCluster()) {
                    this.resetTimer();
                    return;
                }
                EntityLiving entityliving = entity instanceof EntityLiving ? (EntityLiving)entity : null;
                entity.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, 0.0f);
                if (((SpawnerTier)this.spawnerTier.value).ignoreSpawnReq) {
                    Event.Result result = ForgeEventFactory.canEntitySpawn((EntityLiving)entityliving, (World)this.field_145850_b, (float)((float)entity.field_70165_t), (float)((float)entity.field_70163_u), (float)((float)entity.field_70161_v));
                    canSpawn = this.isNotColliding(entity) && (result == Event.Result.DEFAULT || result == Event.Result.ALLOW);
                } else {
                    canSpawn = this.canEntitySpawnSpawner(entityliving, this.field_145850_b, (float)entity.field_70165_t, (float)entity.field_70163_u, (float)entity.field_70161_v);
                }
                if (!canSpawn) continue;
                if (!((SpawnerTier)this.spawnerTier.value).requiresPlayer && entity instanceof EntityLiving) {
                    ((EntityLiving)entity).func_110163_bv();
                    entity.getEntityData().func_74772_a("DESpawnedMob", System.currentTimeMillis());
                    DEEventHandler.onMobSpawnedBySpawner((EntityLiving)entity);
                }
                AnvilChunkLoader.func_186052_a((Entity)entity, (World)this.field_145850_b);
                this.field_145850_b.func_175718_b(2004, this.field_174879_c, 0);
                if (entityliving != null) {
                    entityliving.func_70656_aK();
                    if (this.spawnerTier.value == SpawnerTier.CHAOTIC) {
                        double velocity = 2.5;
                        entity.field_70159_w = (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * velocity;
                        entity.field_70181_x = this.field_145850_b.field_73012_v.nextDouble() * velocity;
                        entity.field_70179_y = (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * velocity;
                    }
                }
                spawnedMob = true;
            }
            if (spawnedMob) {
                this.resetTimer();
            }
        }
    }

    private boolean canEntitySpawnSpawner(EntityLiving entity, World world, float x, float y, float z) {
        Event.Result result = ForgeEventFactory.canEntitySpawn((EntityLiving)entity, (World)world, (float)x, (float)y, (float)z, (boolean)true);
        if (result == Event.Result.DEFAULT) {
            boolean isSlime = entity instanceof EntitySlime;
            return (isSlime || entity.func_70601_bi()) && entity.func_70058_J();
        }
        return result == Event.Result.ALLOW;
    }

    public boolean isNotColliding(Entity entity) {
        return !this.field_145850_b.func_72953_d(entity.func_174813_aQ()) && this.field_145850_b.func_184144_a(entity, entity.func_174813_aQ()).isEmpty() && this.field_145850_b.func_72917_a(entity.func_174813_aQ(), entity);
    }

    private void resetTimer() {
        this.spawnDelay.value = (short)Math.min(((SpawnerTier)this.spawnerTier.value).getRandomSpawnDelay(this.field_145850_b.field_73012_v), Short.MAX_VALUE);
    }

    private boolean isActive() {
        if (this.isPowered.value || this.mobSoul.value.func_190926_b()) {
            return false;
        }
        return !((SpawnerTier)this.spawnerTier.value).requiresPlayer || this.field_145850_b.func_175636_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, (double)this.activatingRangeFromPlayer);
    }

    public void onNeighborChange(BlockPos changePos) {
        this.isPowered.value = this.field_145850_b.func_175640_z(this.field_174879_c);
    }

    public boolean onBlockActivated(IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == DEFeatures.mobSoul) {
            if (!this.field_145850_b.field_72995_K) {
                this.mobSoul.value = stack.func_77946_l();
                this.mobSoul.value.func_190920_e(1);
                if (!player.func_184812_l_()) {
                    InventoryUtils.consumeHeldItem((EntityPlayer)player, (ItemStack)stack, (EnumHand)hand);
                }
            }
            return true;
        }
        if (stack.func_77973_b() == Items.field_151063_bx) {
            NBTTagCompound compound = stack.func_179543_a("EntityTag");
            if (compound != null && compound.func_74764_b("id")) {
                String name = compound.func_74779_i("id");
                ItemStack soul = new ItemStack((Item)DEFeatures.mobSoul);
                DEFeatures.mobSoul.setEntity(MobSoul.getCachedRegName(name), soul);
                this.mobSoul.value = soul;
                if (!player.func_184812_l_()) {
                    InventoryUtils.consumeHeldItem((EntityPlayer)player, (ItemStack)stack, (EnumHand)hand);
                }
            }
            return true;
        }
        if (!stack.func_190926_b()) {
            SpawnerTier prevTier = (SpawnerTier)this.spawnerTier.value;
            if (stack.func_77973_b() == DEFeatures.draconicCore) {
                if (this.spawnerTier.value == SpawnerTier.BASIC) {
                    return false;
                }
                this.spawnerTier.value = SpawnerTier.BASIC;
            } else if (stack.func_77973_b() == DEFeatures.wyvernCore) {
                if (this.spawnerTier.value == SpawnerTier.WYVERN) {
                    return false;
                }
                this.spawnerTier.value = SpawnerTier.WYVERN;
            } else if (stack.func_77973_b() == DEFeatures.awakenedCore) {
                if (this.spawnerTier.value == SpawnerTier.DRACONIC) {
                    return false;
                }
                this.spawnerTier.value = SpawnerTier.DRACONIC;
            } else if (stack.func_77973_b() == DEFeatures.chaoticCore) {
                if (this.spawnerTier.value == SpawnerTier.CHAOTIC) {
                    return false;
                }
                this.spawnerTier.value = SpawnerTier.CHAOTIC;
            } else {
                return false;
            }
            ItemStack dropStack = ItemStack.field_190927_a;
            switch (prevTier) {
                case BASIC: {
                    dropStack = new ItemStack((Item)DEFeatures.draconicCore);
                    break;
                }
                case WYVERN: {
                    dropStack = new ItemStack((Item)DEFeatures.wyvernCore);
                    break;
                }
                case DRACONIC: {
                    dropStack = new ItemStack((Item)DEFeatures.awakenedCore);
                    break;
                }
                case CHAOTIC: {
                    dropStack = new ItemStack((Item)DEFeatures.chaoticCore);
                }
            }
            if (!this.field_145850_b.field_72995_K) {
                EntityItem entityItem = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5, dropStack);
                entityItem.field_70181_x = 0.2;
                this.field_145850_b.func_72838_d((Entity)entityItem);
                InventoryUtils.consumeHeldItem((EntityPlayer)player, (ItemStack)stack, (EnumHand)hand);
            }
        }
        return false;
    }

    public void writeToItemStack(NBTTagCompound tileCompound, boolean willHarvest) {
        if (willHarvest) {
            this.mobSoul.value = ItemStack.field_190927_a;
        }
        super.writeToItemStack(tileCompound, willHarvest);
    }

    public Entity getRenderEntity() {
        if (this.mobSoul.value.func_190926_b()) {
            return null;
        }
        return DEFeatures.mobSoul.getRenderEntity(this.mobSoul.value);
    }

    public double getRotationSpeed() {
        return this.isActive() ? 0.5 + (1.0 - (double)this.spawnDelay.value / (double)this.startSpawnDelay.value) * 4.5 : 0.0;
    }

    public static enum SpawnerTier {
        BASIC(4, true, false),
        WYVERN(6, false, false),
        DRACONIC(8, false, true),
        CHAOTIC(12, false, true);

        private int spawnCount;
        private boolean requiresPlayer;
        private boolean ignoreSpawnReq;

        private SpawnerTier(int spawnCount, boolean requiresPlayer, boolean ignoreSpawnReq) {
            this.spawnCount = spawnCount;
            this.requiresPlayer = requiresPlayer;
            this.ignoreSpawnReq = ignoreSpawnReq;
        }

        public int getRandomSpawnDelay(Random random) {
            int min = this.getMinDelay();
            int max = this.getMaxDelay();
            return min + random.nextInt(max - min);
        }

        public int getMinDelay() {
            return DEConfig.spawnerDelays[this.ordinal() * 2];
        }

        public int getMaxDelay() {
            return DEConfig.spawnerDelays[this.ordinal() * 2 + 1];
        }

        public int getSpawnCount() {
            return this.spawnCount;
        }

        public int getMaxCluster() {
            return (int)((double)this.spawnCount * 2.5);
        }

        public static SpawnerTier getTierFromCore(ItemCore core) {
            return core == DEFeatures.chaoticCore ? CHAOTIC : (core == DEFeatures.wyvernCore ? WYVERN : (core == DEFeatures.awakenedCore ? DRACONIC : BASIC));
        }
    }
}

