/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks;

import codechicken.lib.model.ModelRegistryHelper;
import com.brandon3055.brandonscore.blocks.BlockBCore;
import com.brandon3055.brandonscore.registry.Feature;
import com.brandon3055.brandonscore.registry.IRenderOverride;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.blocks.tileentity.TileDraconiumChest;
import com.brandon3055.draconicevolution.client.render.item.RenderItemDraconiumChest;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileDraconiumChest;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DraconiumChest
extends BlockBCore
implements ITileEntityProvider,
IRenderOverride {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);

    public boolean uberIsBlockFullCube() {
        return false;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileDraconiumChest();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            playerIn.openGui((Object)DraconicEvolution.instance, 11, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public static boolean isStackValid(ItemStack stack) {
        String name;
        if (stack.func_77973_b() == Item.func_150898_a((Block)DEFeatures.draconiumChest)) {
            return false;
        }
        return stack.func_190926_b() || !(name = stack.func_77977_a().toLowerCase()).contains("pouch") && !name.contains("bag") && !name.contains("strongbox") && !name.contains("shulker_box");
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3)).func_176734_d();
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileDraconiumChest) {
            ((TileDraconiumChest)tile).facing.value = enumfacing;
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileDraconiumChest) {
            ((TileDraconiumChest)tile).facing.value = ((EnumFacing)((TileDraconiumChest)tile).facing.value).func_176746_e();
            ((TileDraconiumChest)tile).ioCacheValid = false;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerRenderer(Feature feature) {
        ClientRegistry.bindTileEntitySpecialRenderer(TileDraconiumChest.class, (TileEntitySpecialRenderer)new RenderTileDraconiumChest());
        ModelResourceLocation modelLocation = new ModelResourceLocation(DraconicEvolution.MOD_PREFIX + feature.getName() + "#normal");
        ModelLoader.registerItemVariants((Item)Item.func_150898_a((Block)this), (ResourceLocation[])new ResourceLocation[]{modelLocation});
        RenderItemDraconiumChest bakedModel = new RenderItemDraconiumChest();
        ModelRegistryHelper.register((ModelResourceLocation)modelLocation, (IBakedModel)bakedModel);
        ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)this), stack -> modelLocation);
    }

    public boolean registerNormal(Feature feature) {
        return false;
    }

    public boolean overrideShareTag() {
        return true;
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("ChestColour", ItemNBTHelper.getInteger((ItemStack)stack, (String)"ChestColour", (int)6553750));
        return compound;
    }
}

