/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution;

import com.brandon3055.brandonscore.handlers.FileHandler;
import com.brandon3055.brandonscore.registry.IModConfigHelper;
import com.brandon3055.brandonscore.registry.ModConfigContainer;
import com.brandon3055.brandonscore.registry.ModConfigProperty;
import com.brandon3055.draconicevolution.DEFeatures;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@ModConfigContainer(modid="draconicevolution")
public class DEConfig
implements IModConfigHelper {
    public static Map<String, String> comments = new HashMap<String, String>();
    @ModConfigProperty(category="World", name="worldGenEnabled", comment="Setting this to false will just completely disable ALL DE world gen!")
    public static boolean worldGenEnabled;
    @ModConfigProperty(category="World", name="enableRetroGen", comment="Set this to false if you do not want ore added to chunks that have not previously been generated by DE (this can almost always be left true)")
    public static boolean enableRetroGen;
    @ModConfigProperty(category="World", name="disableOreSpawnOverworld", comment="Disables draconium ore generation in the overworld")
    public static boolean disableOreSpawnOverworld;
    @ModConfigProperty(category="World", name="disableOreSpawnEnd", comment="Disables draconium ore generation in the end")
    public static boolean disableOreSpawnEnd;
    @ModConfigProperty(category="World", name="disableOreSpawnNether", comment="Disables draconium ore generation in the nether")
    public static boolean disableOreSpawnNether;
    @ModConfigProperty(category="World", name="generateEnderComets", comment="Set to false to disable the generation of Ender Comets")
    public static boolean generateEnderComets;
    @ModConfigProperty(category="World", name="generateChaosIslands", comment="Set to false to disable the generation of Chaos Islands")
    public static boolean generateChaosIslands;
    @ModConfigProperty(category="World", name="cometRarity", comment="Ender Comets have a 1 in {this number} chance to spawn in each chunk")
    public static int cometRarity;
    @ModConfigProperty(category="World", name="chaosIslandSeparation", comment="This is the distance between chaos islands")
    @ModConfigProperty.MinMax(min="500", max="1000000")
    public static int chaosIslandSeparation;
    @ModConfigProperty(category="World", name="oreGenDimentionBlacklist", comment="Add the dimension id of any mod dimension's you dont want draconium ore generated in")
    public static int[] oreGenDimentionBlacklist;
    @ModConfigProperty(category="Tweaks", name="disableGuardianCrystalRespawn", comment="(Wuss mode) Setting this to true will disable the chaos guardians ability to respawn healing crystals.")
    public static boolean disableGuardianCrystalRespawn;
    @ModConfigProperty(category="Tweaks", name="enableFlight", comment="Set this to false if you would like to disable the draconic armors flight.", autoSync=true)
    public static boolean enableFlight;
    @ModConfigProperty(category="Tweaks", name="dislocatorUsesPerPearl", comment="Sets the number of teleports you get per ender pearl with the Advanced Dislocator")
    public static int dislocatorUsesPerPearl;
    @ModConfigProperty(category="Tweaks", name="hardMode", comment="When true everything is just a little harder. (Currently only effects recipes but that will probably change in the future)", requiresMCRestart=true, requiresSync=true)
    public static boolean hardMode;
    @ModConfigProperty(category="Tweaks", name="bowBlockDamage", comment="Set to false to prevent the bows explosion effect breaking blocks")
    public static boolean bowBlockDamage;
    @ModConfigProperty(category="Tweaks", name="grinderEnergyPerHeart", comment="Sets the energy per use per heart of damage for the grinder.")
    public static int grinderEnergyPerHeart;
    @ModConfigProperty(category="Tweaks", name="dragonEggSpawnOverride", comment="By default the dragon egg only ever spawns once. This forces it to spawn every time the dragon is killed.")
    public static boolean dragonEggSpawnOverride;
    @ModConfigProperty(category="Tweaks", name="expensiveDragonRitual", comment="Lets face it. The biggest issue with the new dragon ritual is it is too darn cheap! This modifies the recipe to make it a bit more expensive.")
    public static boolean expensiveDragonRitual;
    @ModConfigProperty(category="Tweaks", name="itemDislocatorBlacklist", comment="A list of items of items that should be ignored by the item dislocator. Use the items registry name e.g. minecraft:apple you can also add a meta value like so minecraft:wool|4", autoSync=true)
    public static String[] itemDislocatorBlacklist;
    @ModConfigProperty(category="Tweaks", name="reactorOutputMultiplier", comment="Adjusts the energy output multiplier of the reactor")
    public static double reactorOutputMultiplier;
    @ModConfigProperty(category="Tweaks", name="reactorFuelUsageMultiplier", comment="Adjusts the fuel usage multiplier of the reactor")
    public static double reactorFuelUsageMultiplier;
    @ModConfigProperty(category="Tweaks", name="dragonDustLootModifier", comment="This can be used to adjust the amount of draconium dust the dragon drops when killed.\nThe amount dropped will be this number +/- 10%")
    public static int dragonDustLootModifier;
    @ModConfigProperty(category="Tweaks", name="disableLargeReactorBoom", comment="If true will disable the massive reactor explosion and replace it with a much smaller one.")
    public static boolean disableLargeReactorBoom;
    @ModConfigProperty(category="Tweaks", name="disableChaosIslandExplosion", comment="If true will disable the destruction of chaos islands after the chaos crystal is broken.")
    public static boolean disableChaosIslandExplosion;
    @ModConfigProperty(category="Tweaks", name="disableLootCores", comment="This will disable loot cores (The \"Blobs\" of items dropped by the tools.).")
    public static boolean disableLootCores;
    @ModConfigProperty(category="Tweaks", name="reactorExplosionScale", comment="Allows you to adjust the overall scale of the reactor explosion. use \"disableLargeReactorBoom\" to diaable explosion completely.")
    public static double reactorExplosionScale;
    @ModConfigProperty(category="Tweaks", name="soulDropChance", comment="Mobs have a 1 in this number chance to drop a soul")
    public static int soulDropChance;
    @ModConfigProperty(category="Tweaks", name="passiveSoulDropChance", comment="Passive (Animals) Mobs have a 1 in this number chance to drop a soul")
    public static int passiveSoulDropChance;
    @ModConfigProperty(category="Tweaks", name="spawnerList", comment="By default any entities added to this list will not drop their souls and will not be spawnable by the stabilized spawner.", autoSync=true)
    public static String[] spawnerList;
    @ModConfigProperty(category="Tweaks", name="spawnerListWhiteList", comment="Changes the spawner list to a whitelist as opposed to the default blacklist.", autoSync=true)
    public static boolean spawnerListWhiteList;
    @ModConfigProperty(category="Tweaks", name="allowBossSouls", comment="Enabling this allows boss souls to drop. Use with caution!")
    public static boolean allowBossSouls;
    @ModConfigProperty(category="Tweaks", name="spawnerDelays", comment="Sets the min and max spawn delay in ticks for each spawner tier. Order is as follows.\nBasic MIN, MAX, Wyvern MIN, MAX, Draconic MIN, MAX, Chaotic MIN MAX")
    public static int[] spawnerDelays;
    @ModConfigProperty(category="Tweaks", name="oreDoublingBlacklist", comment="Add ore names (e.g. oreIron) to this list to prevent them from being doubled by the DE chest", autoSync=true)
    public static String[] oreDoublingBlacklist;
    @ModConfigProperty(category="Tweaks", name="dissenchnaterCostMultiplier", comment="Allows you to adjust the cost of dissenchanting items via the dissenchanter", autoSync=true)
    public static double disenchnaterCostMultiplyer;
    @ModConfigProperty(category="Tweaks", name="forceDroppedItemOwner", comment="For some reason forge decided not to set the owner of an item when dropped from an inventory screen.\nDE overrides this and sets the stack owner when possible.\nIf this causes issues set this value to false.", autoSync=true)
    public static boolean forceDroppedItemOwner;
    @ModConfigProperty(category="Tweaks", name="clearDataRecipes", comment="Adds recipes to clear all nbt data from items such as energy crystals and crafting injectors.", requiresMCRestart=true, requiresSync=true)
    public static boolean clearDataRecipes;
    @ModConfigProperty(category="Tweaks", name="chaosGuardianHealth", comment="Allows you to tweak the chaos guardians health (will only affect new guardians)")
    public static int chaosGuardianHealth;
    @ModConfigProperty(category="Tweaks", name="flightSpeedLimit", autoSync=true, comment="Use this to limit the max flight speed modifier a player can set on the draconic chestplate.\nSetting this to 200 for example would limit the flight speed to +200%.\nDefault -1 removes the limit and allows the full +600% flight speed.")
    public static int flightSpeedLimit;
    @ModConfigProperty(category="Client Settings", name="hudSettings", comment="This is where the settings for the in game hud are stored. You should not need to adjust these unless something breaks.")
    public static int[] hudSettings;
    @ModConfigProperty(category="Client Settings", name="disable3DModels", comment="Disables the 3D tool and armor models. This is required if you want to use a 2D resource pack.)")
    public static boolean disable3DModels;
    @ModConfigProperty(category="Client Settings", name="invertDPDSB", comment="Invert Dislocator Pedestal display name shift behavior.")
    public static boolean invertDPDSB;
    @ModConfigProperty(category="Client Settings", name="useShaders", comment="Set this to false if your system can not handle the awesomeness that is shaders! (Warning will make cool things look like crap)")
    public static boolean useShaders;
    @ModConfigProperty(category="Client Settings", name="useCrystalShaders", comment="This allowes you to just disable the energy crystal shader which can be a lot lagier than the reactor since there are usually a lot more of them (The fallback crystal texture is not soooo bad...)")
    public static boolean useCrystalShaders;
    @ModConfigProperty(category="Client Settings", name="useReactorBeamShaders", comment="Set this to false if you prefer the original look of the reactor beams")
    public static boolean useReactorBeamShaders;
    @ModConfigProperty(category="Client Settings", name="disableLoudCelestialManipulator", comment="If true the range of the celestial manipulator sound effect will be significantly reduced.")
    public static boolean disableLoudCelestialManipulator;
    @ModConfigProperty(category="Client Settings", name="disableDislocatorSound", comment="If true the item dislocator will not make the pickup sound when it collects items..")
    public static boolean disableDislocatorSound;
    @ModConfigProperty(category="Client Settings", name="disableShieldHitEffect", comment="If true the armor shield will not render when you taker damage (this is only a visual change).")
    public static boolean disableShieldHitEffect;
    @ModConfigProperty(category="Client Settings", name="disableShieldHitSound", comment="If true the armor shield hit sound will be disabled.")
    public static boolean disableShieldHitSound;
    @ModConfigProperty(category="Misc", name="devLog", comment="This enables dev log output. I primarily use this for development purposes so it wont be very useful to regular users.")
    public static boolean devLog;
    @ModConfigProperty(category="Misc", name="chaosGuardianLoading", comment="Set this to false to disable chaos guardian chunkloading.\nNote. The chaos guardian is ONLY loaded when a player is within a couple hundred blocks.\nThis is to avoid issues where the guardian would fly out of the loaded chunks and freeze\nwhich is especial an issue on servers with reduced render distance.")
    public static boolean chaosGuardianLoading;
    public static Map<String, Integer> itemDislocatorBlacklistMap;
    public static Set<String> oreBlacklist;

    public Configuration createConfiguration(FMLPreInitializationEvent event) {
        return new Configuration(new File(FileHandler.brandon3055Folder, "DraconicEvolution.cfg"), true);
    }

    public String getCategoryComment(String category) {
        return comments.getOrDefault(category, "");
    }

    public void onConfigChanged(String propertyName, String propertyCategory) {
        this.loadToolStats();
    }

    public void onConfigLoaded() {
        itemDislocatorBlacklistMap.clear();
        for (String s : itemDislocatorBlacklist) {
            if (s.contains("|")) {
                itemDislocatorBlacklistMap.put(s.substring(0, s.indexOf("|")), Integer.parseInt(s.substring(s.indexOf("|") + 1)));
                continue;
            }
            itemDislocatorBlacklistMap.put(s, -1);
        }
        oreBlacklist = Sets.newHashSet((Object[])oreDoublingBlacklist);
        this.loadToolStats();
    }

    private void loadToolStats() {
        DEFeatures.draconicAxe.loadStatConfig();
        DEFeatures.draconicBow.loadStatConfig();
        DEFeatures.draconicHoe.loadStatConfig();
        DEFeatures.draconicPick.loadStatConfig();
        DEFeatures.draconicShovel.loadStatConfig();
        DEFeatures.draconicStaffOfPower.loadStatConfig();
        DEFeatures.draconicSword.loadStatConfig();
        DEFeatures.wyvernAxe.loadStatConfig();
        DEFeatures.wyvernBow.loadStatConfig();
        DEFeatures.wyvernPick.loadStatConfig();
        DEFeatures.wyvernShovel.loadStatConfig();
        DEFeatures.wyvernSword.loadStatConfig();
    }

    static {
        comments.put("items", "Allows you to disable any item in the mod. Note that disabling an item will automatically\ndisable its recipe and all recipes that use it. (Requires game restart)\nTo disable an item set its value to false");
        comments.put("blocks", "Allows you to disable any block in the mod. Note that disabling an block will automatically\ndisable its recipe and all recipes that use it. (Requires game restart)\nTo disable a block set its value to false");
        comments.put("World", "This category contains config properties related to world gen.");
        comments.put("Tweaks", "Just what the name says. Tweaks. Allows you to tweak stuff.");
        comments.put("Client Settings", "These are client side properties that have no effect server side.");
        comments.put("Stat Tweaks", "These allow you to tweak the stats of the tools, weapons and armor.");
        comments.put("Misc", "Just some misc settings.");
        worldGenEnabled = true;
        enableRetroGen = true;
        disableOreSpawnOverworld = false;
        disableOreSpawnEnd = false;
        disableOreSpawnNether = false;
        generateEnderComets = true;
        generateChaosIslands = true;
        cometRarity = 10000;
        chaosIslandSeparation = 10000;
        oreGenDimentionBlacklist = new int[0];
        disableGuardianCrystalRespawn = false;
        enableFlight = true;
        dislocatorUsesPerPearl = 1;
        hardMode = false;
        bowBlockDamage = true;
        grinderEnergyPerHeart = 80;
        dragonEggSpawnOverride = true;
        expensiveDragonRitual = true;
        itemDislocatorBlacklist = new String[]{"appliedenergistics2:crystal_seed"};
        reactorOutputMultiplier = 1.0;
        reactorFuelUsageMultiplier = 1.0;
        dragonDustLootModifier = 1;
        disableLargeReactorBoom = false;
        disableChaosIslandExplosion = false;
        disableLootCores = false;
        reactorExplosionScale = 1.0;
        soulDropChance = 1000;
        passiveSoulDropChance = 800;
        spawnerList = new String[0];
        spawnerListWhiteList = false;
        allowBossSouls = false;
        spawnerDelays = new int[]{200, 800, 100, 400, 50, 200, 25, 100};
        oreDoublingBlacklist = new String[0];
        disenchnaterCostMultiplyer = 1.0;
        forceDroppedItemOwner = true;
        clearDataRecipes = false;
        chaosGuardianHealth = 2000;
        flightSpeedLimit = -1;
        hudSettings = new int[]{996, 825, 69, 907, 90, 100, 3, 0, 1, 1, 1, 1};
        disable3DModels = false;
        invertDPDSB = false;
        useShaders = true;
        useCrystalShaders = true;
        useReactorBeamShaders = true;
        disableLoudCelestialManipulator = false;
        disableDislocatorSound = false;
        disableShieldHitEffect = false;
        disableShieldHitSound = false;
        devLog = false;
        chaosGuardianLoading = true;
        itemDislocatorBlacklistMap = new HashMap<String, Integer>();
        oreBlacklist = new HashSet<String>();
    }
}

