/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.agriculture;

import com.buuz135.industrial.api.plant.PlantRecollectable;
import com.buuz135.industrial.item.addon.LeafShearingAddonItem;
import com.buuz135.industrial.proxy.FluidsRegistry;
import com.buuz135.industrial.proxy.client.ClientProxy;
import com.buuz135.industrial.registry.IFRegistries;
import com.buuz135.industrial.tile.CustomColoredItemHandler;
import com.buuz135.industrial.tile.WorkingAreaElectricMachine;
import com.buuz135.industrial.tile.block.CropRecolectorBlock;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.ItemStackUtils;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.gui.ToggleButtonPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.netsync.SimpleNBTMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CropRecolectorTile
extends WorkingAreaElectricMachine {
    private static String NBT_POINTER = "pointer";
    private static String NBT_OPERATION = "operation";
    private static String NBT_TYPE = "type";
    private IFluidTank sludge;
    private ItemStackHandler outItems;
    private int pointer;
    private int operationAmount;
    private PlantRecollectable.Type type = PlantRecollectable.Type.ANY;

    public CropRecolectorTile() {
        super(CropRecolectorTile.class.getName().hashCode());
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.sludge = this.addFluidTank(FluidsRegistry.SLUDGE, 8000, EnumDyeColor.BLACK, "Sludge tank", new BoundingRectangle(50, 25, 18, 54));
        this.outItems = new ItemStackHandler(12){

            protected void onContentsChanged(int slot) {
                CropRecolectorTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.outItems, EnumDyeColor.ORANGE, "Crops output", 93, 25, 4, 3){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return false;
            }

            public boolean canExtractItem(int slot) {
                return true;
            }
        });
        this.addInventoryToStorage(this.outItems, "outItems");
    }

    @Override
    public float work() {
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return 0.0f;
        }
        if (ItemStackUtils.isInventoryFull(this.outItems)) {
            return 0.0f;
        }
        List<BlockPos> blockPos = BlockUtils.getBlockPosInAABB(this.getWorkingArea());
        boolean shouldPointerIncrease = true;
        boolean didWork = false;
        if (this.pointer < blockPos.size() && BlockUtils.canBlockBeBroken(this.field_145850_b, blockPos.get(this.pointer))) {
            BlockPos pos = blockPos.get(this.pointer);
            IBlockState state = this.field_145850_b.func_180495_p(blockPos.get(this.pointer));
            Optional<PlantRecollectable> recollectable = IFRegistries.PLANT_RECOLLECTABLES_REGISTRY.getValuesCollection().stream().sorted(Comparator.comparingInt(PlantRecollectable::getPriority)).filter(iPlantRecollectable -> iPlantRecollectable.canBeHarvested(this.field_145850_b, pos, state) && (this.type == PlantRecollectable.Type.ANY || this.type == iPlantRecollectable.getRecollectableType())).findFirst();
            if (recollectable.isPresent()) {
                PlantRecollectable plantRecollectable = recollectable.get();
                ++this.operationAmount;
                List<ItemStack> items = plantRecollectable.doHarvestOperation(this.field_145850_b, pos, state, this.hasShearingAddon(), this.operationAmount);
                if (items != null) {
                    this.insertItems(items, this.outItems);
                }
                if (!plantRecollectable.shouldCheckNextPlant(this.field_145850_b, pos, state)) {
                    shouldPointerIncrease = false;
                }
            }
            didWork = recollectable.isPresent();
        }
        if (shouldPointerIncrease) {
            ++this.pointer;
            this.operationAmount = 0;
        }
        if (this.pointer >= blockPos.size()) {
            this.pointer = 0;
        }
        return didWork ? 1.0f : 0.1f;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound tagCompound = super.func_189515_b(compound);
        tagCompound.func_74768_a(NBT_POINTER, this.pointer);
        tagCompound.func_74768_a(NBT_OPERATION, this.operationAmount);
        tagCompound.func_74778_a(NBT_TYPE, this.type.name());
        return tagCompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.pointer = compound.func_74762_e(NBT_POINTER);
        this.operationAmount = compound.func_74762_e(NBT_OPERATION);
        this.type = PlantRecollectable.Type.ANY;
        if (compound.func_74764_b(NBT_TYPE)) {
            this.type = PlantRecollectable.Type.valueOf(compound.func_74779_i(NBT_TYPE));
        }
    }

    private void insertItems(List<ItemStack> drops, ItemStackHandler outItems) {
        for (ItemStack stack : drops) {
            ItemHandlerHelper.insertItem((IItemHandler)outItems, (ItemStack)stack, (boolean)false);
        }
        this.sludge.fill(new FluidStack((Fluid)FluidsRegistry.SLUDGE, ((CropRecolectorBlock)this.func_145838_q()).getSludgeOperation() * drops.size()), true);
    }

    protected boolean acceptsFluidItem(ItemStack stack) {
        return ItemStackUtils.acceptsFluidItem(stack);
    }

    protected void processFluidItems(ItemStackHandler fluidItems) {
        ItemStackUtils.fillItemFromTank(fluidItems, this.sludge);
    }

    public boolean hasShearingAddon() {
        return this.hasAddon(LeafShearingAddonItem.class);
    }

    @Override
    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
        List<IGuiContainerPiece> pieces = super.getGuiContainerPieces(container);
        pieces.add((IGuiContainerPiece)new ToggleButtonPiece(118, 84, 13, 13, 0){

            protected int getCurrentState() {
                return CropRecolectorTile.this.type.ordinal();
            }

            protected void renderState(BasicTeslaGuiContainer container, int state, BoundingRectangle box) {
            }

            public void drawBackgroundLayer(BasicTeslaGuiContainer container, int guiX, int guiY, float partialTicks, int mouseX, int mouseY) {
                super.drawBackgroundLayer(container, guiX, guiY, partialTicks, mouseX, mouseY);
                container.field_146297_k.func_110434_K().func_110577_a(ClientProxy.GUI);
                container.drawTexturedRect(this.getLeft() - 1, this.getTop() - 1, 49, 56, 16, 16);
                if (CropRecolectorTile.this.type == PlantRecollectable.Type.TREE) {
                    ItemStackUtils.renderItemIntoGUI(new ItemStack(Blocks.field_150345_g, 1, 4), this.getLeft() + guiX - 2, this.getTop() + guiY - 3, 9);
                } else if (CropRecolectorTile.this.type == PlantRecollectable.Type.PLANT) {
                    ItemStackUtils.renderItemIntoGUI(new ItemStack(Items.field_151075_bm), this.getLeft() + guiX - 2, this.getTop() + guiY - 2, 9);
                } else {
                    ItemStackUtils.renderItemIntoGUI(new ItemStack(Items.field_151075_bm), this.getLeft() + guiX, this.getTop() + guiY - 3, 9);
                    ItemStackUtils.renderItemIntoGUI(new ItemStack(Blocks.field_150345_g, 1, 1), this.getLeft() + guiX - 2, this.getTop() + guiY - 4, 8);
                }
            }

            protected void clicked() {
                CropRecolectorTile.this.sendToServer(CropRecolectorTile.this.setupSpecialNBTMessage("NEXT_PLANT_TYPE"));
            }

            @NotNull
            protected List<String> getStateToolTip(int state) {
                return Arrays.asList(new TextComponentTranslation("text.industrialforegoing.button.gather." + CropRecolectorTile.this.type.name().toLowerCase(), new Object[0]).func_150254_d());
            }
        });
        return pieces;
    }

    @Nullable
    protected SimpleNBTMessage processClientMessage(@Nullable String messageType, @NotNull NBTTagCompound compound) {
        if (messageType != null && messageType.equalsIgnoreCase("NEXT_PLANT_TYPE")) {
            this.type = PlantRecollectable.Type.values()[(this.type.ordinal() + 1) % PlantRecollectable.Type.values().length];
            this.func_70296_d();
            this.forceSync();
        }
        return super.processClientMessage(messageType, compound);
    }
}

