/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.compat;

import java.io.File;
import java.io.IOException;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.xalcon.torchmaster.TorchMasterMod;
import net.xalcon.torchmaster.common.ModCaps;
import net.xalcon.torchmaster.common.logic.ITorchRegistryContainer;

public class RegistryBackwardsCompat {
    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld() == null) {
            TorchMasterMod.Log.warn("Torchmaster retrieved the WorldEvent.Load but the world object is null! Queueing reload");
            FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(this::reloadRegistry);
        }
        if (event.getWorld().field_73011_w.getDimension() != 0) {
            return;
        }
        this.reloadRegistry();
    }

    private void reloadRegistry() {
        this.loadMegaTorchRegistry();
        this.loadDreadLampRegistry();
    }

    private void loadMegaTorchRegistry() {
        NBTTagCompound nbt;
        File file = new File(DimensionManager.getCurrentSaveRootDirectory(), "data/torchmaster_mega_torch_reg.dat");
        if (!file.exists()) {
            return;
        }
        try {
            nbt = CompressedStreamTools.func_74797_a((File)file);
            if (nbt == null) {
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        NBTTagList list = nbt.func_150295_c("list", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound entry = list.func_150305_b(i);
            TorchLocation loc = new TorchLocation(entry);
            WorldServer world = DimensionManager.getWorld((int)loc.DimensionId);
            if (world == null) {
                TorchMasterMod.Log.warn("Unable to restore torch @ " + loc + ", the world " + loc.DimensionId + " was not found");
                continue;
            }
            ITorchRegistryContainer container = (ITorchRegistryContainer)world.getCapability(ModCaps.TORCH_REGISTRY_CONTAINER, null);
            if (container == null) continue;
            container.getMegaTorchRegistry().register(loc.Position);
        }
        file.delete();
    }

    private void loadDreadLampRegistry() {
        NBTTagCompound nbt;
        File file = new File(DimensionManager.getCurrentSaveRootDirectory(), "data/torchmaster_dread_lamp_reg.dat");
        if (!file.exists()) {
            return;
        }
        try {
            nbt = CompressedStreamTools.func_74797_a((File)file);
            if (nbt == null) {
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        NBTTagList list = nbt.func_150295_c("list", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound entry = list.func_150305_b(i);
            TorchLocation loc = new TorchLocation(entry);
            WorldServer world = DimensionManager.getWorld((int)loc.DimensionId);
            if (world == null) {
                TorchMasterMod.Log.warn("Unable to restore torch @ " + loc + ", the world " + loc.DimensionId + " was not found");
                continue;
            }
            ITorchRegistryContainer container = (ITorchRegistryContainer)world.getCapability(ModCaps.TORCH_REGISTRY_CONTAINER, null);
            if (container == null) continue;
            container.getDreadLampRegistry().register(loc.Position);
        }
        file.delete();
    }

    private static class TorchLocation {
        public int DimensionId;
        public BlockPos Position;

        public TorchLocation(int dimensionId, BlockPos position) {
            this.DimensionId = dimensionId;
            this.Position = position;
        }

        public TorchLocation(NBTTagCompound entry) {
            this.DimensionId = entry.func_74762_e("d");
            this.Position = new BlockPos(entry.func_74762_e("x"), entry.func_74762_e("y"), entry.func_74762_e("z"));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TorchLocation that = (TorchLocation)o;
            if (this.DimensionId != that.DimensionId) {
                return false;
            }
            return this.Position != null ? this.Position.equals((Object)that.Position) : that.Position == null;
        }

        public int hashCode() {
            int result = this.DimensionId;
            result = 31 * result + (this.Position != null ? this.Position.hashCode() : 0);
            return result;
        }

        public NBTTagCompound toNbt() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("d", this.DimensionId);
            nbt.func_74768_a("x", this.Position.func_177958_n());
            nbt.func_74768_a("y", this.Position.func_177956_o());
            nbt.func_74768_a("z", this.Position.func_177952_p());
            return nbt;
        }

        public String toString() {
            return String.format("DIM: %d - %s", this.DimensionId, this.Position);
        }
    }
}

