/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.common;

import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.xalcon.torchmaster.common.ModCaps;
import net.xalcon.torchmaster.common.TorchmasterConfig;
import net.xalcon.torchmaster.common.logic.CapabilityProviderTorchRegistryContainer;
import net.xalcon.torchmaster.common.logic.ITorchRegistryContainer;

public class EventHandlerServer {
    @SubscribeEvent
    public void onEntityCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getResult() == Event.Result.ALLOW) {
            return;
        }
        if (TorchmasterConfig.MegaTorchAllowVanillaSpawners && event.isSpawner()) {
            return;
        }
        Entity entity = event.getEntity();
        World world = entity.func_130014_f_();
        ITorchRegistryContainer container = (ITorchRegistryContainer)world.getCapability(ModCaps.TORCH_REGISTRY_CONTAINER, null);
        if (container != null && container.shouldEntityBeBlocked(entity)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onWorldAttachCapabilityEvent(AttachCapabilitiesEvent<World> event) {
        event.addCapability(new ResourceLocation("torchmaster", "registry"), (ICapabilityProvider)new CapabilityProviderTorchRegistryContainer());
    }

    @SubscribeEvent
    public void onGlobalTick(TickEvent.ServerTickEvent event) {
        if (event.side == Side.CLIENT) {
            return;
        }
        Integer[] integerArray = DimensionManager.getIDs();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int dimId = integerArray[i];
            WorldServer world = DimensionManager.getWorld((int)dimId);
            if (world == null) {
                return;
            }
            ITorchRegistryContainer container = (ITorchRegistryContainer)world.getCapability(ModCaps.TORCH_REGISTRY_CONTAINER, null);
            if (container == null) continue;
            container.onGlobalTick((World)world);
        }
    }
}

