/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.splashanimation.core.repackage.com.elytradev.mini;

import java.lang.reflect.Method;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import pl.asie.splashanimation.core.repackage.com.elytradev.mini.PatchContext;
import pl.asie.splashanimation.core.repackage.com.elytradev.mini.annotation.Patch;

public abstract class MiniTransformer
implements IClassTransformer,
Opcodes {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        boolean matched = false;
        for (Patch.Class a : (Patch.Class[])this.getClass().getAnnotationsByType(Patch.Class.class)) {
            if (!a.value().equals(transformedName)) continue;
            matched = true;
            break;
        }
        if (!matched) {
            return basicClass;
        }
        ClassReader reader = new ClassReader(basicClass);
        ClassNode clazz = new ClassNode();
        reader.accept((ClassVisitor)clazz, 0);
        Method[] methods = this.getClass().getDeclaredMethods();
        for (MethodNode mn : clazz.methods) {
            for (Method m : methods) {
                for (Patch.Method a : (Patch.Method[])m.getAnnotationsByType(Patch.Method.class)) {
                    if (!a.srg().equals(mn.name) && !a.mcp().equals(mn.name) || !a.descriptor().equals(mn.desc)) continue;
                    PatchContext ctx = new PatchContext(mn);
                    try {
                        m.invoke((Object)this, ctx);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to invoke transformer method for " + a.mcp() + a.descriptor() + " (SRG name " + a.srg() + ")", e);
                    }
                    ctx.finish();
                    LogManager.getLogger((String)"Mini").info("[{}] Successfully transformed {}.{}{}", (Object)this.getClass().getName(), (Object)transformedName, (Object)mn.name, (Object)mn.desc);
                }
            }
        }
        ClassWriter writer = new ClassWriter(1);
        clazz.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

