/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.machine;

import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicContainerTile;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.gui.backend.WidgetSlotGhost;
import com.rwtema.extrautils2.gui.backend.WidgetSlotItemHandler;
import com.rwtema.extrautils2.gui.backend.WidgetTextTranslate;
import com.rwtema.extrautils2.itemhandler.ConcatItemHandler;
import com.rwtema.extrautils2.itemhandler.InventoryHelper;
import com.rwtema.extrautils2.itemhandler.PublicWrapper;
import com.rwtema.extrautils2.itemhandler.XUTileItemStackHandler;
import com.rwtema.extrautils2.tile.RedstoneState;
import com.rwtema.extrautils2.tile.TileAdvInteractor;
import com.rwtema.extrautils2.utils.ItemStackNonNull;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileGrouper
extends TileAdvInteractor
implements IDynamicHandler,
ITickable {
    private static final int SLOT_COUNT = 9;
    private XUTileItemStackHandler ghostSlots = this.registerNBT("ghost_stacks", new XUTileItemStackHandler(9, this));
    private XUTileItemStackHandler inputs = this.registerNBT("inputs", new XUTileItemStackHandler(9, this){

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            ItemStack ghostStack = TileGrouper.this.ghostSlots.getStackInSlot(slot);
            if (StackHelper.isEmpty(ghostStack) || !ItemHandlerHelper.canItemStacksStackRelaxed((ItemStack)stack, (ItemStack)ghostStack)) {
                return 0;
            }
            return super.getStackLimit(slot, stack);
        }
    });
    private XUTileItemStackHandler outputs = this.registerNBT("outputs", new XUTileItemStackHandler(9, this));
    private NBTSerializable.NBTEnum<State> state = this.registerNBT("state", new NBTSerializable.NBTEnum<State>(State.INSERTION));
    private IItemHandler handler = new ConcatItemHandler(new PublicWrapper.Insert((IItemHandlerModifiable)this.inputs), new PublicWrapper.Extract((IItemHandlerModifiable)this.outputs){

        @Override
        @ItemStackNonNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (((TileGrouper)TileGrouper.this).state.value != State.EXTRACTION) {
                return StackHelper.empty();
            }
            ItemStack stack = this.handler.extractItem(slot, amount, simulate);
            if (!simulate) {
                for (int i = 0; i < TileGrouper.this.outputs.getSlots(); ++i) {
                    if (StackHelper.isEmpty(TileGrouper.this.outputs.getStackInSlot(i))) continue;
                    return stack;
                }
                TileGrouper.this.cooldown.value = 20;
                ((TileGrouper)TileGrouper.this).state.value = State.INSERTION;
            }
            return stack;
        }
    });

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerGrouper(this, player);
    }

    @Override
    protected Iterable<ItemStack> getDropHandler() {
        return InventoryHelper.getItemHandlerIterator(new IItemHandler[]{this.inputs, this.outputs});
    }

    @Override
    public IItemHandler getItemHandler(EnumFacing facing) {
        return this.handler;
    }

    @Override
    protected void operate() {
        if (this.state.value == State.INSERTION) {
            int i;
            boolean flag = false;
            for (i = 0; i < 9; ++i) {
                ItemStack ghostStack = this.ghostSlots.getStackInSlot(i);
                int stacksize = StackHelper.getStacksize(ghostStack);
                boolean bl = flag = flag || stacksize > 0;
                if (stacksize <= 0 || StackHelper.getStacksize(this.inputs.getStackInSlot(i)) >= stacksize && ItemHandlerHelper.canItemStacksStackRelaxed((ItemStack)this.inputs.getStackInSlot(i), (ItemStack)ghostStack)) continue;
                if (this.redstone_state.value == RedstoneState.OPERATE_REDSTONE_PULSE) {
                    ++this.pulses.value;
                }
                return;
            }
            for (i = 0; i < 9; ++i) {
                int stacksize = StackHelper.getStacksize(this.ghostSlots.getStackInSlot(i));
                this.outputs.insertItem(i, this.inputs.extractItem(i, stacksize, false), false);
            }
            this.state.value = State.EXTRACTION;
        } else {
            for (int i = 0; i < 9; ++i) {
                if (StackHelper.isEmpty(this.outputs.getStackInSlot(i))) continue;
                return;
            }
            this.state.value = State.INSERTION;
        }
    }

    public static class ContainerGrouper
    extends DynamicContainerTile {
        public ContainerGrouper(final TileGrouper tileGrouper, EntityPlayer player) {
            super(tileGrouper);
            int i;
            this.addTitle(tileGrouper);
            this.crop();
            this.addWidget(new WidgetTextTranslate(4, this.height, Lang.translate("Input Inventory"), 162));
            this.crop();
            for (i = 0; i < 9; ++i) {
                this.addWidget(new WidgetSlotItemHandler((IItemHandler)tileGrouper.inputs, i, 76 + (9 + 18 * i - 81), this.height){

                    @Override
                    public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
                        if (this.func_75216_d()) {
                            ItemStack ghostStack = tileGrouper.ghostSlots.getStackInSlot(this.index);
                            if (StackHelper.isEmpty(ghostStack) || !ItemHandlerHelper.canItemStacksStackRelaxed((ItemStack)this.func_75211_c(), (ItemStack)ghostStack)) {
                                GlStateManager.func_179124_c((float)1.0f, (float)0.0f, (float)0.0f);
                            }
                        } else {
                            ItemStack ghostStack = tileGrouper.ghostSlots.getStackInSlot(this.index);
                            if (StackHelper.isEmpty(ghostStack)) {
                                GlStateManager.func_179124_c((float)0.5f, (float)0.5f, (float)0.5f);
                            }
                        }
                        super.renderBackground(manager, gui, guiLeft, guiTop);
                        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                    }
                });
            }
            this.crop();
            this.addWidget(new WidgetTextTranslate(4, this.height, Lang.translate("Required Items"), 162));
            this.crop();
            for (i = 0; i < 9; ++i) {
                this.addWidget(new WidgetSlotGhost((IItemHandlerModifiable)tileGrouper.ghostSlots, i, 76 + (9 + 18 * i - 81), this.height){

                    @Override
                    public void func_75215_d(ItemStack stack) {
                        ((IItemHandlerModifiable)this.getItemHandler()).setStackInSlot(this.index, StackHelper.safeCopy(stack));
                        this.func_75218_e();
                    }
                });
            }
            this.crop();
            this.addWidget(new WidgetTextTranslate(4, this.height, Lang.translate("Output Inventory"), 162));
            this.crop();
            for (i = 0; i < 9; ++i) {
                this.addWidget(new WidgetSlotItemHandler((IItemHandler)tileGrouper.outputs, i, 76 + (9 + 18 * i - 81), this.height){

                    public boolean func_75214_a(@Nonnull ItemStack stack) {
                        return false;
                    }

                    @Override
                    public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
                        ItemStack ghostStack;
                        if (!this.func_75216_d() && StackHelper.isEmpty(ghostStack = tileGrouper.ghostSlots.getStackInSlot(this.index))) {
                            GlStateManager.func_179124_c((float)0.5f, (float)0.5f, (float)0.5f);
                        }
                        super.renderBackground(manager, gui, guiLeft, guiTop);
                        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                    }
                });
            }
            this.crop();
            this.addWidget(tileGrouper.upgrades.getSpeedUpgradeSlot(63, this.height + 4));
            this.addWidget(TileAdvInteractor.getRSWidget(89, this.height + 4, tileGrouper.redstone_state, tileGrouper.pulses));
            this.cropAndAddPlayerSlots(player.field_71071_by);
            this.validate();
        }
    }

    static enum State {
        INSERTION,
        EXTRACTION;

    }
}

