/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.google.common.collect.ImmutableMap;
import com.rwtema.extrautils2.backend.PropertyEnumSimple;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.blocks.XUTree;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.XURandom;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TreeIronWoods
extends XUTree {
    public static final PropertyEnumSimple<TreeType> TREE_TYPE = new PropertyEnumSimple<TreeType>(TreeType.class);
    public static final int ENCOURAGABILITY = 15;

    public TreeIronWoods() {
        super("ironwood", (Map<Map<IProperty<?>, Comparable<?>>, XUTree.TreeModel>)ImmutableMap.of((Object)ImmutableMap.of(TREE_TYPE, (Object)((Object)TreeType.RAW)), (Object)new XUTree.TreeModelTex("tree/iron_wood_raw"), (Object)ImmutableMap.of(TREE_TYPE, (Object)((Object)TreeType.BURNT)), (Object)new XUTree.TreeModelTex("tree/iron_wood_burnt")));
    }

    public IBlockState convert(IBlockState base, XUBlock other) {
        IBlockState result = other.func_176223_P();
        for (Map.Entry entry2 : base.func_177228_b().entrySet()) {
            IProperty key = (IProperty)entry2.getKey();
            Comparable value = (Comparable)entry2.getValue();
            if (!result.func_177228_b().containsKey((Object)key)) continue;
            result = result.func_177226_a(key, value);
        }
        return result;
    }

    @Override
    public void addRecipes() {
        super.addRecipes();
        FurnaceRecipes.func_77602_a().func_151396_a((Item)((XUTree.TreeBlocks)this.value).planks.itemBlock, new ItemStack(Items.field_191525_da, 1), 0.0f);
    }

    @Override
    protected XUBlockStateCreator.Builder getBuilder(XUBlock block) {
        return new XUBlockStateCreator.Builder(block).addDropProperties(new IProperty[]{TREE_TYPE});
    }

    @Override
    public XUTree.XUTreePlanks getXuTreePlanks() {
        return new XUTree.XUTreePlanks();
    }

    @Override
    public XUTree.XUTreeSapling getXuTreeSapling() {
        return new XUTree.XUTreeSapling(){

            @Override
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                switch ((TreeType)((Object)this.xuBlockState.getStateFromItemStack(stack).func_177229_b((IProperty)TREE_TYPE))) {
                    case RAW: {
                        tooltip.add(Lang.translate("A strange and weak sapling."));
                        break;
                    }
                    case BURNT: {
                        tooltip.add(Lang.translate("It's dead."));
                    }
                }
            }

            @Override
            public void generateTree(World worldIn, BlockPos pos, IBlockState state, Random rand) {
                if (state.func_177229_b(TREE_TYPE) == TreeType.BURNT) {
                    return;
                }
                super.generateTree(worldIn, pos, state, rand);
            }

            @Override
            protected void tryGrow(World worldIn, BlockPos pos, IBlockState state, Random rand) {
                if (state.func_177229_b(TREE_TYPE) == TreeType.BURNT) {
                    return;
                }
                super.tryGrow(worldIn, pos, state, rand);
            }

            @Override
            public void grow(World worldIn, BlockPos pos, IBlockState state, Random rand) {
                if (state.func_177229_b(TREE_TYPE) == TreeType.BURNT) {
                    return;
                }
                super.grow(worldIn, pos, state, rand);
            }

            @Override
            public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
                if (state.func_177229_b(TREE_TYPE) == TreeType.BURNT) {
                    this.func_176226_b(worldIn, pos, state, 0);
                    worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                } else {
                    super.func_180650_b(worldIn, pos, state, rand);
                }
            }

            @Override
            public void func_176474_b(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
                if (state.func_177229_b(TREE_TYPE) == TreeType.BURNT) {
                    return;
                }
                super.func_176474_b(worldIn, rand, pos, state);
            }

            @Override
            public boolean func_180670_a(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
                return state.func_177229_b(TREE_TYPE) != TreeType.BURNT && super.func_180670_a(worldIn, rand, pos, state);
            }

            @Override
            public boolean func_176473_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, boolean isClient) {
                return state.func_177229_b(TREE_TYPE) != TreeType.BURNT && super.func_176473_a(worldIn, pos, state, isClient);
            }
        };
    }

    @Override
    public XUTree.XUTreeLog getXuTreeLog() {
        return new XUTree.XUTreeLog(){
            {
                this.func_149675_a(true);
                this.func_149711_c(0.5f);
            }

            public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
                super.func_180650_b(worldIn, pos, state, rand);
                TreeIronWoods.this.performUpdate(worldIn, pos, state, rand);
            }

            @Override
            @Nonnull
            public List<ItemStack> getDrops(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune) {
                if (state.func_177229_b(TREE_TYPE) == TreeType.RAW) {
                    Random r = world instanceof World ? ((World)world).field_73012_v : XURandom.rand;
                    int i = r.nextInt(10);
                    if (i == 0) {
                        return super.getDrops(world, pos, state, fortune);
                    }
                    return ((XUTree.TreeBlocks)TreeIronWoods.this.value).planks.getDrops(world, pos, ((XUTree.TreeBlocks)TreeIronWoods.this.value).planks.func_176223_P().func_177226_a(TREE_TYPE, (Comparable)((Object)TreeType.RAW)), fortune);
                }
                return super.getDrops(world, pos, state, fortune);
            }

            public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
                return 0;
            }

            @Override
            public void neighborChangedBase(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock) {
                if (neighborBlock == Blocks.field_150480_ab) {
                    // empty if block
                }
            }

            public boolean isFlammable(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
                return world.func_180495_p(pos).func_177229_b(TREE_TYPE) == TreeType.RAW;
            }

            public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
                return 15;
            }

            public boolean isFireSource(@Nonnull World world, BlockPos pos, EnumFacing side) {
                return world.func_180495_p(pos).func_177229_b(TREE_TYPE) == TreeType.RAW;
            }
        };
    }

    public void addIronInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
    }

    @Override
    public XUTree.XUTreeLeaves getXuTreeLeaves() {
        return new XUTree.XUTreeLeaves(){
            {
                this.func_149675_a(true);
            }

            @Override
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                TreeIronWoods.this.addIronInformation(stack, playerIn, tooltip, advanced);
            }

            @Override
            public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
                super.func_180650_b(worldIn, pos, state, rand);
                TreeIronWoods.this.performUpdate(worldIn, pos, state, rand);
            }

            public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
                IBlockState blockState = world.func_180495_p(pos);
                return blockState.func_177229_b(TREE_TYPE) == TreeType.BURNT ? 60 : 0;
            }

            public boolean isFlammable(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
                return true;
            }

            public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
                return 15;
            }

            public boolean isFireSource(@Nonnull World world, BlockPos pos, EnumFacing side) {
                return true;
            }
        };
    }

    @Override
    public int getHeight(World worldIn, Random rand, IBlockState state, BlockPos pos) {
        return 5;
    }

    @Override
    protected int getLeavesColour(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
        if (state.func_177229_b(TREE_TYPE) == TreeType.BURNT) {
            return -1;
        }
        return super.getLeavesColour(state, worldIn, pos, tintIndex);
    }

    private void performUpdate(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (state.func_177229_b(TREE_TYPE) == TreeType.RAW) {
            for (EnumFacing facing : EnumFacing.values()) {
                BlockPos offset;
                if (worldIn.func_180495_p(pos.func_177972_a(facing)).func_177230_c() != Blocks.field_150480_ab) continue;
                for (EnumFacing enumFacing : EnumFacing.values()) {
                    offset = pos.func_177972_a(enumFacing);
                    IBlockState blockState = worldIn.func_180495_p(offset);
                    if (blockState.func_177230_c() == Blocks.field_150480_ab || blockState.func_177230_c().isAir(blockState, (IBlockAccess)worldIn, offset)) {
                        worldIn.func_180501_a(offset, Blocks.field_150480_ab.func_176223_P().func_177226_a((IProperty)BlockFire.field_176543_a, (Comparable)Integer.valueOf(0)), 3);
                        continue;
                    }
                    if (!blockState.func_177228_b().containsKey(TREE_TYPE)) continue;
                    for (EnumFacing enumFacing2 : EnumFacing.values()) {
                        BlockPos offset2;
                        IBlockState blockState2;
                        if (rand.nextBoolean() || (blockState2 = worldIn.func_180495_p(offset2 = pos.func_177972_a(enumFacing2))).func_177230_c() != Blocks.field_150480_ab && !blockState2.func_177230_c().isAir(blockState2, (IBlockAccess)worldIn, offset2)) continue;
                        worldIn.func_180501_a(offset2, Blocks.field_150480_ab.func_176223_P().func_177226_a((IProperty)BlockFire.field_176543_a, (Comparable)Integer.valueOf(0)), 3);
                    }
                }
                worldIn.func_175656_a(pos, state.func_177226_a(TREE_TYPE, (Comparable)((Object)TreeType.BURNT)));
                for (EnumFacing enumFacing : EnumFacing.values()) {
                    IBlockState offsetBlockState;
                    if (rand.nextBoolean() || !(offsetBlockState = worldIn.func_180495_p(offset = pos.func_177972_a(enumFacing))).func_177228_b().containsKey(TREE_TYPE) || offsetBlockState.func_177229_b(TREE_TYPE) != TreeType.RAW) continue;
                    worldIn.func_175656_a(offset, offsetBlockState.func_177226_a(TREE_TYPE, (Comparable)((Object)TreeType.BURNT)));
                }
                return;
            }
        }
    }

    public static enum TreeType {
        RAW,
        BURNT;

    }
}

