/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storagemonitor;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.network.NetworkTools;
import mcjty.rftools.blocks.storagemonitor.ReturnInfoHelper;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class PacketReturnInventoryInfo
implements IMessage {
    private List<InventoryInfo> inventories;

    public List<InventoryInfo> getInventories() {
        return this.inventories;
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        this.inventories = new ArrayList<InventoryInfo>(size);
        for (int i = 0; i < size; ++i) {
            BlockPos pos = NetworkTools.readPos((ByteBuf)buf);
            String name = NetworkTools.readString((ByteBuf)buf);
            boolean routable = buf.readBoolean();
            Block block = null;
            if (buf.readBoolean()) {
                block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(NetworkTools.readString((ByteBuf)buf)));
            }
            this.inventories.add(new InventoryInfo(pos, name, routable, block));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.inventories.size());
        for (InventoryInfo info : this.inventories) {
            NetworkTools.writePos((ByteBuf)buf, (BlockPos)info.getPos());
            NetworkTools.writeString((ByteBuf)buf, (String)info.getName());
            buf.writeBoolean(info.isRoutable());
            if (info.getBlock() == null) {
                buf.writeBoolean(false);
                continue;
            }
            buf.writeBoolean(true);
            String id = info.getBlock().getRegistryName().toString();
            NetworkTools.writeString((ByteBuf)buf, (String)id);
        }
    }

    public PacketReturnInventoryInfo() {
    }

    public PacketReturnInventoryInfo(List<InventoryInfo> inventories) {
        this.inventories = inventories;
    }

    public static class InventoryInfo {
        private final BlockPos pos;
        private final String name;
        private final boolean routable;
        private final Block block;

        public InventoryInfo(BlockPos pos, String name, boolean routable, Block block) {
            this.pos = pos;
            this.name = name;
            this.routable = routable;
            this.block = block;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public String getName() {
            return this.name;
        }

        public boolean isRoutable() {
            return this.routable;
        }

        public Block getBlock() {
            return this.block;
        }
    }

    public static class Handler
    implements IMessageHandler<PacketReturnInventoryInfo, IMessage> {
        public IMessage onMessage(PacketReturnInventoryInfo message, MessageContext ctx) {
            ReturnInfoHelper.onMessageFromServer(message);
            return null;
        }
    }
}

