/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib;

import com.brandon3055.brandonscore.utils.MultiBlockHelper;
import java.util.function.Consumer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class MultiBlockStorage {
    private MultiBlockHelper helper;
    private String[][][] blockStorage;
    private int xPos = 0;
    private int yPos = 0;

    public MultiBlockStorage(int size, MultiBlockHelper helper) {
        this.blockStorage = new String[size][size][size];
        this.helper = helper;
    }

    public void addRow(String ... zRow) {
        if (zRow.length > this.blockStorage.length || zRow.length < this.blockStorage.length) {
            throw new RuntimeException("[MultiBlockStorage] Attempt to add zRow larger or smaller then defined structure size");
        }
        if (this.xPos >= this.blockStorage.length) {
            throw new RuntimeException("[MultiBlockStorage] Attempt to add too many zRow's to layer");
        }
        this.blockStorage[this.xPos][this.yPos] = zRow;
        ++this.xPos;
    }

    public void newLayer() {
        this.xPos = 0;
        ++this.yPos;
        if (this.yPos >= this.blockStorage.length) {
            throw new RuntimeException("[MultiBlockStorage] Attempt to add too many layers to structure");
        }
    }

    public boolean checkStructure(World world, BlockPos startPos) {
        for (int x = 0; x < this.blockStorage.length; ++x) {
            for (int y = 0; y < this.blockStorage[0].length; ++y) {
                for (int z = 0; z < this.blockStorage[0][0].length; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (this.helper.checkBlock(this.blockStorage[x][y][z], world, pos.func_177971_a((Vec3i)startPos))) continue;
                    this.helper.invalidBlock = startPos.func_177971_a((Vec3i)pos);
                    this.helper.expectedBlock = this.blockStorage[x][y][z];
                    return false;
                }
            }
        }
        this.helper.invalidBlock = null;
        return true;
    }

    public void placeStructure(World world, BlockPos startPos) {
        for (int x = 0; x < this.blockStorage.length; ++x) {
            for (int y = 0; y < this.blockStorage[0].length; ++y) {
                for (int z = 0; z < this.blockStorage[0][0].length; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    this.helper.setBlock(this.blockStorage[x][y][z], world, pos.func_177971_a((Vec3i)startPos));
                }
            }
        }
    }

    public void forEachInStructure(World world, BlockPos startPos, int flag) {
        for (int x = 0; x < this.blockStorage.length; ++x) {
            for (int y = 0; y < this.blockStorage[0].length; ++y) {
                for (int z = 0; z < this.blockStorage[0][0].length; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    this.helper.forBlock(this.blockStorage[x][y][z], world, pos.func_177971_a((Vec3i)startPos), startPos, flag);
                }
            }
        }
    }

    public void forEachBlock(BlockPos startPos, Consumer<BlockPos> consumer) {
        for (int x = 0; x < this.blockStorage.length; ++x) {
            for (int y = 0; y < this.blockStorage[0].length; ++y) {
                for (int z = 0; z < this.blockStorage[0][0].length; ++z) {
                    if (this.blockStorage[x][y][z].equals("")) continue;
                    consumer.accept(new BlockPos(x, y, z).func_177971_a((Vec3i)startPos));
                }
            }
        }
    }
}

