/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib;

import cofh.redstoneflux.api.IEnergyContainerItem;
import cofh.redstoneflux.api.IEnergyHandler;
import cofh.redstoneflux.api.IEnergyProvider;
import cofh.redstoneflux.api.IEnergyReceiver;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyHelper {
    public static boolean isEnergyTile(TileEntity tile) {
        return EnergyHelper.isEnergyTile(tile, null);
    }

    public static boolean isEnergyTile(TileEntity tile, EnumFacing side) {
        return tile instanceof IEnergyReceiver || tile.hasCapability(CapabilityEnergy.ENERGY, side);
    }

    public static int getEnergyStored(TileEntity tile) {
        return EnergyHelper.getEnergyStored(tile, null);
    }

    public static int getEnergyStored(TileEntity tile, EnumFacing side) {
        if (tile instanceof IEnergyHandler) {
            return ((IEnergyHandler)tile).getEnergyStored(side);
        }
        if (tile.hasCapability(CapabilityEnergy.ENERGY, side)) {
            IEnergyStorage cap = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, side);
            if (cap != null && cap.canReceive()) {
                return cap.getEnergyStored();
            }
            return 0;
        }
        return 0;
    }

    public static int getMaxEnergyStored(TileEntity tile) {
        return EnergyHelper.getEnergyStored(tile, null);
    }

    public static int getMaxEnergyStored(TileEntity tile, EnumFacing side) {
        if (tile instanceof IEnergyHandler) {
            return ((IEnergyHandler)tile).getMaxEnergyStored(side);
        }
        if (tile.hasCapability(CapabilityEnergy.ENERGY, side)) {
            IEnergyStorage cap = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, side);
            if (cap != null && cap.canReceive()) {
                return cap.getMaxEnergyStored();
            }
            return 0;
        }
        return 0;
    }

    public static boolean canReceiveEnergy(TileEntity tile) {
        return EnergyHelper.canReceiveEnergy(tile, null);
    }

    public static boolean canReceiveEnergy(TileEntity tile, EnumFacing side) {
        if (tile instanceof IEnergyProvider) {
            return true;
        }
        if (tile.hasCapability(CapabilityEnergy.ENERGY, side)) {
            IEnergyStorage cap = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, side);
            return cap != null && cap.canReceive();
        }
        return false;
    }

    public static int insertEnergy(TileEntity tile, int energy, boolean simulate) {
        return EnergyHelper.insertEnergy(tile, energy, null, simulate);
    }

    public static int insertEnergy(TileEntity tile, int energy, EnumFacing side, boolean simulate) {
        IEnergyStorage cap;
        if (tile.func_145831_w().field_72995_K) {
            LogHelperBC.bigDev("Attempt to do energy operation client side!", new Object[0]);
            return 0;
        }
        if (energy < 0) {
            return 0;
        }
        if (tile instanceof IEnergyReceiver) {
            return ((IEnergyReceiver)tile).receiveEnergy(side, energy, simulate);
        }
        if (tile.hasCapability(CapabilityEnergy.ENERGY, side) && (cap = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, side)) != null && cap.canReceive()) {
            return cap.receiveEnergy(energy, simulate);
        }
        return 0;
    }

    public static boolean canExtractEnergy(TileEntity tile) {
        return EnergyHelper.canReceiveEnergy(tile, null);
    }

    public static boolean canExtractEnergy(TileEntity tile, EnumFacing side) {
        if (tile instanceof IEnergyProvider) {
            return true;
        }
        if (tile.hasCapability(CapabilityEnergy.ENERGY, side)) {
            IEnergyStorage cap = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, side);
            return cap != null && cap.canExtract();
        }
        return false;
    }

    public static int extractEnergy(TileEntity tile, int energy, boolean simulate) {
        return EnergyHelper.extractEnergy(tile, energy, null, simulate);
    }

    public static int extractEnergy(TileEntity tile, int energy, EnumFacing side, boolean simulate) {
        IEnergyStorage cap;
        if (tile.func_145831_w().field_72995_K) {
            LogHelperBC.bigDev("Attempt to do energy operation client side!", new Object[0]);
            return 0;
        }
        if (energy < 0) {
            return 0;
        }
        if (tile instanceof IEnergyProvider) {
            return ((IEnergyProvider)tile).extractEnergy(side, energy, simulate);
        }
        if (tile.hasCapability(CapabilityEnergy.ENERGY, side) && (cap = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, side)) != null && cap.canExtract()) {
            return cap.extractEnergy(energy, simulate);
        }
        return 0;
    }

    public static boolean isEnergyStack(ItemStack stack) {
        return !stack.func_190926_b() && (stack.func_77973_b() instanceof IEnergyContainerItem || stack.hasCapability(CapabilityEnergy.ENERGY, null));
    }

    public static int getEnergyStored(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        if (stack.func_77973_b() instanceof IEnergyContainerItem) {
            return ((IEnergyContainerItem)stack.func_77973_b()).getEnergyStored(stack);
        }
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage cap = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            if (cap != null) {
                return cap.getEnergyStored();
            }
            return 0;
        }
        return 0;
    }

    public static int getMaxEnergyStored(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        if (stack.func_77973_b() instanceof IEnergyContainerItem) {
            return ((IEnergyContainerItem)stack.func_77973_b()).getMaxEnergyStored(stack);
        }
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage cap = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            if (cap != null) {
                return cap.getMaxEnergyStored();
            }
            return 0;
        }
        return 0;
    }

    public static boolean canReceiveEnergy(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77973_b() instanceof IEnergyContainerItem) {
            return true;
        }
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage cap = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            return cap != null && cap.canReceive();
        }
        return false;
    }

    public static int insertEnergy(ItemStack stack, int energy, boolean simulate) {
        IEnergyStorage cap;
        if (stack.func_190926_b() || energy < 0) {
            return 0;
        }
        if (stack.func_77973_b() instanceof IEnergyContainerItem) {
            return ((IEnergyContainerItem)stack.func_77973_b()).receiveEnergy(stack, energy, simulate);
        }
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null) && (cap = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)) != null && cap.canReceive()) {
            return cap.receiveEnergy(energy, simulate);
        }
        return 0;
    }

    public static boolean canExtractEnergy(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77973_b() instanceof IEnergyContainerItem) {
            return true;
        }
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage cap = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            return cap != null && cap.canExtract();
        }
        return false;
    }

    public static int extractEnergy(ItemStack stack, int energy, boolean simulate) {
        IEnergyStorage cap;
        if (stack.func_190926_b() || energy < 0) {
            return 0;
        }
        if (stack.func_77973_b() instanceof IEnergyContainerItem) {
            return ((IEnergyContainerItem)stack.func_77973_b()).extractEnergy(stack, energy, simulate);
        }
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null) && (cap = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)) != null && cap.canExtract()) {
            return cap.extractEnergy(energy, simulate);
        }
        return 0;
    }
}

