/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.integration;

import com.brandon3055.brandonscore.integration.BCJEIPlugin;
import com.brandon3055.brandonscore.integration.IRecipeRenderer;
import com.brandon3055.brandonscore.integration.ModHelperBC;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.config.KeyBindings;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StringUtils;
import net.minecraftforge.fml.common.Optional;

public class JeiHelper {
    public static boolean jeiAvailable() {
        if (!ModHelperBC.isJEIInstalled) {
            return false;
        }
        return JeiHelper.checkJEIRuntime();
    }

    @Optional.Method(modid="jei")
    public static boolean checkJEIRuntime() {
        return BCJEIPlugin.jeiRuntime != null;
    }

    public static List<IRecipeRenderer> getRecipeRenderers(ItemStack result) {
        if (!JeiHelper.jeiAvailable()) {
            return null;
        }
        return JeiHelper.getRenderers(result);
    }

    @Optional.Method(modid="jei")
    private static List<IRecipeRenderer> getRenderers(ItemStack result) {
        ArrayList<IRecipeRenderer> renderers = new ArrayList<IRecipeRenderer>();
        IRecipeRegistry registry = BCJEIPlugin.jeiRuntime.getRecipeRegistry();
        LinkedList categories = new LinkedList(registry.getRecipeCategories(registry.createFocus(IFocus.Mode.OUTPUT, (Object)result)));
        for (IRecipeCategory category : categories) {
            List wrappers = registry.getRecipeWrappers(category, registry.createFocus(IFocus.Mode.OUTPUT, (Object)result));
            for (Object wrapper : wrappers) {
                try {
                    renderers.add(new RecipeRenderer(category, (IRecipeWrapper)wrapper, result));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        return renderers;
    }

    public static void openJEIRecipe(ItemStack stack, boolean usage) {
        if (JeiHelper.jeiAvailable()) {
            JeiHelper.openJEIRecipeInternal(stack, usage);
        }
    }

    @Optional.Method(modid="jei")
    private static void openJEIRecipeInternal(ItemStack stack, boolean usage) {
        if (JeiHelper.checkJEIRuntime()) {
            IFocus f = BCJEIPlugin.jeiRuntime.getRecipeRegistry().createFocus(usage ? IFocus.Mode.INPUT : IFocus.Mode.OUTPUT, (Object)stack);
            BCJEIPlugin.jeiRuntime.getRecipesGui().show(f);
        }
    }

    public static int getRecipeKey(boolean usage) {
        if (JeiHelper.jeiAvailable()) {
            return JeiHelper.getRecipeKeyInternal(usage);
        }
        return -1;
    }

    @Optional.Method(modid="jei")
    private static int getRecipeKeyInternal(boolean usage) {
        try {
            return usage ? KeyBindings.showUses.func_151463_i() : KeyBindings.showRecipe.func_151463_i();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return 1;
        }
    }

    public static ItemStack getPanelItemUnderMouse() {
        if (!JeiHelper.jeiAvailable()) {
            return null;
        }
        Object ingredient = BCJEIPlugin.jeiRuntime.getIngredientListOverlay().getIngredientUnderMouse();
        if (ingredient == null) {
            return null;
        }
        IIngredientHelper helper = BCJEIPlugin.ingredientRegistry.getIngredientHelper(ingredient);
        return helper.cheatIngredient(ingredient, false);
    }

    private static class RecipeRenderer
    implements IRecipeRenderer {
        private IRecipeLayoutDrawable recipeLayout;
        private int width;
        private int height;
        private int xPos = 0;
        private int yPos = 0;
        private String title;

        public RecipeRenderer(IRecipeCategory category, IRecipeWrapper wrapper, ItemStack result) {
            IFocus f = BCJEIPlugin.jeiRuntime.getRecipeRegistry().createFocus(IFocus.Mode.OUTPUT, (Object)result);
            this.recipeLayout = BCJEIPlugin.jeiRuntime.getRecipeRegistry().createRecipeLayoutDrawable(category, wrapper, f);
            this.width = category.getBackground().getWidth();
            this.height = category.getBackground().getHeight();
            this.title = category.getTitle();
            if (StringUtils.func_151246_b((String)this.title)) {
                this.title = "[Unknown Crafting Type]";
            }
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public void render(Minecraft mc, int xPos, int yPos, int mouseX, int mouseY) {
            if (this.xPos != xPos || this.yPos != yPos) {
                this.xPos = xPos;
                this.yPos = yPos;
                this.recipeLayout.setPosition(xPos, yPos);
            }
            this.recipeLayout.drawRecipe(mc, mouseX, mouseY);
        }

        @Override
        public void renderOverlay(Minecraft mc, int mouseX, int mouseY) {
            this.recipeLayout.drawOverlays(mc, mouseX, mouseY);
        }

        @Override
        public boolean handleRecipeClick(Minecraft minecraft, int mouseX, int mouseY, boolean usage) {
            Object clicked = this.recipeLayout.getIngredientUnderMouse(mouseX, mouseY);
            if (clicked != null) {
                IFocus f = BCJEIPlugin.jeiRuntime.getRecipeRegistry().createFocus(usage ? IFocus.Mode.INPUT : IFocus.Mode.OUTPUT, clicked);
                BCJEIPlugin.jeiRuntime.getRecipesGui().show(f);
            }
            return false;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        @Nullable
        public Object getIngredientUnderMouse(int mouseX, int mouseY) {
            return this.recipeLayout.getIngredientUnderMouse(mouseX, mouseY);
        }
    }
}

