/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.particle;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.client.particle.BCEffectRenderer;
import com.brandon3055.brandonscore.client.particle.BCParticle;
import com.brandon3055.brandonscore.client.particle.IBCParticleFactory;
import com.brandon3055.brandonscore.client.particle.IGLFXHandler;
import com.brandon3055.brandonscore.lib.PairKV;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.network.PacketSpawnParticle;
import com.brandon3055.brandonscore.utils.BCProfiler;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BCEffectHandler {
    private static BCEffectHandler instance = new BCEffectHandler();
    @SideOnly(value=Side.CLIENT)
    public static BCEffectRenderer effectRenderer;
    public static Map<Integer, PairKV<IBCParticleFactory, ResourceLocation>> particleRegistry;
    private static int lastIndex;

    @SideOnly(value=Side.CLIENT)
    public static void iniEffectRenderer() {
        effectRenderer = new BCEffectRenderer(null);
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }

    @SideOnly(value=Side.CLIENT)
    public static int registerFX(ResourceLocation particleSheet, IBCParticleFactory factory) {
        particleRegistry.put(++lastIndex, new PairKV<IBCParticleFactory, ResourceLocation>(factory, particleSheet));
        return lastIndex;
    }

    public static int registerFXServer() {
        return ++lastIndex;
    }

    public static void spawnFX(int particleID, World world, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, double viewRange, int ... args) {
        BCEffectHandler.spawnFX(particleID, world, new Vec3D(xCoord, yCoord, zCoord), new Vec3D(xSpeed, ySpeed, zSpeed), viewRange, args);
    }

    public static void spawnFX(int particleID, World world, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... args) {
        BCEffectHandler.spawnFX(particleID, world, new Vec3D(xCoord, yCoord, zCoord), new Vec3D(xSpeed, ySpeed, zSpeed), 32.0, args);
    }

    public static void spawnFX(int particleID, World world, Vec3D pos, Vec3D speed, int ... args) {
        BCEffectHandler.spawnFX(particleID, world, pos, speed, 32.0, args);
    }

    public static void spawnFX(int particleID, World world, Vec3D pos, Vec3D speed, double viewRange, int ... args) {
        if (!world.field_72995_K) {
            BrandonsCore.network.sendToAllAround((IMessage)new PacketSpawnParticle(particleID, pos.x, pos.y, pos.z, speed.x, speed.y, speed.z, viewRange, args), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), pos.x, pos.y, pos.z, viewRange));
        } else if (BCEffectHandler.isInRange(pos.x, pos.y, pos.z, viewRange) && effectRenderer != null) {
            if (!particleRegistry.containsKey(particleID)) {
                LogHelperBC.error("Attempted to spawn an unregistered particle ID (%s)", particleID);
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            int particleSetting = mc.field_71474_y.field_74362_aa;
            if (particleSetting == 2 || particleSetting == 1 && world.field_73012_v.nextInt(3) != 0) {
                return;
            }
            PairKV<IBCParticleFactory, ResourceLocation> pair = particleRegistry.get(particleID);
            Particle particle = pair.getKey().getEntityFX(particleID, world, pos, speed, args);
            if (particle instanceof BCParticle && ((BCParticle)particle).isRawGLParticle()) {
                IGLFXHandler iglfxHandler = ((BCParticle)particle).getFXHandler();
                iglfxHandler = new IGLFXHandler(){

                    @Override
                    public void preDraw(int layer, BufferBuilder vertexbuffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
                    }

                    @Override
                    public void postDraw(int layer, BufferBuilder vertexbuffer, Tessellator tessellator) {
                    }
                };
                if (iglfxHandler == null) {
                    LogHelperBC.bigError("Attempted to spawn a raw GL particle with a null glfx handler! " + particle, new Object[0]);
                    return;
                }
                effectRenderer.addRawGLEffect(iglfxHandler, (BCParticle)particle);
            } else {
                effectRenderer.addEffect(pair.getValue(), particle);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawnFXDirect(ResourceLocation texture, BCParticle particle) {
        BCEffectHandler.spawnFXDirect(texture, particle, 32.0, true);
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawnFXDirect(ResourceLocation texture, BCParticle particle, double viewRange, boolean respectParticleSetting) {
        Vec3D pos = particle.getPos();
        if (BCEffectHandler.isInRange(pos.x, pos.y, pos.z, viewRange) && effectRenderer != null) {
            Minecraft mc = Minecraft.func_71410_x();
            int particleSetting = mc.field_71474_y.field_74362_aa;
            if (respectParticleSetting && (particleSetting == 2 || particleSetting == 1 && particle.getWorld().field_73012_v.nextInt(3) != 0)) {
                return;
            }
            effectRenderer.addEffect(texture, particle);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawnGLParticle(IGLFXHandler handler, BCParticle particle, double viewRange, boolean respectParticleSetting) {
        Vec3D pos = particle.getPos();
        if (BCEffectHandler.isInRange(pos.x, pos.y, pos.z, viewRange) && effectRenderer != null) {
            Minecraft mc = Minecraft.func_71410_x();
            int particleSetting = mc.field_71474_y.field_74362_aa;
            if (respectParticleSetting && (particleSetting == 2 || particleSetting == 1 && particle.getWorld().field_73012_v.nextInt(3) != 0)) {
                return;
            }
            effectRenderer.addRawGLEffect(handler, particle);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawnGLParticle(IGLFXHandler handler, BCParticle particle) {
        effectRenderer.addRawGLEffect(handler, particle);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END || Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        if (BCEffectHandler.effectRenderer.world != null) {
            BCProfiler.TICK.start("update_bc_effect_renderer");
            Minecraft.func_71410_x().field_71424_I.func_76320_a("DEParticlesUpdate");
            effectRenderer.updateEffects();
            Minecraft.func_71410_x().field_71424_I.func_76319_b();
            BCProfiler.TICK.stop();
        }
    }

    @SubscribeEvent
    public void worldLoad(WorldEvent.Load event) {
        effectRenderer.clearEffects(event.getWorld());
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderWorld(RenderWorldLastEvent event) {
        BCProfiler.RENDER.start("bc_effect_renderer_draw");
        Minecraft.func_71410_x().field_71424_I.func_76320_a("DEParticles");
        effectRenderer.renderParticles((Entity)Minecraft.func_71410_x().field_71439_g, event.getPartialTicks());
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
        BCProfiler.RENDER.stop();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void debugOverlay(RenderGameOverlayEvent.Text event) {
        if (event.getLeft().size() >= 5 && effectRenderer != null) {
            String particleTxt = (String)event.getLeft().get(4);
            particleTxt = particleTxt + "." + TextFormatting.GOLD + " DE-P: " + effectRenderer.getStatistics();
            event.getLeft().set(4, particleTxt);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isInRange(double x, double y, double z, double vewRange) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.func_175606_aa() == null || mc.field_71452_i == null) {
            return false;
        }
        double var15 = mc.func_175606_aa().field_70165_t - x;
        double var17 = mc.func_175606_aa().field_70163_u - y;
        double var19 = mc.func_175606_aa().field_70161_v - z;
        return !(var15 * var15 + var17 * var17 + var19 * var19 > vewRange * vewRange);
    }

    static {
        particleRegistry = new LinkedHashMap<Integer, PairKV<IBCParticleFactory, ResourceLocation>>();
        lastIndex = -1;
    }
}

