/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.baseelements;

import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import java.awt.Rectangle;
import java.io.IOException;
import javax.annotation.Nullable;

public class GuiPopUpDialogBase<E extends MGuiElementBase<E>>
extends MGuiElementBase<E> {
    protected int dragXOffset = 0;
    protected int dragYOffset = 0;
    protected boolean dragging = false;
    protected boolean closeOnOutsideClick = true;
    protected boolean closeOnScroll = false;
    protected boolean isVisible = false;
    protected boolean closeOnCapturedClick = false;
    protected Rectangle dragZone = null;

    public GuiPopUpDialogBase(MGuiElementBase parent) {
        this.setParent(parent);
        if (parent.modularGui == null) {
            throw new RuntimeException("GuiPopUpDialogBase parent has must be initialized!");
        }
        this.applyGeneralElementData(parent.modularGui, parent.mc, parent.screenWidth, parent.screenHeight, parent.fontRenderer);
    }

    public GuiPopUpDialogBase(int xPos, int yPos, MGuiElementBase parent) {
        super(xPos, yPos);
        this.setParent(parent);
        this.applyGeneralElementData(parent.modularGui, parent.mc, parent.screenWidth, parent.screenHeight, parent.fontRenderer);
    }

    public GuiPopUpDialogBase(int xPos, int yPos, int xSize, int ySize, MGuiElementBase parent) {
        super(xPos, yPos, xSize, ySize);
        this.setParent(parent);
        this.applyGeneralElementData(parent.modularGui, parent.mc, parent.screenWidth, parent.screenHeight, parent.fontRenderer);
    }

    @Override
    public void addChildElements() {
        super.addChildElements();
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.closeOnOutsideClick && !this.isMouseOver(mouseX, mouseY)) {
            this.close();
            return true;
        }
        boolean captured = super.mouseClicked(mouseX, mouseY, mouseButton);
        if (captured && this.closeOnCapturedClick) {
            this.close();
        }
        if (!captured && this.dragZone != null && this.dragZone.contains(mouseX - this.xPos(), mouseY - this.yPos())) {
            this.dragging = true;
            this.dragXOffset = mouseX - this.xPos();
            this.dragYOffset = mouseY - this.yPos();
        }
        return captured;
    }

    @Override
    public boolean allowMouseOver(MGuiElementBase elementRequesting, int mouseX, int mouseY) {
        return true;
    }

    @Override
    public boolean mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (this.dragging) {
            int xMove = mouseX - this.dragXOffset - this.xPos();
            int yMove = mouseY - this.dragYOffset - this.yPos();
            this.translate(xMove, yMove);
        }
        return super.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int state) {
        this.dragging = false;
        return super.mouseReleased(mouseX, mouseY, state);
    }

    @Override
    public boolean handleMouseScroll(int mouseX, int mouseY, int scrollDirection) {
        if (this.closeOnScroll) {
            this.close();
        }
        return super.handleMouseScroll(mouseX, mouseY, scrollDirection);
    }

    @Override
    protected boolean keyTyped(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.close();
            return true;
        }
        return super.keyTyped(typedChar, keyCode);
    }

    public E setCloseOnOutsideClick(boolean closeOnOutsideClick) {
        this.closeOnOutsideClick = closeOnOutsideClick;
        return (E)this;
    }

    public E setCloseOnScroll(boolean closeOnScroll) {
        this.closeOnScroll = closeOnScroll;
        return (E)this;
    }

    public E setDragZone(@Nullable Rectangle rectangle) {
        this.dragZone = rectangle;
        return (E)this;
    }

    public E setDragZone(int x, int y, int width, int height) {
        this.dragZone = new Rectangle(x, y, width, height);
        return (E)this;
    }

    public E setDragBar(int height) {
        return this.setDragZone(0, 0, this.xSize(), height);
    }

    public E setCloseOnCapturedClick(boolean closeOnCapturedClick) {
        this.closeOnCapturedClick = closeOnCapturedClick;
        return (E)this;
    }

    public void show(int displayZLevel) {
        this.modularGui.getManager().add(this, displayZLevel);
        this.isVisible = true;
    }

    public void show() {
        int pz = this.getParent() == null ? 100 : this.getParent().displayZLevel;
        this.show(pz >= 500 ? pz + 50 : 500);
    }

    public void showCenter(int displayZLevel) {
        this.show(displayZLevel);
        this.setXPos(this.screenWidth / 2 - this.xSize() / 2);
        this.setYPos(this.screenHeight / 2 - this.ySize() / 2);
    }

    public void showCenter() {
        int pz = this.getParent() == null ? 100 : this.getParent().displayZLevel;
        this.showCenter(pz >= 500 ? pz + 50 : 500);
    }

    public void close() {
        this.modularGui.getManager().remove(this);
        this.isVisible = false;
    }

    public void toggleShown(boolean centre, int displayZLevel) {
        if (this.isVisible) {
            this.close();
        } else if (centre) {
            this.showCenter(displayZLevel);
        } else {
            this.show(displayZLevel);
        }
    }

    public void toggleShown(boolean centre) {
        this.toggleShown(centre, 500);
    }

    public void toggleShown() {
        this.toggleShown(true);
    }

    public boolean isVisible() {
        return this.isVisible;
    }
}

