/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import java.util.Arrays;
import java.util.List;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.common.NBTUtil;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class UpgradableItemUtils {
    public static int addUpgradeInformation(ItemStack iStack, World world, List<String> textList, ITooltipFlag flag) {
        ItemStack[] inventoryStacks = UpgradableItemUtils.getUpgradeStacks(iStack);
        boolean isItemEmpty = true;
        for (ItemStack stack : inventoryStacks) {
            if (stack.func_190926_b()) continue;
            isItemEmpty = false;
            break;
        }
        if (isItemEmpty) {
            textList.add(I18n.func_135052_a((String)"gui.tooltip.upgrades.empty", (Object[])new Object[0]));
        } else {
            textList.add(I18n.func_135052_a((String)"gui.tooltip.upgrades.not_empty", (Object[])new Object[0]));
            PneumaticCraftUtils.sortCombineItemStacksAndToString(textList, inventoryStacks);
        }
        return inventoryStacks.length;
    }

    public static ItemStack[] getUpgradeStacks(ItemStack iStack) {
        NBTTagCompound tag = NBTUtil.getCompoundTag(iStack, "UpgradeInventory");
        Object[] inventoryStacks = new ItemStack[9];
        Arrays.fill(inventoryStacks, ItemStack.field_190927_a);
        NBTTagList itemList = tag.func_150295_c("Items", 10);
        for (int i = 0; i < itemList.func_74745_c(); ++i) {
            NBTTagCompound slotEntry = itemList.func_150305_b(i);
            byte j = slotEntry.func_74771_c("Slot");
            if (j < 0 || j >= 9) continue;
            inventoryStacks[j] = new ItemStack(slotEntry);
        }
        return inventoryStacks;
    }

    public static int getUpgrades(IItemRegistry.EnumUpgrade upgrade, ItemStack stack) {
        return UpgradableItemUtils.getUpgrades(Itemss.upgrades.get(upgrade), stack);
    }

    public static int getUpgrades(Item upgrade, ItemStack iStack) {
        ItemStack[] stacks;
        int upgrades = 0;
        for (ItemStack stack : stacks = UpgradableItemUtils.getUpgradeStacks(iStack)) {
            if (stack.func_77973_b() != upgrade) continue;
            upgrades += stack.func_190916_E();
        }
        return upgrades;
    }
}

