/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.client.render.RenderRangeLines;
import me.desht.pneumaticcraft.common.GuiHandler;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketRenderRangeLines;
import me.desht.pneumaticcraft.common.tileentity.IGUITextFieldSensitive;
import me.desht.pneumaticcraft.common.tileentity.IRangeLineShower;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTickableBase;
import me.desht.pneumaticcraft.common.util.GlobalTileEntityCacheManager;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntitySecurityStation
extends TileEntityTickableBase
implements IGUITextFieldSensitive,
IRangeLineShower,
IRedstoneControl {
    private SecurityStationHandler inventory;
    private static final int INVENTORY_SIZE = 35;
    public final List<GameProfile> hackedUsers = new ArrayList<GameProfile>();
    public final List<GameProfile> sharedUsers = new ArrayList<GameProfile>();
    @GuiSynced
    private int rebootTimer;
    @GuiSynced
    public String textFieldText = "";
    private int securityRange;
    private int oldSecurityRange;
    private RenderRangeLines rangeLineRenderer;
    @GuiSynced
    public int redstoneMode;
    public boolean oldRedstoneStatus;
    private boolean validNetwork;

    public TileEntitySecurityStation() {
        super(4);
        this.inventory = new SecurityStationHandler();
        this.addApplicableUpgrade(IItemRegistry.EnumUpgrade.ENTITY_TRACKER, IItemRegistry.EnumUpgrade.SECURITY, IItemRegistry.EnumUpgrade.RANGE);
    }

    public void func_145843_s() {
        super.func_145843_s();
        GlobalTileEntityCacheManager.getInstance().securityStations.remove(this);
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        GlobalTileEntityCacheManager.getInstance().securityStations.add(this);
        this.rangeLineRenderer = new RenderRangeLines(0x33FF0000, this.func_174877_v());
    }

    @Override
    public void func_73660_a() {
        if (this.rebootTimer > 0) {
            --this.rebootTimer;
            if (!this.func_145831_w().field_72995_K && this.rebootTimer == 0) {
                this.hackedUsers.clear();
            }
        }
        if (this.func_145831_w().field_72995_K && !this.firstRun) {
            if (this.oldSecurityRange != this.getSecurityRange() || this.oldSecurityRange == 0) {
                this.rangeLineRenderer.resetRendering(this.getSecurityRange());
                this.oldSecurityRange = this.getSecurityRange();
            }
            this.rangeLineRenderer.update();
        }
        if (this.oldRedstoneStatus != this.shouldEmitRedstone()) {
            this.oldRedstoneStatus = this.shouldEmitRedstone();
            this.updateNeighbours();
        }
        this.securityRange = Math.min(2 + this.getUpgrades(IItemRegistry.EnumUpgrade.RANGE), 16);
        super.func_73660_a();
    }

    public void rebootStation() {
        this.rebootTimer = 1200;
    }

    public int getRebootTime() {
        return this.rebootTimer;
    }

    @Override
    public void showRangeLines() {
        if (this.func_145831_w().field_72995_K) {
            this.rangeLineRenderer.resetRendering(this.getSecurityRange());
        } else {
            NetworkHandler.sendToAllAround(new PacketRenderRangeLines(this), this.func_145831_w(), 64.0 + (double)this.getSecurityRange());
        }
    }

    @Override
    public IItemHandlerModifiable getPrimaryInventory() {
        return this.inventory;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderRangeLines() {
        this.rangeLineRenderer.render();
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
            this.updateNeighbours();
        } else if (buttonID == 2) {
            this.rebootStation();
        } else if (buttonID == 3) {
            if (!this.hasValidNetwork()) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation(TextFormatting.GREEN + "This Security Station is out of order: Its network hasn't been properly configured.", new Object[0]), false);
            } else {
                player.openGui((Object)PneumaticCraftRepressurized.instance, GuiHandler.EnumGuiId.HACKING.ordinal(), this.func_145831_w(), this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
            }
        } else if (buttonID > 3 && buttonID - 4 < this.sharedUsers.size()) {
            this.sharedUsers.remove(buttonID - 4);
        }
        this.sendDescriptionPacket();
    }

    public void addSharedUser(GameProfile user) {
        for (GameProfile sharedUser : this.sharedUsers) {
            if (!this.gameProfileEquals(sharedUser, user)) continue;
            return;
        }
        this.sharedUsers.add(user);
        this.sendDescriptionPacket();
    }

    public void addHacker(GameProfile user) {
        for (GameProfile hackedUser : this.hackedUsers) {
            if (!this.gameProfileEquals(hackedUser, user)) continue;
            return;
        }
        for (GameProfile sharedUser : this.sharedUsers) {
            if (!this.gameProfileEquals(sharedUser, user)) continue;
            return;
        }
        this.hackedUsers.add(user);
        this.sendDescriptionPacket();
    }

    private boolean gameProfileEquals(GameProfile profile1, GameProfile profile2) {
        return profile1.getId() != null && profile2.getId() != null ? profile1.getId().equals(profile2.getId()) : profile1.getName().equals(profile2.getName());
    }

    public boolean shouldEmitRedstone() {
        switch (this.redstoneMode) {
            case 0: {
                return false;
            }
            case 1: {
                return this.isHacked();
            }
            case 2: {
                return this.getRebootTime() <= 0;
            }
        }
        return false;
    }

    public boolean isHacked() {
        return this.hackedUsers.size() > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.rangeLineRenderer == null || !this.rangeLineRenderer.isCurrentlyRendering()) {
            return super.getRenderBoundingBox();
        }
        return this.getAffectingAABB();
    }

    public AxisAlignedBB getAffectingAABB() {
        int range = this.getSecurityRange();
        return new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - range - 1), (double)(this.func_174877_v().func_177956_o() - range - 1), (double)(this.func_174877_v().func_177952_p() - range - 1), (double)(this.func_174877_v().func_177958_n() + 1 + range), (double)(this.func_174877_v().func_177956_o() + 1 + range), (double)(this.func_174877_v().func_177952_p() + 1 + range));
    }

    public int getSecurityRange() {
        return this.securityRange;
    }

    @Override
    public String getName() {
        return Blockss.SECURITY_STATION.func_149739_a();
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.redstoneMode = tag.func_74762_e("redstoneMode");
        this.rebootTimer = tag.func_74762_e("startupTimer");
        this.inventory = new SecurityStationHandler();
        this.inventory.deserializeNBT(tag.func_74775_l("Items"));
        this.checkForNetworkValidity();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("redstoneMode", this.redstoneMode);
        tag.func_74768_a("startupTimer", this.rebootTimer);
        tag.func_74782_a("Items", (NBTBase)this.inventory.serializeNBT());
        return tag;
    }

    @Override
    public void writeToPacket(NBTTagCompound tag) {
        super.writeToPacket(tag);
        NBTTagList sharedList = new NBTTagList();
        for (GameProfile sharedUser : this.sharedUsers) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74778_a("name", sharedUser.getName());
            if (sharedUser.getId() != null) {
                tagCompound.func_74778_a("uuid", sharedUser.getId().toString());
            }
            sharedList.func_74742_a((NBTBase)tagCompound);
        }
        tag.func_74782_a("SharedUsers", (NBTBase)sharedList);
        NBTTagList hackedList = new NBTTagList();
        for (GameProfile hackedUser : this.hackedUsers) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74778_a("name", hackedUser.getName());
            if (hackedUser.getId() != null) {
                tagCompound.func_74778_a("uuid", hackedUser.getId().toString());
            }
            hackedList.func_74742_a((NBTBase)tagCompound);
        }
        tag.func_74782_a("HackedUsers", (NBTBase)hackedList);
    }

    @Override
    public void readFromPacket(NBTTagCompound tag) {
        super.readFromPacket(tag);
        this.sharedUsers.clear();
        NBTTagList sharedList = tag.func_150295_c("SharedUsers", 10);
        for (int i = 0; i < sharedList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = sharedList.func_150305_b(i);
            this.sharedUsers.add(new GameProfile(tagCompound.func_74764_b("uuid") ? UUID.fromString(tagCompound.func_74779_i("uuid")) : null, tagCompound.func_74779_i("name")));
        }
        this.hackedUsers.clear();
        NBTTagList hackedList = tag.func_150295_c("HackedUsers", 10);
        for (int i = 0; i < hackedList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = hackedList.func_150305_b(i);
            this.hackedUsers.add(new GameProfile(tagCompound.func_74764_b("uuid") ? UUID.fromString(tagCompound.func_74779_i("uuid")) : null, tagCompound.func_74779_i("name")));
        }
    }

    @Override
    public void setText(int textFieldID, String text) {
        this.textFieldText = text;
    }

    @Override
    public String getText(int textFieldID) {
        return this.textFieldText;
    }

    public boolean doesAllowPlayer(EntityPlayer player) {
        return this.rebootTimer > 0 || this.isPlayerOnWhiteList(player) || this.hasPlayerHacked(player);
    }

    public boolean isPlayerOnWhiteList(EntityPlayer player) {
        for (int i = 0; i < this.sharedUsers.size(); ++i) {
            GameProfile user = this.sharedUsers.get(i);
            if (!this.gameProfileEquals(user, player.func_146103_bH())) continue;
            if (user.getId() == null && player.func_146103_bH().getId() != null) {
                this.sharedUsers.set(i, player.func_146103_bH());
                Log.info("Legacy conversion: Security Station shared username '" + player.func_70005_c_() + "' is now using UUID '" + player.func_146103_bH().getId() + "'.");
            }
            return true;
        }
        return false;
    }

    public boolean hasPlayerHacked(EntityPlayer player) {
        for (int i = 0; i < this.hackedUsers.size(); ++i) {
            GameProfile user = this.hackedUsers.get(i);
            if (!this.gameProfileEquals(user, player.func_146103_bH())) continue;
            if (user.getId() == null && player.func_146103_bH().getId() != null) {
                this.hackedUsers.set(i, player.func_146103_bH());
                Log.info("Legacy conversion: Security Station hacked username '" + player.func_70005_c_() + "' is now using UUID '" + player.func_146103_bH().getId() + "'.");
            }
            return true;
        }
        return false;
    }

    public boolean connects(int firstSlot, int secondSlot) {
        if (firstSlot < 0 || secondSlot < 0 || firstSlot >= 35 || secondSlot >= 35 || firstSlot == secondSlot || this.inventory.getStackInSlot(firstSlot).func_190926_b() || this.inventory.getStackInSlot(secondSlot).func_190926_b()) {
            return false;
        }
        for (int column = -1; column <= 1; ++column) {
            for (int row = -1; row <= 1; ++row) {
                if (firstSlot + row * 5 + column != secondSlot || !(firstSlot % 5 > 0 && firstSlot % 5 < 4 || secondSlot % 5 > 0 && secondSlot % 5 < 4) && secondSlot % 5 != firstSlot % 5) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasValidNetwork() {
        return this.validNetwork;
    }

    public EnumNetworkValidityProblem checkForNetworkValidity() {
        this.validNetwork = false;
        int ioPortSlot = -1;
        int registrySlot = -1;
        int subroutineSlot = -1;
        block5: for (int i = 0; i < 35; ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
            switch (this.inventory.getStackInSlot(i).func_77952_i()) {
                case 0: {
                    if (subroutineSlot != -1) {
                        return EnumNetworkValidityProblem.TOO_MANY_SUBROUTINES;
                    }
                    subroutineSlot = i;
                    continue block5;
                }
                case 3: {
                    if (ioPortSlot != -1) {
                        return EnumNetworkValidityProblem.TOO_MANY_IO_PORTS;
                    }
                    ioPortSlot = i;
                    continue block5;
                }
                case 4: {
                    if (registrySlot != -1) {
                        return EnumNetworkValidityProblem.TOO_MANY_REGISTRIES;
                    }
                    registrySlot = i;
                }
            }
        }
        if (subroutineSlot == -1) {
            return EnumNetworkValidityProblem.NO_SUBROUTINE;
        }
        if (ioPortSlot == -1) {
            return EnumNetworkValidityProblem.NO_IO_PORT;
        }
        if (registrySlot == -1) {
            return EnumNetworkValidityProblem.NO_REGISTRY;
        }
        if (!this.traceComponent(subroutineSlot, ioPortSlot, new boolean[35])) {
            return EnumNetworkValidityProblem.NO_CONNECTION_SUB_AND_IO_PORT;
        }
        if (!this.traceComponent(ioPortSlot, registrySlot, new boolean[35])) {
            return EnumNetworkValidityProblem.NO_CONNECTION_IO_PORT_AND_REGISTRY;
        }
        this.validNetwork = true;
        return EnumNetworkValidityProblem.NONE;
    }

    private boolean traceComponent(int startSlot, int targetSlot, boolean[] slotsDone) {
        for (int i = 0; i < 35; ++i) {
            if (slotsDone[i] || !this.connects(startSlot, i)) continue;
            if (i == targetSlot) {
                return true;
            }
            slotsDone[i] = true;
            if (!this.traceComponent(i, targetSlot, slotsDone)) continue;
            return true;
        }
        return false;
    }

    public int getDetectionChance() {
        return Math.min(100, 20 + 20 * this.getUpgrades(IItemRegistry.EnumUpgrade.ENTITY_TRACKER));
    }

    public int getSecurityLevel() {
        return 1 + this.getUpgrades(IItemRegistry.EnumUpgrade.SECURITY);
    }

    @Override
    public boolean isGuiUseableByPlayer(EntityPlayer par1EntityPlayer) {
        return this.func_145831_w().func_175625_s(this.func_174877_v()) == this;
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public String getRedstoneButtonText(int mode) {
        switch (mode) {
            case 0: {
                return "gui.tab.redstoneBehaviour.button.never";
            }
            case 1: {
                return "gui.tab.redstoneBehaviour.securityStation.button.hacked";
            }
            case 2: {
                return "gui.tab.redstoneBehaviour.securityStation.button.doneRebooting";
            }
        }
        return "<ERROR>";
    }

    private class SecurityStationHandler
    extends ItemStackHandler {
        private SecurityStationHandler() {
            super(35);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntitySecurityStation.this.checkForNetworkValidity();
        }
    }

    public static enum EnumNetworkValidityProblem {
        NONE,
        NO_SUBROUTINE,
        NO_IO_PORT,
        NO_REGISTRY,
        TOO_MANY_SUBROUTINES,
        TOO_MANY_IO_PORTS,
        TOO_MANY_REGISTRIES,
        NO_CONNECTION_SUB_AND_IO_PORT,
        NO_CONNECTION_IO_PORT_AND_REGISTRY;

    }
}

