/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.PneumaticCraftAPIHandler;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.fluid.Fluids;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.tileentity.FilteredItemStackHandler;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.ISerializableTanks;
import me.desht.pneumaticcraft.common.tileentity.ISmartFluidSync;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTickableBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityKeroseneLamp
extends TileEntityTickableBase
implements IRedstoneControlled,
ISerializableTanks,
ISmartFluidSync {
    public static final int INVENTORY_SIZE = 2;
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    private final Set<BlockPos> managingLights = new HashSet<BlockPos>();
    @DescSynced
    private boolean isOn;
    @GuiSynced
    private int range;
    @GuiSynced
    private int targetRange = 10;
    @GuiSynced
    private int redstoneMode;
    @GuiSynced
    private int fuel;
    private static final int LIGHT_SPACING = 3;
    public static final int MAX_RANGE = 30;
    private int checkingX;
    private int checkingY;
    private int checkingZ;
    @DescSynced
    private EnumFacing sideConnected = EnumFacing.DOWN;
    @LazySynced
    @DescSynced
    @GuiSynced
    private final ISmartFluidSync.SmartSyncTank tank = new ISmartFluidSync.SmartSyncTank(this, 1000){
        private FluidStack prevFluid;

        @Override
        protected void onContentsChanged() {
            super.onContentsChanged();
            if (this.prevFluid == null && this.fluid != null || this.prevFluid != null && this.fluid == null) {
                TileEntityKeroseneLamp.this.recalculateFuelQuality();
            }
            this.prevFluid = this.fluid;
        }
    };
    @DescSynced
    private int fluidAmountScaled;
    @DescSynced
    private float fuelQuality = -1.0f;
    private final ItemStackHandler inventory = new FilteredItemStackHandler(2){

        @Override
        public boolean test(Integer slot, ItemStack itemStack) {
            return itemStack.func_190926_b() || FluidUtil.getFluidHandler((ItemStack)itemStack) != null;
        }
    };

    @Override
    public IItemHandlerModifiable getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K) {
            if (this.fuelQuality < 0.0f) {
                this.recalculateFuelQuality();
            }
            this.processFluidItem(0, 1);
            if (this.func_145831_w().func_82737_E() % 5L == 0L) {
                int realTargetRange;
                int n = realTargetRange = this.redstoneAllows() && this.fuel > 0 ? this.targetRange : 0;
                if (this.redstoneMode == 3) {
                    realTargetRange = (int)((double)this.poweredRedstone / 15.0 * (double)this.targetRange);
                }
                this.updateRange(Math.min(realTargetRange, this.tank.getFluidAmount()));
                this.updateLights();
                this.useFuel();
            }
        } else if (this.isOn && this.func_145831_w().func_82737_E() % 5L == 0L) {
            this.func_145831_w().func_175688_a(EnumParticleTypes.FLAME, (double)this.func_174877_v().func_177958_n() + 0.4 + 0.2 * this.func_145831_w().field_73012_v.nextDouble(), (double)this.func_174877_v().func_177956_o() + 0.2 + (double)this.tank.getFluidAmount() / 1000.0 * 3.0 / 16.0, (double)this.func_174877_v().func_177952_p() + 0.4 + 0.2 * this.func_145831_w().field_73012_v.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    private void recalculateFuelQuality() {
        if (this.tank.getFluid() != null && this.tank.getFluid().amount > 0) {
            if (ConfigHandler.machineProperties.keroseneLampCanUseAnyFuel) {
                Fluid f = this.tank.getFluid().getFluid();
                this.fuelQuality = PneumaticCraftAPIHandler.getInstance().liquidFuels.getOrDefault(f.getName(), 0) / 110;
            } else {
                this.fuelQuality = Fluids.areFluidsEqual(this.tank.getFluid().getFluid(), Fluids.KEROSENE) ? 10000.0f : 0.0f;
            }
            this.fuelQuality *= ConfigHandler.machineProperties.keroseneLampFuelEfficiency;
        }
    }

    private void useFuel() {
        if (this.fuelQuality == 0.0f) {
            return;
        }
        this.fuel -= this.range * this.range * this.range;
        while (this.fuel <= 0 && this.tank.drain(1, true) != null) {
            this.fuel = (int)((float)this.fuel + this.fuelQuality);
        }
        if (this.fuel < 0) {
            this.fuel = 0;
        }
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        this.checkingX = this.func_174877_v().func_177958_n();
        this.checkingY = this.func_174877_v().func_177956_o();
        this.checkingZ = this.func_174877_v().func_177952_p();
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (BlockPos pos : this.managingLights) {
            if (!this.isLampLight(pos)) continue;
            this.func_145831_w().func_175698_g(pos);
        }
    }

    private boolean isLampLight(BlockPos pos) {
        return this.func_145831_w().func_180495_p(pos).func_177230_c() == Blockss.KEROSENE_LAMP_LIGHT;
    }

    private void updateLights() {
        int roundedRange = this.range / 3 * 3;
        this.checkingX += 3;
        if (this.checkingX > this.func_174877_v().func_177958_n() + roundedRange) {
            this.checkingX = this.func_174877_v().func_177958_n() - roundedRange;
            this.checkingY += 3;
            if (this.checkingY > this.func_174877_v().func_177956_o() + roundedRange) {
                this.checkingY = this.func_174877_v().func_177956_o() - roundedRange;
                this.checkingZ += 3;
                if (this.checkingZ > this.func_174877_v().func_177952_p() + roundedRange) {
                    this.checkingZ = this.func_174877_v().func_177952_p() - roundedRange;
                }
            }
        }
        BlockPos pos = new BlockPos(this.checkingX, this.checkingY, this.checkingZ);
        BlockPos lampPos = new BlockPos(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
        if (this.managingLights.contains(pos)) {
            if (this.isLampLight(pos)) {
                if (!this.passesRaytraceTest(pos, lampPos)) {
                    this.func_145831_w().func_175698_g(pos);
                    this.managingLights.remove(pos);
                }
            } else {
                this.managingLights.remove(pos);
            }
        } else {
            this.tryAddLight(pos, lampPos);
        }
    }

    private void updateRange(int targetRange) {
        if (targetRange > this.range) {
            ++this.range;
            BlockPos lampPos = new BlockPos(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
            int roundedRange = this.range / 3 * 3;
            for (int x = -roundedRange; x <= roundedRange; x += 3) {
                for (int y = -roundedRange; y <= roundedRange; y += 3) {
                    for (int z = -roundedRange; z <= roundedRange; z += 3) {
                        BlockPos pos = new BlockPos(x + this.func_174877_v().func_177958_n(), y + this.func_174877_v().func_177956_o(), z + this.func_174877_v().func_177952_p());
                        if (this.managingLights.contains(pos)) continue;
                        this.tryAddLight(pos, lampPos);
                    }
                }
            }
        } else if (targetRange < this.range) {
            --this.range;
            Iterator<BlockPos> iterator = this.managingLights.iterator();
            BlockPos lampPos = new BlockPos(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
            while (iterator.hasNext()) {
                BlockPos pos = iterator.next();
                if (!this.isLampLight(pos)) {
                    iterator.remove();
                    continue;
                }
                if (!(PneumaticCraftUtils.distBetween((Vec3i)pos, (Vec3i)lampPos) > (double)this.range)) continue;
                this.func_145831_w().func_175698_g(pos);
                iterator.remove();
            }
        }
        boolean oldIsOn = this.isOn;
        boolean bl = this.isOn = this.range > 0;
        if (this.isOn != oldIsOn) {
            this.func_145831_w().func_180500_c(EnumSkyBlock.BLOCK, this.func_174877_v());
            this.sendDescriptionPacket();
        }
    }

    public boolean isOn() {
        return this.isOn;
    }

    private boolean passesRaytraceTest(BlockPos pos, BlockPos lampPos) {
        RayTraceResult mop = this.func_145831_w().func_72933_a(new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5), new Vec3d((double)lampPos.func_177958_n() + 0.5, (double)lampPos.func_177956_o() + 0.5, (double)lampPos.func_177952_p() + 0.5));
        return mop != null && lampPos.equals((Object)mop.func_178782_a());
    }

    private void tryAddLight(BlockPos pos, BlockPos lampPos) {
        if (PneumaticCraftUtils.distBetween((Vec3i)pos, (Vec3i)lampPos) <= (double)this.range && this.func_145831_w().func_175623_d(pos) && !this.isLampLight(pos) && this.passesRaytraceTest(pos, lampPos)) {
            this.func_145831_w().func_175656_a(pos, Blockss.KEROSENE_LAMP_LIGHT.func_176223_P());
            this.managingLights.add(pos);
        }
    }

    @Override
    public void onNeighborBlockUpdate() {
        super.onNeighborBlockUpdate();
        EnumFacing oldSideConnected = this.sideConnected;
        this.sideConnected = EnumFacing.DOWN;
        for (EnumFacing d : EnumFacing.field_82609_l) {
            BlockPos neighborPos = this.func_174877_v().func_177972_a(d);
            IBlockState state = this.func_145831_w().func_180495_p(neighborPos);
            if (!state.isSideSolid((IBlockAccess)this.func_145831_w(), neighborPos, d.func_176734_d())) continue;
            this.sideConnected = d;
            break;
        }
        if (this.sideConnected != oldSideConnected) {
            this.sendDescriptionPacket();
        }
    }

    @Override
    public void onDescUpdate() {
        this.func_145831_w().func_180500_c(EnumSkyBlock.BLOCK, this.func_174877_v());
        this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagList lights = new NBTTagList();
        for (BlockPos pos : this.managingLights) {
            NBTTagCompound t = new NBTTagCompound();
            t.func_74768_a("x", pos.func_177958_n());
            t.func_74768_a("y", pos.func_177956_o());
            t.func_74768_a("z", pos.func_177952_p());
            lights.func_74742_a((NBTBase)t);
        }
        tag.func_74782_a("lights", (NBTBase)lights);
        NBTTagCompound tankTag = new NBTTagCompound();
        this.tank.writeToNBT(tankTag);
        tag.func_74782_a("tank", (NBTBase)tankTag);
        tag.func_74774_a("redstoneMode", (byte)this.redstoneMode);
        tag.func_74774_a("targetRange", (byte)this.targetRange);
        tag.func_74774_a("range", (byte)this.range);
        tag.func_74774_a("sideConnected", (byte)this.sideConnected.ordinal());
        tag.func_74782_a("Items", (NBTBase)this.inventory.serializeNBT());
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.managingLights.clear();
        NBTTagList lights = tag.func_150295_c("lights", 10);
        for (int i = 0; i < lights.func_74745_c(); ++i) {
            NBTTagCompound t = lights.func_150305_b(i);
            this.managingLights.add(new BlockPos(t.func_74762_e("x"), t.func_74762_e("y"), t.func_74762_e("z")));
        }
        this.tank.readFromNBT(tag.func_74775_l("tank"));
        this.fluidAmountScaled = this.tank.getScaledFluidAmount();
        this.recalculateFuelQuality();
        this.redstoneMode = tag.func_74771_c("redstoneMode");
        this.targetRange = tag.func_74771_c("targetRange");
        this.range = tag.func_74771_c("range");
        this.sideConnected = EnumFacing.func_82600_a((int)tag.func_74771_c("sideConnected"));
        this.inventory.deserializeNBT(tag.func_74775_l("Items"));
    }

    @Override
    public boolean redstoneAllows() {
        return this.redstoneMode == 3 || super.redstoneAllows();
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 3) {
                this.redstoneMode = 0;
            }
        } else if (buttonID > 0 && buttonID <= 30) {
            this.targetRange = buttonID;
        }
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public int getRange() {
        return this.range;
    }

    public int getTargetRange() {
        return this.targetRange;
    }

    public int getFuel() {
        return this.fuel;
    }

    public EnumFacing getSideConnected() {
        return this.sideConnected;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public String getName() {
        return Blockss.KEROSENE_LAMP.func_149739_a();
    }

    public float getFuelQuality() {
        return this.fuelQuality;
    }

    @Override
    public String getRedstoneButtonText(int mode) {
        if (mode == 3) {
            return "gui.tab.redstoneBehaviour.keroseneLamp.button.interpolate";
        }
        return super.getRedstoneButtonText(mode);
    }

    @Override
    @Nonnull
    public Map<String, FluidTank> getSerializableTanks() {
        return ImmutableMap.of((Object)"Tank", (Object)((Object)this.tank));
    }

    @Override
    public void updateScaledFluidAmount(int tankIndex, int amount) {
        this.fluidAmountScaled = amount;
    }
}

