/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.item.ItemAssemblyProgram;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.recipes.programs.AssemblyProgram;
import me.desht.pneumaticcraft.common.tileentity.FilteredItemStackHandler;
import me.desht.pneumaticcraft.common.tileentity.IAssemblyMachine;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.IResettable;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyDrill;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyIOUnit;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyLaser;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyPlatform;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityAssemblyController
extends TileEntityPneumaticBase
implements IAssemblyMachine,
IMinWorkingPressure {
    private final AssemblyControllerHandler inventory = new AssemblyControllerHandler();
    @DescSynced
    public boolean[] sidesConnected = new boolean[6];
    public AssemblyProgram curProgram;
    private static final int INVENTORY_SIZE = 1;
    @GuiSynced
    public boolean foundAllMachines;
    @GuiSynced
    private boolean foundDuplicateMachine;
    private boolean goingToHomePosition;
    @DescSynced
    public String displayedText = "";
    public static final int PROGRAM_INVENTORY_INDEX = 0;
    @DescSynced
    public boolean hasProblem;

    @Override
    public IItemHandlerModifiable getPrimaryInventory() {
        return this.inventory;
    }

    public TileEntityAssemblyController() {
        super(5.0f, 7.0f, 2000, 4);
        this.addApplicableUpgrade(IItemRegistry.EnumUpgrade.SPEED);
    }

    @Override
    public void func_73660_a() {
        ItemStack programStack = this.inventory.getStackInSlot(0);
        if (this.curProgram == null && !this.goingToHomePosition && programStack.func_77973_b() == Itemss.ASSEMBLY_PROGRAM) {
            this.curProgram = ItemAssemblyProgram.getProgramFromItem(programStack.func_77960_j());
        } else if (this.curProgram != null && (programStack.func_190926_b() || this.curProgram.getClass() != ItemAssemblyProgram.getProgramFromItem(programStack.func_77960_j()).getClass())) {
            this.curProgram = null;
            if (!this.func_145831_w().field_72995_K) {
                this.goingToHomePosition = true;
            }
        }
        if (!this.func_145831_w().field_72995_K) {
            this.setStatus("Standby");
            if (this.getPressure() >= 3.5f && (this.curProgram != null || this.goingToHomePosition)) {
                List<IAssemblyMachine> machineList = this.getMachines();
                AssemblyProgram.EnumMachine[] requiredMachines = this.curProgram != null ? this.curProgram.getRequiredMachines() : AssemblyProgram.EnumMachine.values();
                TileEntityAssemblyDrill drill = null;
                TileEntityAssemblyLaser laser = null;
                TileEntityAssemblyIOUnit ioUnitImport = null;
                TileEntityAssemblyIOUnit ioUnitExport = null;
                TileEntityAssemblyPlatform platform = null;
                this.foundDuplicateMachine = false;
                boolean[] foundMachines = new boolean[requiredMachines.length];
                for (IAssemblyMachine machine : machineList) {
                    if (machine != this && machine instanceof TileEntityAssemblyController) {
                        this.foundDuplicateMachine = true;
                    }
                    block8: for (int i = 0; i < requiredMachines.length; ++i) {
                        switch (requiredMachines[i]) {
                            case DRILL: {
                                if (!(machine instanceof TileEntityAssemblyDrill)) continue block8;
                                if (drill != null) {
                                    this.foundDuplicateMachine = true;
                                }
                                drill = (TileEntityAssemblyDrill)machine;
                                foundMachines[i] = true;
                                continue block8;
                            }
                            case LASER: {
                                if (!(machine instanceof TileEntityAssemblyLaser)) continue block8;
                                if (laser != null) {
                                    this.foundDuplicateMachine = true;
                                }
                                laser = (TileEntityAssemblyLaser)machine;
                                foundMachines[i] = true;
                                continue block8;
                            }
                            case IO_UNIT_IMPORT: {
                                if (!(machine instanceof TileEntityAssemblyIOUnit) || !((TileEntityAssemblyIOUnit)machine).isImportUnit()) continue block8;
                                if (ioUnitImport != null) {
                                    this.foundDuplicateMachine = true;
                                }
                                ioUnitImport = (TileEntityAssemblyIOUnit)machine;
                                foundMachines[i] = true;
                                continue block8;
                            }
                            case IO_UNIT_EXPORT: {
                                if (!(machine instanceof TileEntityAssemblyIOUnit) || ((TileEntityAssemblyIOUnit)machine).isImportUnit()) continue block8;
                                if (ioUnitExport != null) {
                                    this.foundDuplicateMachine = true;
                                }
                                ioUnitExport = (TileEntityAssemblyIOUnit)machine;
                                foundMachines[i] = true;
                                continue block8;
                            }
                            case PLATFORM: {
                                if (!(machine instanceof TileEntityAssemblyPlatform)) continue block8;
                                if (platform != null) {
                                    this.foundDuplicateMachine = true;
                                }
                                platform = (TileEntityAssemblyPlatform)machine;
                                foundMachines[i] = true;
                            }
                        }
                    }
                }
                this.foundAllMachines = true;
                for (Object foundMachine : (Object)foundMachines) {
                    if (foundMachine != false) continue;
                    this.foundAllMachines = false;
                    break;
                }
                if ((this.foundAllMachines || this.curProgram == null) && !this.foundDuplicateMachine) {
                    boolean useAir;
                    if (this.curProgram != null) {
                        useAir = this.curProgram.executeStep(this, platform, ioUnitImport, ioUnitExport, drill, laser);
                        if (useAir) {
                            this.setStatus("Running...");
                        }
                    } else {
                        useAir = true;
                        this.goToHomePosition(platform, ioUnitImport, ioUnitExport, drill, laser);
                        this.setStatus("Resetting...");
                    }
                    if (useAir) {
                        this.addAir(-((int)(2.0f * this.getSpeedUsageMultiplierFromUpgrades())));
                    }
                    float speedMultiplier = this.getSpeedMultiplierFromUpgrades();
                    for (IAssemblyMachine machine : machineList) {
                        machine.setSpeed(speedMultiplier);
                    }
                }
            }
            this.hasProblem = this.hasProblem();
        }
        super.func_73660_a();
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    private void setStatus(String text) {
        this.displayedText = text;
    }

    private void goToHomePosition(TileEntityAssemblyPlatform platform, TileEntityAssemblyIOUnit ioUnitImport, TileEntityAssemblyIOUnit ioUnitExport, TileEntityAssemblyDrill drill, TileEntityAssemblyLaser laser) {
        boolean resetDone = true;
        for (IResettable machine : new IResettable[]{drill, laser, ioUnitImport, platform, ioUnitExport}) {
            if (machine == null || machine.reset()) continue;
            resetDone = false;
            if (machine != platform || ioUnitExport == null) break;
            ioUnitExport.pickupItem(null);
            break;
        }
        this.goingToHomePosition = !this.foundAllMachines || !resetDone;
    }

    public void addProblems(List<String> problemList) {
        if (this.getPressure() < 3.5f) {
            problemList.add(TextFormatting.GRAY + "No sufficient pressure.");
            problemList.add(TextFormatting.BLACK + "Add pressure.");
        }
        if (this.curProgram == null) {
            problemList.add(TextFormatting.GRAY + "There's no program to run.");
            problemList.add(TextFormatting.BLACK + "Insert an Assembly Program.");
        } else if (this.foundDuplicateMachine) {
            problemList.addAll(PneumaticCraftUtils.convertStringIntoList(TextFormatting.GRAY + "Controller found a duplicate machine!", 26));
            problemList.addAll(PneumaticCraftUtils.convertStringIntoList(TextFormatting.BLACK + "Remove it so there is one machine of each type.", 26));
        } else if (this.foundAllMachines) {
            this.curProgram.addProgramProblem(problemList);
        } else {
            problemList.addAll(PneumaticCraftUtils.convertStringIntoList(TextFormatting.GRAY + "Not all machines required for this program are available.", 26));
            problemList.addAll(PneumaticCraftUtils.convertStringIntoList(TextFormatting.BLACK + "Connect up the other required machines.", 26));
        }
    }

    private boolean hasProblem() {
        ArrayList<String> textList = new ArrayList<String>();
        if (this.curProgram != null) {
            this.curProgram.addProgramProblem(textList);
        }
        return !this.foundAllMachines || this.foundDuplicateMachine || this.getPressure() < 3.5f || this.curProgram == null || textList.size() > 0;
    }

    public List<IAssemblyMachine> getMachines() {
        ArrayList<IAssemblyMachine> machineList = new ArrayList<IAssemblyMachine>();
        this.getMachines(machineList, this.func_174877_v());
        return machineList;
    }

    public boolean areAllMachinesDone(List<IAssemblyMachine> machineList) {
        for (IAssemblyMachine machine : machineList) {
            if (machine.isIdle()) continue;
            return false;
        }
        return true;
    }

    private void getMachines(List<IAssemblyMachine> machineList, BlockPos pos) {
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            TileEntity te = this.func_145831_w().func_175625_s(pos.func_177972_a(dir));
            if (!(te instanceof IAssemblyMachine) || machineList.contains(te)) continue;
            machineList.add((IAssemblyMachine)te);
            this.getMachines(machineList, te.func_174877_v());
        }
    }

    @Override
    public void onNeighborBlockUpdate() {
        super.onNeighborBlockUpdate();
        this.updateConnections();
    }

    private void updateConnections() {
        List<Pair<EnumFacing, IAirHandler>> connections = this.getAirHandler(null).getConnectedPneumatics();
        Arrays.fill(this.sidesConnected, false);
        for (Pair<EnumFacing, IAirHandler> entry : connections) {
            this.sidesConnected[((EnumFacing)entry.getKey()).ordinal()] = true;
        }
    }

    @Override
    public boolean isConnectedTo(EnumFacing side) {
        return side != EnumFacing.UP;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1));
    }

    @Override
    public String getName() {
        return Blockss.ASSEMBLY_CONTROLLER.func_149739_a();
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.goingToHomePosition = tag.func_74767_n("goingToHomePosition");
        this.foundAllMachines = tag.func_74767_n("foundAllMachines");
        this.foundDuplicateMachine = tag.func_74767_n("foundDuplicate");
        this.displayedText = tag.func_74779_i("displayedText");
        for (int i = 0; i < 6; ++i) {
            this.sidesConnected[i] = tag.func_74767_n("sideConnected" + i);
        }
        this.inventory.deserializeNBT(tag.func_74775_l("Items"));
        if (!this.inventory.getStackInSlot(0).func_190926_b()) {
            this.curProgram = ItemAssemblyProgram.getProgramFromItem(this.inventory.getStackInSlot(0).func_77960_j());
            if (this.curProgram != null) {
                this.curProgram.readFromNBT(tag);
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("goingToHomePosition", this.goingToHomePosition);
        tag.func_74757_a("foundAllMachines", this.foundAllMachines);
        tag.func_74757_a("foundDuplicate", this.foundDuplicateMachine);
        tag.func_74778_a("displayedText", this.displayedText);
        if (this.curProgram != null) {
            this.curProgram.writeToNBT(tag);
        }
        for (int i = 0; i < 6; ++i) {
            tag.func_74757_a("sideConnected" + i, this.sidesConnected[i]);
        }
        tag.func_74782_a("Items", (NBTBase)this.inventory.serializeNBT());
        return tag;
    }

    @Override
    public boolean isIdle() {
        return true;
    }

    @Override
    public void setSpeed(float speed) {
    }

    @Override
    public float getMinWorkingPressure() {
        return 3.5f;
    }

    private static class AssemblyControllerHandler
    extends FilteredItemStackHandler {
        AssemblyControllerHandler() {
            super(1);
        }

        @Override
        public boolean test(Integer integer, ItemStack itemStack) {
            return itemStack.func_190926_b() || itemStack.func_77973_b() == Itemss.ASSEMBLY_PROGRAM;
        }
    }
}

