/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.client.gui.GuiUtils;
import me.desht.pneumaticcraft.client.gui.widget.IGuiWidget;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTank;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTemperature;
import me.desht.pneumaticcraft.common.thirdparty.jei.PositionedStack;
import me.desht.pneumaticcraft.common.thirdparty.jei.ResourceDrawable;
import me.desht.pneumaticcraft.lib.Textures;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.FMLClientHandler;

public abstract class PneumaticCraftCategory<T extends IRecipeWrapper>
implements IRecipeCategory<T> {
    private final IGuiHelper guiHelper;
    private final ResourceDrawable background = this.getGuiTexture();
    private static ITickTimer tickTimer;

    public PneumaticCraftCategory(IJeiHelpers jeiHelpers) {
        this.guiHelper = jeiHelpers.getGuiHelper();
        tickTimer = this.guiHelper.createTickTimer(60, 60, false);
    }

    @Nonnull
    public String getModName() {
        return "PneumaticCraft: Repressurized";
    }

    static void drawAnimatedPressureGauge(int x, int y, float minPressure, float minWorkingPressure, float dangerPressure, float maxPressure) {
        float p2 = minWorkingPressure > 0.0f ? minWorkingPressure * ((float)tickTimer.getValue() / (float)tickTimer.getMaxValue()) : -1.0f - minWorkingPressure * ((float)tickTimer.getValue() / (float)tickTimer.getMaxValue());
        GuiUtils.drawPressureGauge(FMLClientHandler.instance().getClient().field_71466_p, minPressure, maxPressure, dangerPressure, minWorkingPressure, p2, x, y, 90.0f);
    }

    public abstract ResourceDrawable getGuiTexture();

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    void drawProgressBar(int x, int y, int u, int v, int width, int height, IDrawableAnimated.StartDirection startDirection) {
        IDrawableStatic drawable = this.guiHelper.createDrawable(this.background.getResource(), u, v, width, height);
        IDrawableAnimated animation = this.guiHelper.createAnimatedDrawable(drawable, 60, startDirection, false);
        animation.draw(Minecraft.func_71410_x(), x, y);
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        if (recipeWrapper instanceof MultipleInputOutputRecipeWrapper) {
            ResourceDrawable tankOverlay;
            WidgetTank tank;
            int i;
            MultipleInputOutputRecipeWrapper recipe = (MultipleInputOutputRecipeWrapper)recipeWrapper;
            for (i = 0; i < ingredients.getInputs(ItemStack.class).size(); ++i) {
                recipeLayout.getItemStacks().init(i, true, ((PositionedStack)recipe.input.get(i)).getX() - 1, ((PositionedStack)recipe.input.get(i)).getY() - 1);
                recipeLayout.getItemStacks().set(i, ((PositionedStack)recipe.input.get(i)).getStacks());
            }
            for (i = 0; i < ingredients.getOutputs(ItemStack.class).size(); ++i) {
                recipeLayout.getItemStacks().init(i + recipe.input.size(), false, ((PositionedStack)recipe.output.get(i)).getX() - 1, ((PositionedStack)recipe.output.get(i)).getY() - 1);
                recipeLayout.getItemStacks().set(i + recipe.input.size(), ((PositionedStack)recipe.output.get(i)).getStacks());
            }
            for (i = 0; i < ingredients.getInputs(FluidStack.class).size(); ++i) {
                tank = (WidgetTank)recipe.inputLiquids.get(i);
                tankOverlay = new ResourceDrawable(Textures.WIDGET_TANK, 0, 0, 0, 0, tank.getBounds().width, tank.getBounds().height, tank.getBounds().width, tank.getBounds().height);
                recipeLayout.getFluidStacks().init(i, true, tank.x, tank.y, tank.getBounds().width, tank.getBounds().height, tank.getTank().getCapacity(), true, (IDrawable)tankOverlay);
                recipeLayout.getFluidStacks().set(i, tank.getFluid());
            }
            for (i = 0; i < ingredients.getOutputs(FluidStack.class).size(); ++i) {
                tank = (WidgetTank)recipe.outputLiquids.get(i);
                tankOverlay = new ResourceDrawable(Textures.WIDGET_TANK, 0, 0, 0, 0, tank.getBounds().width, tank.getBounds().height, tank.getBounds().width, tank.getBounds().height);
                recipeLayout.getFluidStacks().init(recipe.inputLiquids.size() + i, false, tank.x, tank.y, tank.getBounds().width, tank.getBounds().height, tank.getTank().getCapacity(), true, (IDrawable)tankOverlay);
                recipeLayout.getFluidStacks().set(recipe.inputLiquids.size() + i, tank.getFluid());
            }
        }
    }

    public static class MultipleInputOutputRecipeWrapper
    implements IRecipeWrapper {
        private final List<PositionedStack> input = new ArrayList<PositionedStack>();
        private final List<PositionedStack> output = new ArrayList<PositionedStack>();
        private final List<WidgetTank> inputLiquids = new ArrayList<WidgetTank>();
        private final List<WidgetTank> outputLiquids = new ArrayList<WidgetTank>();
        private final List<IGuiWidget> tooltipWidgets = new ArrayList<IGuiWidget>();
        private float pressure;
        private boolean usePressure;
        private int gaugeX;
        private int gaugeY;
        private WidgetTemperature tempWidget;
        private IHeatExchangerLogic heatExchanger;

        public void getIngredients(@Nonnull IIngredients ingredients) {
            ingredients.setInputLists(ItemStack.class, this.input.stream().map(PositionedStack::getStacks).collect(Collectors.toList()));
            ingredients.setInputs(FluidStack.class, this.inputLiquids.stream().map(WidgetTank::getFluid).collect(Collectors.toList()));
            ingredients.setOutputLists(ItemStack.class, this.output.stream().map(PositionedStack::getStacks).collect(Collectors.toList()));
            ingredients.setOutputs(FluidStack.class, this.outputLiquids.stream().map(WidgetTank::getFluid).collect(Collectors.toList()));
        }

        void addIngredient(PositionedStack stack) {
            this.input.add(stack);
        }

        public void addIngredient(PositionedStack[] stacks) {
            Collections.addAll(this.input, stacks);
        }

        void addOutput(PositionedStack stack) {
            this.output.add(stack);
        }

        void addInputLiquid(FluidStack liquid, int x, int y) {
            WidgetTank tank = new WidgetTank(x, y, liquid);
            this.addInputLiquid(tank);
        }

        void addInputLiquid(WidgetTank tank) {
            this.inputLiquids.add(tank);
            this.recalculateTankSizes();
        }

        void addOutputLiquid(FluidStack liquid, int x, int y) {
            WidgetTank tank = new WidgetTank(x, y, liquid);
            this.addOutputLiquid(tank);
        }

        void addOutputLiquid(WidgetTank tank) {
            this.outputLiquids.add(tank);
            this.recalculateTankSizes();
        }

        private void recalculateTankSizes() {
            int maxFluid = 0;
            for (WidgetTank w : this.inputLiquids) {
                maxFluid = Math.max(maxFluid, w.getTank().getFluidAmount());
            }
            for (WidgetTank w : this.outputLiquids) {
                maxFluid = Math.max(maxFluid, w.getTank().getFluidAmount());
            }
            maxFluid = maxFluid <= 10 ? 10 : (maxFluid <= 100 ? 100 : (maxFluid <= 1000 ? 1000 : 16000));
            for (WidgetTank w : this.inputLiquids) {
                w.getTank().setCapacity(maxFluid);
            }
            for (WidgetTank w : this.outputLiquids) {
                w.getTank().setCapacity(maxFluid);
            }
        }

        protected void addWidget(IGuiWidget widget) {
            this.tooltipWidgets.add(widget);
        }

        void setUsedPressure(int x, int y, float pressure) {
            this.usePressure = true;
            this.pressure = pressure;
            this.gaugeX = x;
            this.gaugeY = y;
        }

        void setUsedTemperature(int x, int y, double temperature) {
            this.heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().getHeatExchangerLogic();
            this.tempWidget = new WidgetTemperature(0, x, y, 273, 673, this.heatExchanger, (int)temperature);
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            for (IGuiWidget widget : this.tooltipWidgets) {
                widget.render(0, 0, 0.0f);
            }
            if (this.usePressure) {
                PneumaticCraftCategory.drawAnimatedPressureGauge(this.gaugeX, this.gaugeY, -1.0f, this.pressure, 5.0f, 7.0f);
            }
            if (this.tempWidget != null) {
                this.heatExchanger.setTemperature(tickTimer.getValue() * (this.tempWidget.getScales()[0] - 273) / tickTimer.getMaxValue() + 273);
                this.tempWidget.render(0, 0, 0.0f);
            }
        }

        @Nonnull
        public List<String> getTooltipStrings(int mouseX, int mouseY) {
            ArrayList<String> currenttip = new ArrayList<String>();
            Point mouse = new Point(mouseX, mouseY);
            for (IGuiWidget widget : this.tooltipWidgets) {
                if (!widget.getBounds().contains(mouse)) continue;
                widget.addTooltip(mouse.x, mouse.y, currenttip, false);
            }
            if (this.tempWidget != null && this.tempWidget.getBounds().contains(mouse)) {
                this.heatExchanger.setTemperature(this.tempWidget.getScales()[0]);
                this.tempWidget.addTooltip(mouse.x, mouse.y, currenttip, false);
            }
            return currenttip;
        }

        public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
            return false;
        }
    }
}

