/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.crafttweaker.util;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.oredict.IOreDictEntry;
import crafttweaker.mc1120.item.MCItemStack;
import crafttweaker.mc1120.liquid.MCLiquidStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;

public class Helper {
    private Helper() {
    }

    public static Pair<String, Integer> toPair(IOreDictEntry entry) {
        return Pair.of((Object)entry.getName(), (Object)entry.getAmount());
    }

    public static Object[] toInput(IIngredient[] input) {
        ArrayList<Object> inputs = new ArrayList<Object>();
        for (int i = 0; i < input.length; ++i) {
            if (input[i] instanceof IOreDictEntry) {
                inputs.add(Helper.toPair((IOreDictEntry)input[i]));
                continue;
            }
            if (!(input[i] instanceof IItemStack)) continue;
            inputs.add(Helper.toStack((IItemStack)input[i]));
        }
        return inputs.toArray(new Object[inputs.size()]);
    }

    public static void logError(String message) {
        CraftTweakerAPI.logError((String)message);
    }

    public static void logError(String message, Throwable exception) {
        CraftTweakerAPI.logError((String)message, (Throwable)exception);
    }

    public static void logWarning(String message) {
        CraftTweakerAPI.logWarning((String)message);
    }

    public static void logInfo(String message) {
        CraftTweakerAPI.logInfo((String)message);
    }

    public static ItemStack toStack(IItemStack iStack) {
        if (iStack == null) {
            return ItemStack.field_190927_a;
        }
        Object internal = iStack.getInternal();
        if (!(internal instanceof ItemStack)) {
            Helper.logError("Not a valid item stack: " + iStack);
        }
        return (ItemStack)internal;
    }

    public static IItemStack[] toStacks(IIngredient[] iIngredient) {
        return (IItemStack[])Stream.of(iIngredient).map(i -> i.getItems()).flatMap(Collection::stream).toArray(IItemStack[]::new);
    }

    public static ItemStack[] toStacks(IItemStack[] iStack) {
        return (ItemStack[])Stream.of(iStack).map(Helper::toStack).toArray(ItemStack[]::new);
    }

    public static FluidStack toFluid(ILiquidStack iStack) {
        if (iStack == null) {
            return null;
        }
        return FluidRegistry.getFluidStack((String)iStack.getName(), (int)iStack.getAmount());
    }

    public static ILiquidStack toILiquidStack(FluidStack stack) {
        if (stack == null) {
            return null;
        }
        return new MCLiquidStack(stack);
    }

    public static String getStackDescription(Object object) {
        if (object instanceof IIngredient) {
            return Helper.getStackDescription((IIngredient)object);
        }
        if (object instanceof ItemStack) {
            return Helper.toIItemStack((ItemStack)object).toString();
        }
        if (object instanceof FluidStack) {
            return Helper.getStackDescription((FluidStack)object);
        }
        if (object instanceof Block) {
            return Helper.toIItemStack(new ItemStack((Block)object, 1, 0)).toString();
        }
        if (object instanceof String) {
            NonNullList ores = OreDictionary.getOres((String)((String)object));
            if (!ores.isEmpty()) {
                return "<ore:" + (String)object + ">";
            }
            return "\"" + (String)object + "\"";
        }
        if (object instanceof List) {
            return Helper.getListDescription((List)object);
        }
        if (object instanceof Object[]) {
            return Helper.getListDescription(Arrays.asList((Object[])object));
        }
        if (object != null) {
            return "\"" + object.toString() + "\"";
        }
        if (object instanceof Ingredient && !((Ingredient)object).apply(ItemStack.field_190927_a) && ((Ingredient)object).func_193365_a().length > 0) {
            return Helper.getStackDescription(((Ingredient)object).func_193365_a()[0]);
        }
        return "null";
    }

    public static String getStackDescription(IIngredient stack) {
        Object internalObject = stack.getInternal();
        if (internalObject instanceof ItemStack) {
            return Helper.getStackDescription((ItemStack)internalObject);
        }
        if (internalObject instanceof FluidStack) {
            return Helper.getStackDescription((FluidStack)internalObject);
        }
        if (internalObject instanceof IOreDictEntry) {
            return Helper.getStackDescription(((IOreDictEntry)internalObject).getName());
        }
        return "null";
    }

    public static String getStackDescription(FluidStack stack) {
        StringBuilder sb = new StringBuilder();
        sb.append("<liquid:").append(stack.getFluid().getName()).append('>');
        if (stack.amount > 1) {
            sb.append(" * ").append(stack.amount);
        }
        return sb.toString();
    }

    public static String getListDescription(List<?> objects) {
        StringBuilder sb = new StringBuilder();
        if (objects.isEmpty()) {
            sb.append("[]");
        } else {
            sb.append('[');
            for (Object object : objects) {
                if (object instanceof List) {
                    sb.append(Helper.getListDescription((List)object)).append(", ");
                    continue;
                }
                if (object instanceof Object[]) {
                    sb.append(Helper.getListDescription(Arrays.asList((Object[])object))).append(", ");
                    continue;
                }
                sb.append(Helper.getStackDescription(object)).append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(']');
        }
        return sb.toString();
    }

    public static IItemStack toIItemStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        return new MCItemStack(stack);
    }

    public static FluidStack[] toFluids(ILiquidStack[] iStack) {
        return (FluidStack[])Stream.of(iStack).map(Helper::toFluid).toArray(FluidStack[]::new);
    }

    public static boolean matches(IIngredient ingredient, IItemStack itemStack) {
        if (ingredient == null) {
            return false;
        }
        return ingredient.matches(itemStack);
    }

    public static boolean matches(IIngredient ingredient, IItemStack[] itemStack) {
        if (ingredient == null) {
            return false;
        }
        return Stream.of(itemStack).allMatch(i -> ingredient.matches(i));
    }

    public static boolean matches(IIngredient ingredient, ILiquidStack liquidStack) {
        if (ingredient == null) {
            return false;
        }
        if (ingredient.matches(liquidStack)) {
            return true;
        }
        if (ingredient.getLiquids() != null) {
            for (ILiquidStack liquid : ingredient.getLiquids()) {
                if (!Helper.toFluid(liquid).isFluidEqual(Helper.toFluid(liquidStack))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean areEqual(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_190926_b() || stack2.func_190926_b()) {
            return false;
        }
        return stack1.func_77969_a(stack2);
    }

    public static boolean areEqual(FluidStack stack1, FluidStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        return stack1.isFluidEqual(stack2);
    }
}

