/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.crafttweaker.handlers;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.List;
import java.util.stream.Stream;
import me.desht.pneumaticcraft.common.recipes.PressureChamberRecipe;
import me.desht.pneumaticcraft.common.thirdparty.crafttweaker.CraftTweaker;
import me.desht.pneumaticcraft.common.thirdparty.crafttweaker.util.Helper;
import me.desht.pneumaticcraft.common.thirdparty.crafttweaker.util.ListAddition;
import me.desht.pneumaticcraft.common.thirdparty.crafttweaker.util.ListRemoval;
import me.desht.pneumaticcraft.common.thirdparty.crafttweaker.util.RemoveAllRecipes;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.pneumaticcraft.pressurechamber")
@ZenRegister
public class PressureChamber {
    public static final String name = "PneumaticCraft Pressure Chamber";

    @ZenMethod
    public static void addRecipe(IIngredient[] input, double pressure, IItemStack[] output) {
        CraftTweaker.ADDITIONS.add(new Add(new PressureChamberRecipe(Helper.toInput(input), (float)pressure, Helper.toStacks(output))));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient[] output) {
        CraftTweaker.REMOVALS.add(new Remove(PressureChamberRecipe.chamberRecipes, output));
    }

    @ZenMethod
    public static void removeAllRecipes() {
        CraftTweaker.REMOVALS.add(new RemoveAllRecipes<PressureChamberRecipe>(name, PressureChamberRecipe.chamberRecipes));
    }

    private static class Remove
    extends ListRemoval<PressureChamberRecipe> {
        private final IIngredient[] output;

        public Remove(List<PressureChamberRecipe> recipes, IIngredient[] output) {
            super(PressureChamber.name, PressureChamberRecipe.chamberRecipes, recipes);
            this.output = output;
        }

        @Override
        public void apply() {
            this.addRecipes();
            super.apply();
        }

        private void addRecipes() {
            for (PressureChamberRecipe r : this.recipes) {
                if (!Stream.of(this.output).allMatch(o -> r.output.stream().anyMatch(ro -> Helper.matches(o, Helper.toIItemStack(ro))))) continue;
                this.entries.add(r);
            }
            if (this.entries.isEmpty()) {
                Helper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", this.name, Helper.getStackDescription(this.output)));
            } else {
                Helper.logInfo(String.format("Found %d %s Recipe(s) for %s.", this.entries.size(), this.name, Helper.getStackDescription(this.output)));
            }
        }

        @Override
        public String describe() {
            return String.format("Removing %s Recipe(s) for %s", this.name, Helper.getStackDescription(this.output[0]));
        }
    }

    private static class Add
    extends ListAddition<PressureChamberRecipe> {
        public Add(PressureChamberRecipe recipe) {
            super(PressureChamber.name, PressureChamberRecipe.chamberRecipes, recipe);
        }
    }
}

