/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.desht.pneumaticcraft.common.network.AbstractPacket;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PacketMultiHeader
extends AbstractPacket<PacketMultiHeader> {
    private int length;
    private String className;
    private static final Map<UUID, PayloadBuffer> payloadBuffers = new HashMap<UUID, PayloadBuffer>();

    public PacketMultiHeader() {
    }

    public PacketMultiHeader(int length, String className) {
        this.length = length;
        this.className = className;
    }

    public void fromBytes(ByteBuf buf) {
        this.length = buf.readInt();
        this.className = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.length);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.className);
    }

    @Override
    public void handleClientSide(PacketMultiHeader message, EntityPlayer player) {
    }

    @Override
    public void handleServerSide(PacketMultiHeader message, EntityPlayer player) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = PacketMultiHeader.class.getClassLoader();
            }
            Class<?> clazz = cl.loadClass(this.className.toString());
            payloadBuffers.put(player.func_110124_au(), new PayloadBuffer(clazz, this.length));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    static void receivePayload(EntityPlayer player, byte[] payload) {
        PayloadBuffer buffer = payloadBuffers.get(player.func_110124_au());
        if (buffer != null) {
            System.arraycopy(payload, 0, buffer.payload, buffer.offset, payload.length);
            buffer.offset += 32000;
            if (buffer.offset > buffer.payload.length) {
                try {
                    AbstractPacket packet = buffer.clazz.newInstance();
                    ByteBuf buf = Unpooled.wrappedBuffer((byte[])buffer.payload);
                    packet.fromBytes(buf);
                    packet.handleServerSide(packet, player);
                    payloadBuffers.remove(player.func_110124_au());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
            }
        } else {
            Log.error("Received unexpected multi-message payload from player " + player.func_70005_c_() + " - " + player.func_110124_au());
        }
    }

    private static class PayloadBuffer {
        final Class<? extends AbstractPacket> clazz;
        final byte[] payload;
        int offset;

        PayloadBuffer(Class<? extends AbstractPacket> clazz, int length) {
            this.clazz = clazz;
            this.payload = new byte[length];
        }
    }
}

