/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.NBTUtil;
import me.desht.pneumaticcraft.common.item.ItemPressurizable;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMinigun
extends ItemPressurizable {
    private final Minigun minigun = new MinigunItem();

    public ItemMinigun() {
        super("minigun", 30000, 3000);
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean currentItem) {
        super.func_77663_a(stack, world, entity, slot, currentItem);
        EntityPlayer player = (EntityPlayer)entity;
        this.getMinigun(stack, player);
        if (!currentItem) {
            this.minigun.setMinigunSoundCounter(-1);
            this.minigun.setMinigunSpeed(0.0);
            this.minigun.setMinigunActivated(false);
            this.minigun.setMinigunTriggerTimeOut(0);
        }
        this.minigun.update(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        if (world.field_72995_K && currentItem && this.minigun.getMinigunSpeed() > 0.0) {
            this.suppressSwitchAnimation();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void suppressSwitchAnimation() {
        Minecraft mc = Minecraft.func_71410_x();
        ItemRenderer renderer = mc.field_71460_t.field_78516_c;
        renderer.func_78441_a();
        renderer.field_187469_f = 1.0f;
        renderer.field_187470_g = 1.0f;
    }

    public Minigun getMinigun(ItemStack stack, EntityPlayer player) {
        this.minigun.setItemStack(stack).setAmmo(this.getAmmo(player)).setPlayer(player).setPressurizable(this, 20).setWorld(player.field_70170_p);
        return this.minigun;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand handIn) {
        boolean usedAmmo;
        ItemStack ammo;
        ItemStack stack = player.func_184586_b(handIn);
        if (!world.field_72995_K && !(ammo = this.getAmmo(player)).func_190926_b() && (usedAmmo = this.getMinigun(stack, player).tryFireMinigun(null))) {
            PneumaticCraftUtils.consumeInventoryItem(player.field_71071_by, Itemss.GUN_AMMO);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    private ItemStack getAmmo(EntityPlayer player) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_77973_b() != Itemss.GUN_AMMO) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    private class MinigunItem
    extends Minigun {
        public MinigunItem() {
            super(false);
        }

        @Override
        public boolean isMinigunActivated() {
            return NBTUtil.getBoolean(this.stack, "activated");
        }

        @Override
        public void setMinigunActivated(boolean activated) {
            NBTUtil.setBoolean(this.stack, "activated", activated);
        }

        @Override
        public void setAmmoColorStack(@Nonnull ItemStack ammo) {
            if (!ammo.func_190926_b()) {
                NBTTagCompound tag = new NBTTagCompound();
                ammo.func_77955_b(tag);
                NBTUtil.setCompoundTag(this.stack, "ammoColorStack", (NBTBase)tag);
            } else {
                NBTUtil.removeTag(this.stack, "ammoColorStack");
            }
        }

        @Override
        public int getAmmoColor() {
            ItemStack ammo = ItemStack.field_190927_a;
            if (NBTUtil.hasTag(this.stack, "ammoColorStack")) {
                NBTTagCompound tag = NBTUtil.getCompoundTag(this.stack, "ammoColorStack");
                ammo = new ItemStack(tag);
            }
            return this.getAmmoColor(ammo);
        }

        @Override
        public void playSound(SoundEvent soundName, float volume, float pitch) {
            NetworkHandler.sendToAllAround(new PacketPlaySound(soundName, SoundCategory.PLAYERS, this.player.func_180425_c(), volume, pitch, false), this.world);
        }

        @Override
        public double getMinigunSpeed() {
            return NBTUtil.getDouble(this.stack, "speed");
        }

        @Override
        public void setMinigunSpeed(double minigunSpeed) {
            NBTUtil.setDouble(this.stack, "speed", minigunSpeed);
        }

        @Override
        public int getMinigunTriggerTimeOut() {
            return NBTUtil.getInteger(this.stack, "triggerTimeout");
        }

        @Override
        public void setMinigunTriggerTimeOut(int minigunTriggerTimeOut) {
            NBTUtil.setInteger(this.stack, "triggerTimeout", minigunTriggerTimeOut);
        }

        @Override
        public int getMinigunSoundCounter() {
            return NBTUtil.getInteger(this.stack, "soundCounter");
        }

        @Override
        public void setMinigunSoundCounter(int minigunSoundCounter) {
            NBTUtil.setInteger(this.stack, "soundCounter", minigunSoundCounter);
        }

        @Override
        public double getMinigunRotation() {
            return NBTUtil.getDouble(this.stack, "rotation");
        }

        @Override
        public void setMinigunRotation(double minigunRotation) {
            NBTUtil.setDouble(this.stack, "rotation", minigunRotation);
        }

        @Override
        public double getOldMinigunRotation() {
            return NBTUtil.getDouble(this.stack, "oldRotation");
        }

        @Override
        public void setOldMinigunRotation(double oldMinigunRotation) {
            NBTUtil.setDouble(this.stack, "oldRotation", oldMinigunRotation);
        }
    }
}

